barra = {}
local max = {hp = 20}
local players = {}

local escala = 0.023
minetest.register_entity("rpghp:entity", {
	visual = "sprite",
	visual_size = {x = 60 * escala, y = 13 * escala}, 
	textures = {"blank.png"},
	physical = false,
	makes_footstep_sound = false,
	backface_culling = false,
	static_save = false,
	pointable = false,
	on_punch = function() return true end,
})
local function escalar(player, field)
	local current = player["get_" .. field](player)
	local escala_m = math.max(player:get_properties()[field .. "_max"], current)
	if escala_m == 0 then
		return 0
	end
	return math.round(current * max[field] / escala_m)
end
local function ent(player)
	local pname = player:get_player_name()
	if not barra.can_show(player) then
		if players[pname] then
			players[pname].entity:remove()
			players[pname] = nil
			return false
		end
		return false
	end
	if players[pname] then
		if players[pname].entity and players[pname].entity:get_luaentity() then
			return true
		else
			players[pname].entity:remove()
		end
	end
	local entity = minetest.add_entity(player:get_pos(), "rpghp:entity")
	entity:set_attach(player, "", {x=-0.5, y=23, z=0}, {x=100, y=0, z=0})
	if not players[pname] then
		players[pname] = {entity=entity}
	else
		players[pname].entity = entity
	end
	return true
end

local function act_ent(player, nuevo_ic)
	local pname = player:get_player_name()
	local hp = escalar(player, "hp")
	players[pname].hp = hp
	local health_t = "blank.png"
	local prop = players[pname].entity:get_properties()
	if hp > 0 then
		health_t = "barra_jugador" .. hp .. ".png"
	end
	if prop.textures[1] ~= health_t or nuevo_ic then
		if players[pname].icon and players[pname].icon ~= "" then
			players[pname].entity:set_properties({textures = {
				"[combine:60x13:-2,0="..health_t..":0,3="..players[pname].icon
			}})
		else
			players[pname].entity:set_properties({textures = {
				"[combine:60x13:-8,0="..health_t
			}})
		end
	end
end

minetest.register_playerevent(function(player, sucd)
	if sucd == "health_changed" or sucd == "properties_changed" then
		if players[player:get_player_name()] ~= nil then
			act_ent(player)
		end
	end
end)

function barra.can_show(player)
	return true
end

minetest.register_on_joinplayer(function(player)
	if ent(player) then
		act_ent(player)
	end
end)

minetest.register_on_leaveplayer(function(player)
	local pname = player:get_player_name()
	if players[pname] ~= nil then
		players[pname].entity:remove()
		players[pname] = nil
	end
end)

