hpbar = {}
local max = {hp = 20}
local jugador = {}
local escala = 0.023
rpghp = {}

rpghp.hp_bar_1 = minetest.settings:get_bool("rpghp_hp_bar_1")

minetest.register_entity("rpghp:bar", {
	visual = "sprite",
	visual_size = {x = 75 * escala, y = 20 * escala},
	textures = {"blank.png"},
	physical = false,
	makes_footstep_sound = false,
	backface_culling = false,
	static_save = false,
	pointable = false,
	on_punch = function() return true end,
})

local function escalar(player, field)

	local actual = player["get_" .. field](player)
	local maximo = math.max(player:get_properties()[field .. "_max"], actual)
	if maximo == 0 then
		return 0
	end
	return math.round(actual * max[field] / maximo)
end

local function entidad(player)
	local name = player:get_player_name()

	if jugador[name] then
		if jugador[name].entity and jugador[name].entity:get_luaentity() then
			return true
		else
			jugador[name].entity:remove()
		end
	end

	local entity = minetest.add_entity(player:get_pos(), "rpghp:bar")

	entity:set_attach(player, "", {x=0, y=18.8, z=0}, {x=0, y=0, z=0})

	if not jugador[name] then
		jugador[name] = {entity=entity}
	else
		jugador[name].entity = entity
	end

	return true
end

local function actualizar_entidad(player, textura)
	local name = player:get_player_name()
	local hp = escalar(player, "hp")

	if not jugador[name] or not jugador[name].entity or not jugador[name].entity:get_luaentity() then
		if not entidad(player) then
			return
		end
	end

	jugador[name].hp = hp

	local salud = "blank.png"
	local prop = jugador[name].entity:get_properties()

	if hp > 0 then
		if rpghp.hp_bar_1 == true then
		salud = "barra_jugador" .. hp .. ".png"
	else
		salud = "barra_jugador2" .. hp .. ".png"
        end
	end

	if textura and jugador[name].icon ~= textura then
		jugador[name].icon = textura
	else
		textura = false
	end

	if prop.textures[1] ~= salud or textura then
		if jugador[name].icon and jugador[name].icon ~= "" then
			jugador[name].entity:set_properties({textures = {
				"[combine:60x20:-2,0="..salud..":0,3="..jugador[name].icon
			}})
		else
			jugador[name].entity:set_properties({textures = {
				"[combine:60x20:-8,0="..salud
			}})
		end
	end
end

minetest.register_playerevent(function(player, eventname)
	if eventname == "health_changed" or eventname == "properties_changed" then
		if jugador[player:get_player_name()] ~= nil then
			actualizar_entidad(player)
		end
	end
end)


minetest.register_on_joinplayer(function(player)
	if entidad(player) then
		actualizar_entidad(player)
	end
end)

minetest.register_on_leaveplayer(function(player)
	local name = player:get_player_name()
	if jugador[name] ~= nil then
		jugador[name].entity:remove()
		jugador[name] = nil
	end
end)
