local news_enabled = true
local news_text = ""

local news_file_path = minetest.get_worldpath() .. "/news.txt"


local function load_news()
    local file = io.open(news_file_path, "r")
    if file then
        news_text = file:read("*all") 
        file:close()
    else
        news_text = "No hay noticias disponibles." 
    end
end

local function save_news()
    local file = io.open(news_file_path, "w")
    if file then
        file:write(news_text) 
        file:close()
    end
end

local function show_news_formspec(player_name)
    local formspec = "size[8,6]" ..
                     "label[0,0;" .. minetest.colorize("#07C8FC", "¡Bienvenido al servidor! / ¡Welcome to server!") .. "]"..
                     "label[0.5,1.5;Here you have the latest news.:]" ..
                     "textarea[0.5,2.5;7,3;news;;" .. news_text .. "]" ..
                     "button_exit[3,5;2,1;close;exit]"
    minetest.show_formspec(player_name, "news:formspec", formspec)
end

local function edit_news(player_name, new_text)
    news_text = new_text
    save_news()
    minetest.chat_send_player(player_name, "The news has been updated.")
end

minetest.register_on_joinplayer(function(player)
    if news_enabled then
        core.after(1, function(player)
            show_news_formspec(player:get_player_name())
        end, player)
    end
end)

minetest.register_chatcommand("news", {
    params = "",
    description = "Activa/desactiva las notificaciones de noticias para nuevos jugadores.",
    func = function(name)
        news_enabled = not news_enabled
        local status = news_enabled and "activadas" or "desactivadas"
        return true, "noticias del servidor: " .. status .. "."
    end,
})

minetest.register_chatcommand("edit_new", {
    params = "<texto>",
    description = "Edita las noticias.",
    privs = {server=true},
    func = function(name, param)
        edit_news(name, param)
        return true
    end,
})

-- Cargar las noticias al iniciar el servidor
load_news()