local function pantalla()
    return 10, 10
end

local x, y = pantalla()
local x1 = x + 1
local barracolor = "style[barra_ic;bgcolor=black;textcolor=white]"
local barra = "button[-0.5,13;" .. x1 .. ",5;barra_ic;]"
local logo = "background[0,0;10,10;logo.png;1]"
local icono = "image_button[0,14.8;0.90,0.80;inicio.png;inicio;]"
local tamano = "size[" .. x .. "," .. y .. ",true]"
local fondo = "#2a6478"

local base_calculadora =

    "label[1,1;Calculadora:]" ..
    "field[1,2;2,1;numero1;;]" ..
    "field[1,3;2,1;numero2;;]" ..
    "button[8,5;1,1;sumar;+]" ..
    "button[8,6;1,1;restar;-]" ..
    "button[8,7;1,1;dividir;/]" ..
    "button[8,8;1,1;multiplicar;*]" ..
    "button[7,5;1,1;raiz;√]" ..
    "button[7,6;1,1;seno;sen]" ..
    "button[7,7;1,1;coseno;cos]" ..
    "button[7,8;1,1;tangente;tan]" ..
    "button[6,5;1,1;log;log]" ..
    "button[6,6;1,1;exp;exp]" ..
    "button[6,7;1,1;log10;log10]" ..
    "button[0.8,4;2,2;volver_in;Volver]"

-------
function calculadora()
    local formspec = "size[" .. x .. "," .. y .. ",true]" ..
        base_calculadora ..
        barracolor ..
        barra ..
        icono..
        logo..
        "button[0.8,4;2,2;volver_in;Volver]"
    return formspec
end

minetest.register_on_player_receive_fields(function(player, formname, fields)
    if formname == "calculadora" then
        if fields.volver_in then
            if timer_active then
                iniciar_temporizador(player)
            end
            minetest.show_formspec(player:get_player_name(), "inicio", inicio(player:get_player_name()))
            return
        end

        if fields.numero1 == "" or fields.numero2 == "" then
            minetest.log("error", "Los campos de número no pueden estar vacíos.")
            return
        end
        local numero1 = tonumber(fields.numero1)
        local numero2 = tonumber(fields.numero2)

        if numero1 == nil or numero2 == nil then
            minetest.log("error", "Los campos deben contener números válidos.")
            return
        end

        local resultado = nil
        local operacion = ""

        if fields.sumar then
            resultado = numero1 + numero2
            operacion = "+"
        elseif fields.restar then
            resultado = numero1 - numero2
            operacion = "-"
        elseif fields.multiplicar then
            resultado = numero1 * numero2
            operacion = "*"
        elseif fields.dividir then
            if numero2 == 0 then
                resultado = "Error: División por cero"
            else
                resultado = numero1 / numero2
                operacion = "/"
            end
        elseif fields.raiz then
            if numero1 < 0 then
                resultado = "Error: Raíz de número negativo"
            else
                resultado = math.sqrt(numero1)
                operacion = "√"
            end
        elseif fields.seno then
            resultado = math.sin(numero1)
            operacion = "sen"
        elseif fields.coseno then
            resultado = math.cos(numero1)
            operacion = "cos"
        elseif fields.tangente then
            resultado = math.tan(numero1)
            operacion = "tan"
        elseif fields.log then
            if numero1 <= 0 then
                resultado = "Error: Logaritmo de número no positivo"
            else
                resultado = math.log(numero1)
                operacion = "log"
            end
        elseif fields.exp then
            resultado = math.exp(numero1)
            operacion = "exp"
        elseif fields.log10 then
            if numero1 <= 0 then
                resultado = "Error: Logaritmo base 10 de número no positivo"
            else
                resultado = math.log10(numero1)
                operacion = "log10"
            end
        end

        if resultado ~= nil then
            local formspec = "size[" .. x .. "," .. y .. ",true]" ..
                "bgcolor[" .. fondo .. "]" ..
                barracolor ..
                barra ..
                icono ..
                base_calculadora ..
                logo..
                "textarea[5,1;4,2;mostrar;;" .. tostring(resultado) .. "]"..
                "button[0.8,4;2,2;volver_in;Volver]"
            minetest.show_formspec(player:get_player_name(), "calculadora", formspec)
        end
    end
end)