local function get_optimal_size() return 10, 12 end
local modpath_es = minetest.get_modpath(minetest.get_current_modname())
local fondo = "#000000"
local x, y = get_optimal_size()
local x1 = x + 1
local barracolor = "style[barra_ic;bgcolor=black;textcolor=white]"
local logo = "background[0,0;10,10;logo.png;1]"
local boton_rojo = "style[barra_ic;bgcolor=red;textcolor=white]"
local barra = "button[-0.5,13;" .. x1 .. ",5;barra_ic;]"
local icono = "image_button[0,8.5;0.90,0.80;inicio.png;inicio;]"
local timer_active = true
local tamano = "size[" .. x .. "," .. y .. ",true]"
local luanti = "label[8.5,8.5;Luanti OS]"
local mensajes = {}
dofile(modpath_es.."/entrada/funciones/calculadora.lua")
dofile(modpath_es.."/entrada/funciones/3_en_raya.lua")
local game_state = {}
local en_raya_partidas = {} 

function actualizar_hora(player)
    local name = player:get_player_name()
    local formspec = inicio(player)
    minetest.show_formspec(player:get_player_name(), "inicio", inicio())
end

function iniciar_temporizador(player,formname, fields)
    timer_active = true
    core.after(1, function()
        if timer_active then
            actualizar_hora(player)
            iniciar_temporizador(player)
        end
    end)
end

function enviar_mensaje_form(player)
    local formspec = tamano ..
        "bgcolor[" .. fondo .. "]" ..
        barracolor .. barra .. icono .. logo .. luanti ..
        "field[1,2;8,3;mensaje;message;]" ..
        "field[1,6;3,1;destinatario;to;]" ..
        "button[5,6;2,1;enviar_mensaje;send]" ..
        "button[5,5;2,1;buzon;mailbox]" ..
        "button[1,8;2,1;volver;Volver]"
    return formspec
end

function leer_mensajes_form(player)
    local contenido = ""
    local nombre_jugador = player:get_player_name()
    if mensajes[nombre_jugador] then
        for _, mensaje in ipairs(mensajes[nombre_jugador]) do
            contenido = contenido .. "De: " .. mensaje.remitente .. "\n" .. mensaje.texto .. "\n" .. "----------------------\n"
        end
    end
    local formspec = tamano ..
        "bgcolor[" .. fondo .. "]" ..
        barracolor .. barra .. icono .. logo .. luanti ..
        "label[1,2;Mensajes:" .. contenido .. "]" ..
        "button[1,8;2,1;volver;Volver]"
    return formspec
end
function inicio(player)
    local current_date = os.date("%Y-%m-%d--%H:%M:%S")
    local hora = "label[1,8.5;Hora: " .. current_date .. "]"
    local formspec = tamano..
        "bgcolor[" .. fondo .. "]"..
        barracolor..
        barra..
        icono..
        logo..
        hora..
        "image_button[0,2;1,1;calculadora.png;calculadora;]"..
        "image_button[0,3;1,1;correo.png;correo;]"..
        "image_button[0,5;1,1;raya.png;en_Raya_dos_jugadores;]"..
        luanti
    return formspec
end

function inicio_operative(player_name)
    local current_date = os.date("%Y-%m-%d--%H:%M:%S")
    local hora = "label[1,8.5;Hora: " .. current_date .. "]"
    local formspec = tamano..
        "bgcolor[" .. fondo .. "]"..
        barracolor..
        barra..
        icono..
        logo..
        hora..
        "image_button[0,4;1,1;calculadora.png;calculadora;]"..
        "image_button[0,5;1,1;raya.png;en_Raya_dos_jugadores;]"..
        luanti
    return formspec
end





-------
function opciones()
    local formspec =tamano..
        logo..
        "bgcolor[" .. fondo .. "]"..
        "style[cerrar;bgcolor=red;textcolor=white]"..
        "style[volver;bgcolor=#F5F5DC;textcolor=white]"..
        "style[administrador;bgcolor=#F5F5DC;textcolor=white]"..
        barracolor..
        barra..
        icono..
        luanti..
        "button[0,4;2,2;volver;back]"..
        "button_exit[0,6;2,2;cerrar;Shutdown]"..
        "button_exit[0,5;2,2;administrador;Admin]"..
        "label[0,3.8.7;Options]"
    return formspec
end


minetest.register_on_player_receive_fields(function(player, formname, fields)
    local player_name = player:get_player_name()

    if formname == "enviar_mensaje_form" then
        if fields.enviar_mensaje then
            local destinatario = fields.destinatario
            local texto = fields.mensaje
        elseif fields.volver then
            minetest.show_formspec(player:get_player_name(), "inicio", inicio())
        end
    elseif formname == "leer_mensajes_form" then
        if fields.volver then
            minetest.show_formspec(player:get_player_name(), "inicio", inicio())
        end
    end

    if fields.volver then
        timer_active = true
        iniciar_temporizador(player)
        minetest.show_formspec(player:get_player_name(), "opciones", opciones())
    end
    if fields.volver_op then
        minetest.show_formspec(player:get_player_name(), "opciones", opciones())
    end
    if fields.administrador then
        if minetest.check_player_privs(player, {server = true}) then
        else
            minetest.chat_send_player(player:get_player_name(), "required privilege :server")
        end
    end
    if formname == "inicio" or formname == "inicio_op" then
        if fields.inicio then
            timer_active = false
            core.after(1, function()
                minetest.show_formspec(player:get_player_name(), "opciones", opciones())
            end)
        end

    end
    if formname == "enviar_mensaje_form" then
        if fields.buzon then
            timer_active = false
            core.after(1, function()
                minetest.show_formspec(player:get_player_name(), "leer_mensajes_form", leer_mensajes_form(player))
            end)
        end
    end
    if formname == "inicio" then
        if fields.correo then
            timer_active = false
            core.after(1, function()
                minetest.show_formspec(player:get_player_name(), "enviar_mensaje_form", enviar_mensaje_form(player))
            end)
            
        end

        if fields.calculadora then
            timer_active = false
            core.after(0.5, function()
                minetest.show_formspec(player:get_player_name(), "calculadora", calculadora())
            end)
        end
    elseif formname == "calculadora" then
        if fields.volver then
            minetest.show_formspec(player:get_player_name(), "inicio_operative", inicio_operative(player_name)) -- Pasamos el nombre del jugador
        elseif fields.cerrar then
        end

    end
    if fields.en_Raya_dos_jugadores then
            timer_active = false
            core.after(1, function()
            minetest.show_formspec(player_name, "en_raya_menu", en_raya_dos_jugadores_form(player_name))
            end)
        return
    end
    if formname == "administrador" then
        if fields.kick_btn then
            local nombre_jugador = fields.kick_nombre
            if nombre_jugador and nombre_jugador ~= "" then
                local jugador_a_kickear = minetest.get_player_by_name(nombre_jugador)
                if jugador_a_kickear then
                    minetest.kick_player(jugador_a_kickear:get_player_name(), "Has sido expulsado por un administrador.")
                    minetest.chat_send_player(player:get_player_name(), "Jugador '" .. nombre_jugador .. "' kickeado.")
                else
                    minetest.chat_send_player(player:get_player_name(), "Jugador '" .. nombre_jugador .. "' no encontrado.")
                end
            else
                minetest.chat_send_player(player:get_player_name(), "Debes ingresar un nombre de jugador para kickear.")
            end
        elseif fields.ban_btn then
            local nombre_jugador = fields.ban_nombre
            if nombre_jugador and nombre_jugador ~= "" then
                minetest.ban_player(nombre_jugador, "Baneado por un administrador.")
                minetest.chat_send_player(player:get_player_name(), "Jugador '" .. nombre_jugador .. "' baneado.")
            else
                minetest.chat_send_player(player:get_player_name(), "Debes ingresar un nombre de jugador para banear.")
            end
        elseif fields.unban_btn then
            local nombre_jugador = fields.unban_nombre
            if nombre_jugador and nombre_jugador ~= "" then
                core.unban_player_or_ip(nombre_jugador)
                minetest.chat_send_player(player:get_player_name(), "Jugador '" .. nombre_jugador .. "' desbaneado.")
            else
                minetest.chat_send_player(player:get_player_name(), "Debes ingresar un nombre de jugador para desbanear.")
            end

        elseif fields.status_server then
            local mensaje = "Estado del servidor:\nmax lag:" .. core.get_server_max_lag() .. "\nuptime: " .. core.get_server_uptime()
            minetest.chat_send_player(player:get_player_name(), mensaje)
        elseif fields.volver then
            minetest.show_formspec(player:get_player_name(), "opciones", opciones())
        end
    end
end)
