
en_raya_partidas = en_raya_partidas or {}


local function iniciar_en_Raya_partida(jugador1, jugador2)
    return {
        players = {jugador1, jugador2},
        current_player = jugador1,  
        board = {
            ["1"] = "", ["2"] = "", ["3"] = "",
            ["4"] = "", ["5"] = "", ["6"] = "",
            ["7"] = "", ["8"] = "", ["9"] = ""
        },
        winner = nil,
        created = os.time()
    }
end

local function ganador(board)
    local lines = {
        {"1", "2", "3"}, {"4", "5", "6"}, {"7", "8", "9"},
        {"1", "4", "7"}, {"2", "5", "8"}, {"3", "6", "9"},
        {"1", "5", "9"}, {"3", "5", "7"}
    }
    for _, line in ipairs(lines) do
        if board[line[1]] ~= "" and board[line[1]] == board[line[2]] and board[line[2]] == board[line[3]] then
            return board[line[1]]
        end
    end
    for _, v in pairs(board) do
        if v == "" then
            return nil
        end
    end
    return "tied"
end

local function mostrar_en_raya_dos_jugadores(jugador_nombre, partida_id)
    local partida = en_raya_partidas[partida_id]
    if not partida then return end
    local formspec = {
        "formspec_version[3]",
        "size[15,12]",
        "background[0,0;15,12;black.png;1]"..
        "style_type[button;font_size=36;align=center]",
        "label[6,0.5;Tic Tac Toe]",
    }

    for fila = 0, 2 do
        for columna = 0, 2 do
            local pos = fila * 3 + columna + 1
            local x = 5 + columna * 2
            local y = 2 + fila * 2
            local valor = partida.board[tostring(pos)] or ""
            if valor == "" then
                table.insert(formspec, "button[" .. x .. "," .. y .. ";1.8,1.8;ttt_" .. pos .. "; ]")
            else
                table.insert(formspec, "button[" .. x .. "," .. y .. ";1.8,1.8;none;" .. valor .. "]")
            end
        end
    end

    local player1_name = partida.players[1] or "Esperando..."
    local player2_name = partida.players[2] or "Esperando..."
    table.insert(formspec, "label[1,10;Player (X): " .. player1_name .. "]")
    table.insert(formspec, "label[1,9;Player (O): " .. player2_name .. "]")

    if partida.winner then
        local mensaje = partida.winner == "tied"
                         and "¡Empate!"
                         or ((partida.winner == "X")
                              and "¡Gana " .. player1_name .. "!"
                              or "¡Gana " .. player2_name .. "!")
        table.insert(formspec, "label[2.5,8;" .. mensaje .. "]")
        table.insert(formspec, "button[12,10.5;2,1;ttt_reset;new]")
    else
        local turno = (partida.current_player == player1_name)
                      and ("X (" .. player1_name .. ")")
                      or ("O (" .. player2_name .. ")")
        table.insert(formspec, "label[1,11;Turno de: " .. turno .. "]")
    end

    table.insert(formspec, "button_exit[12,9;2,1;volver;back]")

    minetest.show_formspec(jugador_nombre, "en_raya_" .. partida_id, table.concat(formspec, ""))
end
function en_raya_dos_jugadores_form(player_name)
    local tamano = "size[15,12]"
    local fondo = "#000000"
    local formspec = tamano ..
        "background[0,0;15,12;black.png;1]"..
        "label[1,2;Active games:]"

    local y_offset = 3
    local partidas_encontradas = false
    for id_partida, partida in pairs(en_raya_partidas) do
        if partida and partida.players[1] and partida.players[2] == nil then
            local creator_name = partida.players[1] or "Desconocido"
            formspec = formspec .. "button[1," .. y_offset .. ";6,1;" .. id_partida .. ";" .. creator_name .. " | ID: " .. id_partida .. "]"
            y_offset = y_offset + 1
            partidas_encontradas = true
        end
    end

    if not partidas_encontradas then
        formspec = formspec .. "label[1," .. y_offset .. ";There are no active games available.]"
        y_offset = y_offset + 1
    end

    formspec = formspec ..
        "button[1," .. (y_offset + 1) .. ";5,1;crear_partida;Create new game]" ..
        "button[1," .. (y_offset + 3) .. ";2,1;volver;back]"

    return formspec
end

local function procesar_movimiento(player_name, partida_id, pos)
    local partida = en_raya_partidas[partida_id]
    if not partida or partida.winner then return end
    if partida.current_player ~= player_name then
        return
    end
    local cell_key = tostring(pos)
    if partida.board[cell_key] ~= "" then
        minetest.chat_send_player(player_name, "That box is already occupied.")
        return
    end
    local marker = (player_name == partida.players[1]) and "X" or "O"
    partida.board[cell_key] = marker
    local result = ganador(partida.board)
    if result then
        partida.winner = result
    else
        if partida.current_player == partida.players[1] then
            partida.current_player = partida.players[2]
        else
            partida.current_player = partida.players[1]
        end
    end
    for _, pname in ipairs(partida.players) do
        if pname then
            mostrar_en_raya_dos_jugadores(pname, partida_id)
        end
    end
end

function inicio_operative(player_name)
    local current_date = os.date("%Y-%m-%d--%H:%M:%S")
    local hora = "label[1,8.5;Hora: " .. current_date .. "]"
    local formspec = tamano ..
        "bgcolor[" .. fondo .. "]" ..
        barracolor ..
        barra ..
        icono ..
        logo ..
        hora ..
        "image_button[0,4;1,1;calculadora.png;calculadora;]" ..
        "image_button[0,5;1,1;raya.png;en_Raya_dos_jugadores;]" ..
        luanti
    return formspec
end

minetest.register_on_player_receive_fields(function(player, formname, fields)
    local player_name = player:get_player_name()
    if formname:sub(1, 7) == "en_raya" then
        local partida_id = formname:sub(9)
        if fields.volver then
            minetest.show_formspec(player_name, "main_menu", inicio_operative(player_name))
            return
        end

        if fields.ttt_reset then
            local partida = en_raya_partidas[partida_id]
            if partida then
                partida.board = {
                    ["1"] = "", ["2"] = "", ["3"] = "",
                    ["4"] = "", ["5"] = "", ["6"] = "",
                    ["7"] = "", ["8"] = "", ["9"] = ""
                }
                partida.winner = nil
                partida.current_player = partida.players[1]
                for _, pname in ipairs(partida.players) do
                    if pname then
                        mostrar_en_raya_dos_jugadores(pname, partida_id)
                    end
                end
            end
            return
        end

        for key, _ in pairs(fields) do
            if key:sub(1, 4) == "ttt_" then
                local command = key:sub(5) 
                if command ~= "reset" then
                    local pos = command
                    procesar_movimiento(player_name, partida_id, pos)
                    return
                end
            end
        end
    end

    if formname == "main_menu" then
        if fields.en_Raya_dos_jugadores then
            minetest.show_formspec(player_name, "en_raya_menu", en_raya_dos_jugadores_form(player_name))
            return
        end
    end

    if formname == "en_raya_menu" then
        for id_partida, partida in pairs(en_raya_partidas) do
            if fields[tostring(id_partida)] then
                if partida.players[2] == nil and partida.players[1] ~= player_name then
                    partida.players[2] = player_name
                end
                mostrar_en_raya_dos_jugadores(player_name, id_partida)
                return
            end
        end

        if fields.crear_partida then
            local match_id = tostring(os.time() .. math.random(100, 999))
            en_raya_partidas[match_id] = iniciar_en_Raya_partida(player_name)
            mostrar_en_raya_dos_jugadores(player_name, match_id)
            return
        end

        if fields.volver then
            minetest.show_formspec(player_name, "main_menu", inicio_operative(player_name))
            return
        end
    end
end)
