
meteor = {}


local METEORITO_VELOCIDAD = 30
local RADIO_EXPLOSION = 15
local dano = 10
local TIEMPO_ENTRE_meteor = 300
local ALTURA_CAIDA = 50
local PROBABILIDAD_CAIDA = 1
local modelo_meteorito = "meteorito.obj"
local textura_meteorito = "default_stone.png"
local textura_fuego = "fire_basic_flame.png"

function meteor.crear_meteorito(pos_inicio)
    local meteorito = minetest.add_entity(pos_inicio, "meteor:meteorito")
    
    if meteorito then
        local dir = vector.new(1, -1, 0)
        local velocidad_vector = vector.multiply(dir, METEORITO_VELOCIDAD)
        meteorito:set_velocity(velocidad_vector)
        meteorito:set_acceleration(dir)
       
        meteorito:set_rotation({
            x = math.random() * math.pi * 2,
            y = math.random() * math.pi * 2,
            z = math.random() * math.pi * 2
        })
        
        meteorito:get_luaentity().ultima_pos = pos_inicio
        
        minetest.log("action", "[meteor] Meteorito creado en " .. minetest.pos_to_string(pos_inicio))
    end
    
    return meteorito
end


function meteor.crear_rastro_fuego(pos)

    minetest.add_particlespawner({
        amount = 20,
        time = 0.3,
        minpos = vector.subtract(pos, 0.5),
        maxpos = vector.add(pos, 0.5),
        minvel = {x = -0.5, y = -0.5, z = -0.5},
        maxvel = {x = 0.5, y = 0.5, z = 0.5},
        minacc = {x = 0, y = 0.5, z = 0},
        maxacc = {x = 0, y = 1, z = 0},
        minexptime = 0.5,
        maxexptime = 1.5,
        minsize = 5,
        maxsize = 8,
        collisiondetection = false,
        vertical = false,
        texture = textura_fuego,
        glow = 14
    })
    
    minetest.add_particlespawner({
        amount = 8,
        time = 0.5,
        minpos = vector.subtract(pos, 0.3),
        maxpos = vector.add(pos, 0.3),
        minvel = {x = -0.3, y = 0.5, z = -0.3},
        maxvel = {x = 0.3, y = 1.5, z = 0.3},
        minacc = {x = 0, y = 0.2, z = 0},
        maxacc = {x = 0, y = 0.5, z = 0},
        minexptime = 1,
        maxexptime = 3,
        minsize = 5,
        maxsize = 12,
        collisiondetection = false,
        vertical = false,
        texture = "smoke_puff.png",
        glow = 5
    })
end


function meteor.crear_fuego_en_suelo(pos)

    local pos_suelo = {x = pos.x, y = pos.y + 1, z = pos.z}

    local nodo = minetest.get_node(pos_suelo)
    if nodo.name == "air" or nodo.name == "default:dirt_with_grass" or 
       nodo.name == "default:dirt" or nodo.name == "default:sand" then
        
        minetest.set_node(pos_suelo, {name = "fire:basic_flame"})
        
        minetest.after(math.random(10, 30), function()
            local nodo_actual = minetest.get_node(pos_suelo)
            if nodo_actual.name == "fire:basic_flame" then
                minetest.remove_node(pos_suelo)
            end
        end)
    end
    

    local radio_fuego = 6
    for dx = -radio_fuego, radio_fuego do
        for dz = -radio_fuego, radio_fuego do
            local distancia = math.sqrt(dx*dx + dz*dz)
            if distancia <= radio_fuego then
                local pos_fuego = {
                    x = pos.x + dx,
                    y = pos.y + 1,
                    z = pos.z + dz
                }
                

                local prob_fuego = 0.7 * (1 - distancia/radio_fuego)
                if math.random() < prob_fuego then
                    local nodo_fuego = minetest.get_node(pos_fuego)
                    if nodo_fuego.name == "air" then
                        minetest.set_node(pos_fuego, {name = "fire:basic_flame"})
                        

                        minetest.after(math.random(5, 20), function()
                            local nodo_actual = minetest.get_node(pos_fuego)
                            if nodo_actual.name == "fire:basic_flame" then
                                minetest.remove_node(pos_fuego)
                            end
                        end)
                    end
                end
            end
        end
    end
end

function meteor.explotar(pos)

    minetest.sound_play("explosion", {
        pos = pos,
        gain = 1.5,
        max_hear_distance = 50
    })
    
    minetest.add_particlespawner({
        amount = 100,
        time = 0.5,
        minpos = vector.subtract(pos, 5),
        maxpos = vector.add(pos, 5),
        minvel = {x = -5, y = -5, z = -5},
        maxvel = {x = 5, y = 5, z = 5},
        minacc = {x = 0, y = -10, z = 0},
        maxacc = {x = 0, y = -10, z = 0},
        minexptime = 1,
        maxexptime = 2,
        minsize = 2,
        maxsize = 5,
        collisiondetection = true,
        texture = "default_stone.png"
    })
    

    meteor.crear_fuego_en_suelo(pos)
    
    local objetos = minetest.get_objects_inside_radius(pos, RADIO_EXPLOSION)
    for _, obj in ipairs(objetos) do
        if obj:is_player() then
            -- Daño al jugador
            local player_name = obj:get_player_name()
            if player_name then
                local hp = obj:get_hp()
                obj:set_hp(hp - dano)

            end
        end
    end
    
    for dx = -RADIO_EXPLOSION, RADIO_EXPLOSION do
        for dy = -RADIO_EXPLOSION, RADIO_EXPLOSION do
            for dz = -RADIO_EXPLOSION, RADIO_EXPLOSION do
                local distancia = math.sqrt(dx*dx + dy*dy + dz*dz)
                if distancia <= RADIO_EXPLOSION then
                    local pos_bloque = vector.add(pos, {x = dx, y = dy, z = dz})
                    
                    if distancia <= RADIO_EXPLOSION/2 or math.random() > (distancia / RADIO_EXPLOSION) then
                        local nodo = minetest.get_node(pos_bloque)
                        if nodo.name ~= "air" and nodo.name ~= "ignore" then
                            if math.random() > 0.7 then
                                minetest.add_item(pos_bloque, nodo.name)
                            end
                            minetest.remove_node(pos_bloque)
                        end
                    end
                end
            end
        end
    end
    
    -- Crear cráter
    for dy = -3, -1 do
        for dx = -4, 4 do
            for dz = -4, 4 do
                local distancia = math.sqrt(dx*dx + dz*dz)
                if distancia <= 4 - (dy + 3)/2 then
                    local pos_crater = vector.add(pos, {x = dx, y = dy, z = dz})
                    minetest.remove_node(pos_crater)
                end
            end
        end
    end
end


minetest.register_entity("meteor:meteorito", {
    initial_properties = {
        physical = true,
        collide_with_objects = true,
        collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
        visual = "mesh",
        mesh = modelo_meteorito,
        textures = {textura_meteorito},
        visual_size = {x = 20, y = 20, z = 20},
        pointable = false,
        static_save = false,
        glow = 10, 
    },
    
    ultima_pos = nil, 
    
    on_step = function(self, dtime)
        local pos = self.object:get_pos()
        
        if pos then
            if self.ultima_pos then
                local distancia = vector.distance(pos, self.ultima_pos)
                if distancia > 0.5 then

                    meteor.crear_rastro_fuego(pos)
                    
                    self.ultima_pos = pos
                end
            else
                self.ultima_pos = pos
            end
            
            local nodo_abajo = minetest.get_node({
                x = pos.x,
                y = pos.y - 1,
                z = pos.z
            })
            

            if nodo_abajo.name ~= "air" and nodo_abajo.name ~= "ignore" then
       
                meteor.explotar(pos)

                self.object:remove()
                return
            end
            
    
            local rot = self.object:get_rotation()
            self.object:set_rotation({
                x = rot.x + dtime * 3,
                y = rot.y + dtime * 3,
                z = rot.z + dtime * 3
            })
            
   
            minetest.add_particlespawner({
                amount = 5,
                time = 0.1,
                minpos = vector.subtract(pos, 0.3),
                maxpos = vector.add(pos, 0.3),
                minvel = {x = -0.2, y = -0.2, z = -0.2},
                maxvel = {x = 0.2, y = 0.2, z = 0.2},
                minacc = {x = 0, y = 0, z = 0},
                maxacc = {x = 0, y = 0, z = 0},
                minexptime = 0.3,
                maxexptime = 0.7,
                minsize = 2,
                maxsize = 5,
                collisiondetection = false,
                texture = "fire_basic_flame.png",
                glow = 12
            })
        end
    end,
    
    on_punch = function(self, puncher)
        local pos = self.object:get_pos()
        if pos then
            meteor.explotar(pos)
            self.object:remove()
        end
    end
})

function meteor.lanzar_meteorito_aleatorio()
    if math.random(1, 500) > PROBABILIDAD_CAIDA then
        return
    end
    
    local jugadores = minetest.get_connected_players()
    
    if #jugadores == 0 then
        return
    end
    
    local jugador = jugadores[math.random(#jugadores)]
    local pos_jugador = jugador:get_pos()

    local offset_x = math.random(-50, 50)
    local offset_z = math.random(-50, 50)
    
    local pos_inicio = {
        x = pos_jugador.x + offset_x,
        y = pos_jugador.y + ALTURA_CAIDA,
        z = pos_jugador.z + offset_z
    }

    pos_inicio.y = math.max(pos_inicio.y, ALTURA_CAIDA)

    meteor.crear_meteorito(pos_inicio)
    
    minetest.sound_play("explosion", {
        pos = pos_inicio,
        gain = 0.3,
        max_hear_distance = 100
    })
    

    for _, player in ipairs(jugadores) do
        local player_pos = player:get_pos()
        local distancia = vector.distance(player_pos, pos_inicio)
        if distancia < 100 then
            minetest.chat_send_player(player:get_player_name(), 
                "¡Un meteorito se acerca! Busca refugio.")
        end
    end
end

local timer = 0
minetest.register_globalstep(function(dtime)
    timer = timer + dtime
    if timer >= TIEMPO_ENTRE_meteor then
        timer = 0
        meteor.lanzar_meteorito_aleatorio()
    end
end)

