local the_man_of_the_fog_INTERVAL_MIN = 300  
local the_man_of_the_fog_INTERVAL_MAX = 500 
local the_man_of_the_fog_RANGE = 10         
local the_man_of_the_fog_DURATION = 0.2    
local APPEARANCE_CHANCE = 100   

local the_man_of_the_fog_skin = {
    "the_man_from_the_fog.png",
}

minetest.register_node("the_man_of_the_fog:the_man_of_the_fog_node", {
    description = "the_man_of_the_fog",
    tiles = the_man_of_the_fog_skin,
    visual_scale = 1.0,
    paramtype = "light",
    paramtype2 = "facedir",
    drawtype = "mesh",
    mesh = "the_man_from_the_fog.b3d",
    sunlight_propagates = true,
    walkable = false,
    pointable = false,
    buildable_to = true,
    drop = "",
    groups = {not_in_creative_inventory = 1},
    on_construct = function(pos)
        minetest.after(the_man_of_the_fog_DURATION, function()
            if minetest.get_node(pos).name == "the_man_of_the_fog:the_man_of_the_fog_node" then
                minetest.remove_node(pos)
            end
        end)
    end,
})

local player_timers = {}

local function is_night()
    local time_of_day = minetest.get_timeofday()

    return time_of_day > 0.75 or time_of_day < 0.25
end

local function spawn_the_man_of_the_fog(player)
    if not player or not player:is_player() then
        return
    end
    if not is_night() then
        return
    end
    
    local player_name = player:get_player_name()
    local player_pos = player:get_pos()
    
    if not player_pos then
        return
    end
    
    local offset_x = math.random(-the_man_of_the_fog_RANGE, the_man_of_the_fog_RANGE)
    local offset_z = math.random(-the_man_of_the_fog_RANGE, the_man_of_the_fog_RANGE)
    
    if math.abs(offset_x) < 15 then offset_x = 15 * (offset_x < 0 and -1 or 1) end
    if math.abs(offset_z) < 15 then offset_z = 15 * (offset_z < 0 and -1 or 1) end
    
    local spawn_pos = {
        x = player_pos.x + offset_x,
        y = player_pos.y,
        z = player_pos.z + offset_z
    }
    
    spawn_pos.y = spawn_pos.y - 1
    local ground_pos = {x = spawn_pos.x, y = spawn_pos.y, z = spawn_pos.z}

    local found_ground = false
    for i = 0, 1 do
        ground_pos.y = spawn_pos.y + i
        local node = minetest.get_node(ground_pos)
        local node_def = minetest.registered_nodes[node.name]
        
        if node_def and not node_def.walkable then
            local below_pos = {x = ground_pos.x, y = ground_pos.y - 1, z = ground_pos.z}
            local below_node = minetest.get_node(below_pos)
            local below_def = minetest.registered_nodes[below_node.name]
            
            if below_def and below_def.walkable then
                spawn_pos = {x = ground_pos.x, y = ground_pos.y, z = ground_pos.z}
                found_ground = true
                break
            end
        end
    end
    
    if not found_ground then
        spawn_pos.y = player_pos.y
    end
    
    local node_at_pos = minetest.get_node(spawn_pos)
    local node_def = minetest.registered_nodes[node_at_pos.name]
    
    if node_def and node_def.walkable then
        local air_pos = {x = spawn_pos.x, y = spawn_pos.y + 1, z = spawn_pos.z}
        local air_node = minetest.get_node(air_pos)
        local air_def = minetest.registered_nodes[air_node.name]
        
        if air_def and not air_def.walkable then
            spawn_pos = air_pos
        else
            return 
        end
    end
    
    minetest.set_node(spawn_pos, {name = "the_man_of_the_fog:the_man_of_the_fog_node"})
    
    local dir_vector = {
        x = player_pos.x - spawn_pos.x,
        y = 0,
        z = player_pos.z - spawn_pos.z
    }
    
    local yaw = math.atan2(dir_vector.z, dir_vector.x) - math.pi/2
    local facedir = minetest.dir_to_facedir({
        x = math.cos(yaw),
        y = 0,
        z = math.sin(yaw)
    })
    
    minetest.get_meta(spawn_pos):set_int("facedir", facedir)
end

local function schedule_next_the_man_of_the_fog(player)
    if not player or not player:is_player() then
        return
    end
    
    local player_name = player:get_player_name()
    
    if player_timers[player_name] then
        player_timers[player_name]:cancel()
    end
    
    local interval = math.random(the_man_of_the_fog_INTERVAL_MIN, the_man_of_the_fog_INTERVAL_MAX)

    player_timers[player_name] = minetest.after(interval, function()
        local current_player = minetest.get_player_by_name(player_name)
        if current_player then
            spawn_the_man_of_the_fog(current_player)
            schedule_next_the_man_of_the_fog(current_player)
        else
            player_timers[player_name] = nil
        end
    end)
end

minetest.register_on_joinplayer(function(player)
    if player and player:is_player() then
        minetest.after(10, function()
            schedule_next_the_man_of_the_fog(player)
        end)
    end
end)

minetest.register_on_leaveplayer(function(player)
    if player and player:is_player() then
        local player_name = player:get_player_name()
        if player_timers[player_name] then
            player_timers[player_name]:cancel()
            player_timers[player_name] = nil
        end
    end
end)
