
minetest.register_entity("torreta:bala", {
    initial_properties = {
        physical = true,
        visual = "sprite",
        textures = {"bala.png"},
        visual_size = {x = 0.1, y = 0.1, z = 0.1},
        glow = 10
    },
    on_step = function(self, dtime)
        self.timer = (self.timer or 0) + dtime
        local pos = self.object:get_pos()
        local players = minetest.get_connected_players()
        for _, player in ipairs(players) do
            local player_pos = player:get_pos()
            if vector.distance(pos, player_pos) < 1.8 then 
                self.object:remove()
                player:set_hp(player:get_hp() - 1)
                return
            else
            if self.timer > 1.5 then
            self.object:remove()
            return
        end

            end
        end
    end,
    on_activate = function(self, staticdata)
        self.timer = 0
    end,
})
local craft = minetest.register_craft
craft({
    output = "torreta:torreta1",
    recipe = {
        {"", "binoculars:binoculars", ""},
        {"xpanes:bar_flat", "default:bronzeblock", "xpanes:bar_flat"},
        {"default:steelblock", "default:steelblock", "default:steelblock"},
    },
})
local function auto_shoot(pos, turret)
    local players = minetest.get_objects_inside_radius(pos, 10) 
    for _, obj in ipairs(players) do
        if obj:is_player() then
            if obj:get_player_name() ~= turret.owner then
                local player_pos = obj:get_pos()
                local direction = {
                    x = player_pos.x - pos.x,
                    y = player_pos.y - pos.y,
                    z = player_pos.z - pos.z
                }
                local length = math.sqrt(direction.x^2 + direction.z^2)
                direction.x = direction.x / length
                direction.z = direction.z / length
                local speed = 14
                local bala = minetest.add_entity(pos, "torreta:bala")
                bala:set_velocity({x = direction.x * speed, y = direction.y + 0.1 * speed, z = direction.z * speed})
                minetest.sound_play("disparo", {pos = pos, gain = 1.0, max_hear_distance = 20})
                local angle = math.atan2(direction.z, direction.x) 
                local yaw = angle + 1.7
                turret.object:set_yaw(yaw) 
            end
        end
    end
end

minetest.register_node("torreta:torreta1", {
    description = "Turret",
    tiles = {"inv.png"},
    on_place = function(itemstack, placer, pointed_thing)
        local pos = pointed_thing.above
        local turret = minetest.add_entity(pos, "torreta:torreta")
        turret:get_luaentity().owner = placer:get_player_name()
            itemstack:take_item()  
        return itemstack 
    end,
})
minetest.register_entity("torreta:torreta", {
    hp_max = 500,
    glow = 1,
    initial_properties = {
        physical = true,
        collide_with_objects = true,
        visual = "mesh",
        mesh = "model.obj",
        visual_size = {x = 10, y = 10, z = 10},
        textures = {"texture.png"},
    },
    on_activate = function(self, staticdata)
        self.owner = staticdata or ""  
        self.shoot_timer = 0
        self.is_on = true
        self:update_nametag()  
    end,
    get_staticdata = function(self)
        return self.owner  
    end,
    on_step = function(self, dtime)
        self.shoot_timer = (self.shoot_timer or 0) + dtime
        if self.shoot_timer >= 1 and self.is_on then  
            auto_shoot(self.object:get_pos(), self)
            self.shoot_timer = 0 
        end
    end,
    on_rightclick = function(self, clicker)
        if clicker:get_player_name() == self.owner then 
            self.is_on = not self.is_on 
            self:update_nametag()  
        end
    end,
    update_nametag = function(self)
        local nametag_text = self.is_on and "ON" or "OFF"
        local color = self.is_on and {a = 255, r = 0, g = 255, b = 0} or {a = 255, r = 255, g = 0, b = 0}  -- Verde para ON, Rojo para OFF
        self.object:set_nametag_attributes({text = nametag_text, color = color})
    end,
})

---
