function particle(crystal_pos)    
    for i = 1, 10 do
        minetest.add_particle({
        pos = {x=crystal_pos.x, y=crystal_pos.y, z=crystal_pos.z},
        velocity = {x=math.random(-1, 1), y=math.random(1, 2), z=math.random(-1, 1)},
        expirationtime = 1,
        size = 2,
        texture = "particle.png",
        })
    end
end



minetest.register_craftitem("void_grenade:granada", {
    description = "attraction grenade",
    inventory_image = "void_grenade.png",
    on_use = function(itemstack, user, pointed_thing)
        local pos = user:get_pos()
        local dir = user:get_look_dir()
        local velocity = 20
        local obj = minetest.add_entity({x=pos.x, y=pos.y+1,7, z=pos.z}, "void_grenade:entity")
        obj:set_velocity({x=dir.x*velocity, y=dir.y*velocity, z=dir.z*velocity})
        obj:set_acceleration({x=dir.x*-3, y=-10, z=dir.z*-3})
        itemstack:take_item()
        return itemstack
    end,
})

minetest.register_entity("void_grenade:entity", {
    physical = true,
    collisionbox = {-0.2, -0.2, -0.2, 0.2, 0.2, 0.2},
    visual = "sprite",
    textures = {"void_grenade.png"},
    on_step = function(self, dtime)

        local pos = self.object:get_pos()
        local node_x_neg = minetest.get_node({x=pos.x-0.5, y=pos.y, z=pos.z}) 
        local node_y_neg = minetest.get_node({x=pos.x, y=pos.y-0.5, z=pos.z}) 
        local node_z_neg = minetest.get_node({x=pos.x, y=pos.y, z=pos.z-0.5}) 
        local node_x_pos = minetest.get_node({x=pos.x+0.5, y=pos.y, z=pos.z}) 
        local node_y_pos = minetest.get_node({x=pos.x, y=pos.y+0.5, z=pos.z}) 
        local node_z_pos = minetest.get_node({x=pos.x, y=pos.y, z=pos.z+0.5}) 

        if node_y_neg.name ~= "air" or node_x_neg.name ~= "air" or node_z_neg.name ~= "air" or node_z_pos.name ~= "air" or node_x_pos.name ~= "air"or node_y_pos.name ~= "air"then
            for _, player in ipairs(minetest.get_connected_players()) do
                local player_pos = player:get_pos()

                minetest.set_node(pos, {name="default:obsidian_glass"})
                minetest.after(4, function()
                    minetest.set_node(pos, {name="air"}) 
                end)
                if vector.distance(pos, player_pos) < 5 then
                    local crystal_pos = {x=pos.x, y=pos.y, z=pos.z}
                    player:set_physics_override({speed = 0.09, jump = 0})         
                    player:set_properties({visual_size = {x=0.5, y=0.5}})  
                    player:set_properties({eye_height = 1, })
                    minetest.set_node(pos, {name="default:obsidian_glass"})
                    particle(crystal_pos)
                    player:set_pos({x=crystal_pos.x, y=crystal_pos.y, z=crystal_pos.z})
                    minetest.after(4, function()
                        player:set_properties({visual_size = {x=1, y=1}})
                        player:set_physics_override({speed = 1, jump = 1}) 
                        player:set_properties({eye_height = 1.58,})
                    end)
                end
            end
            self.object:remove() 
        end
    end,
})

minetest.register_craft({
    output = "void_grenade:granada",
    recipe = {
        {"default:obsidian_shard", "default:obsidian_shard", "default:obsidian_shard"},
        {"default:obsidian_shard", "default:mese_crystal", "default:obsidian_shard"},
        {"default:obsidian_shard", "default:obsidian_shard", "default:obsidian_shard"},
    }
})