
local modname = minetest.get_current_modname()
local modpath = minetest.get_modpath(modname)

local chars = assert(loadfile(modpath .. "/chars.lua"))()

local name_format = minetest.settings:get("texttext_name_format") or "name_full"

minetest.register_on_mods_loaded(function()
	for name, def in pairs(minetest.registered_nodes) do
		local sname
		if name_format == "name_full" then -- techical name
			sname = name
		elseif name_format == "name_item" then -- technical name, minus modname
			sname = name:match("^.-:(.+)$") or name
		elseif name_format == "desc_full" then -- description
			sname = def.description or def.short_description or name
			sname = minetest.get_translated_string(sname, "en") or sname
		elseif name_format == "desc_short" then -- short description
			sname = ItemStack(name):get_short_description()
			sname = minetest.get_translated_string(sname, "en") or sname
		end
		sname = sname:lower()
		
		local h = chars.height + 2
		-- +2 for top/bottom padding
		local w = chars.width * #sname + 1
		-- +1 for left-padding (right-padding is built-in to font)

		local tex = {}
		for row = 1, chars.height do
			-- initial pixel for left padding
			tex[row+1] = { chars.back }
		end

		local blank_row = {}
		for i = 1, w do
			blank_row[i] = chars.back
		end
		tex[1] = blank_row
		tex[#tex+1] = blank_row
		
		for i = 1, #sname do
			local c = sname:sub(i,i)
			local char = chars[c] or chars.notdef
			--if char == chars.unknown then minetest.log("Unknown char: '"..c.."'") end
			for row = 1, chars.height do
				local o = 1 + 4*chars.width*(row-1)
				tex[row+1][#tex[row+1]+1] = char:sub(o, o - 1 + 4*chars.width)
			end
		end

		if h < w then
			local new_tex = {}
			for i = 1, math.floor((w-h)/2) do
				new_tex[#new_tex+1] = blank_row
			end
			for i = 1, h do
				new_tex[#new_tex+1] = tex[i]
			end
			for i = 1, math.ceil((w-h)/2) do
				new_tex[#new_tex+1] = blank_row
			end
			h = w
			tex = new_tex
		end
		
		local t = ""
		
		for row = 1, h do
			--w = math.max(w, #tex[row])
			--tex[row] = table.concat(tex[row], "")
			for j = 1, #tex[row] do
				t = t .. tex[row][j]
			end
		end
		--tex = table.concat(tex, "")
		
		if w*h ~= 0 then
			minetest.override_item(name, {
				tiles = {
					"[png:" .. minetest.encode_base64(minetest.encode_png(w, h, t)),
				},
			})
		else
			minetest.log("Width 0: "..name)
		end
	end
end)
