
local modname = minetest.get_current_modname()
local modpath = minetest.get_modpath(modname)

local chars = assert(loadfile(modpath .. "/chars.lua"))()

local name_format = minetest.settings:get("texttext_name_format") or "name_item"
local name_functions = {
	name_full = function(name, def) -- technical name
		return name
	end,
	name_item = function(name, def) -- technical name, minus modname
		return name:match("^.-:(.+)$") or name
	end,
	desc_full = function(name, def) -- description
		local s = def.description or def.short_description or name
		return minetest.get_translated_string(s, "en") or s
		end,
	desc_short = function(name, def) -- short description
		s = ItemStack(name):get_short_description()
		return minetest.get_translated_string(s, "en") or s
	end,
}
local name_fn = name_functions[name_format]

return function(name, def)
	local sname = name_fn(name, def):lower()
	
	local h = chars.height
	local w = chars.width * #sname + 1
	-- +1 for left-padding (right-padding is built-in to font)
	
	local tex = {}
	for row = 1, h do
		-- initial pixel for left padding
		tex[row] = { chars.back }
	end
	
	for i = 1, #sname do
		local c = sname:sub(i,i)
		local char = chars[c] or chars.notdef
		for row = 1, h do
			tex[row][#tex[row]+1] = char[row]
		end
	end
	
	if h < w then
		local blank_row = { string.rep(chars.back, w) }
		
		local new_tex = {}
		for i = 1, math.floor((w-h)/2) do
			new_tex[#new_tex+1] = blank_row
		end
		for i = 1, h do
			new_tex[#new_tex+1] = tex[i]
		end
		for i = 1, math.ceil((w-h)/2) do
			new_tex[#new_tex+1] = blank_row
		end
		h = w
		tex = new_tex
	end
	
	for row = 1, h do
		tex[row] = table.concat(tex[row])
	end
	return minetest.encode_png(w, h, table.concat(tex))
end
