local opened = {}
local itemstacks = {{}, {}}
local viewing = {}

core.create_detached_inventory("openinv1")
core.create_detached_inventory("openinv2")

local function open_inventory(name)
    local player = core.get_player_by_name(name)
    if not player then
        return false
    end

    local index
    if not opened[1] then
        index = 1
    elseif not opened[2] then
        index = 2
    else
        return false
    end

    local detached = core.get_inventory({
        type="detached",
        name="openinv" .. tostring(index)
    })

    local inv = player:get_inventory()
    if not inv then
        return false
    end
    for key, list in pairs(inv:get_lists()) do
        detached:set_list(key, list)
        detached:set_size(key, inv:get_size(key))
        if key == "main" then
            itemstacks[index] = table.copy(list)
        end
    end

    local meta = player:get_meta()
    meta:set_string("openinv", "1")

    opened[index] = name
    return true
end

local function close_inventory(index)
    local name = opened[index]
    if not name then
        return false
    end
    local player = core.get_player_by_name(name)
    if not player then
        return false
    end
    local meta = player:get_meta()
    meta:set_string("openinv", "")
    local detached = core.get_inventory({
        type="detached",
        name="openinv" .. tostring(index)
    })
    local inv = player:get_inventory()
    if not detached or not inv then
        return false
    end
    local main = inv:get_list("main")
    if not main then
        return false
    end

    local extra = {}
    for i, stack in ipairs(main) do
        oldstack = itemstacks[index][i]
        if stack:to_string() ~= oldstack:to_string() then
            if stack:get_name() == oldstack:get_name() then
                stack:set_count(stack:get_count() - oldstack:get_count())
                table.insert(extra, stack)
            else
                table.insert(extra, stack)
            end
        end
    end
    inv:set_lists(detached:get_lists())
    opened[index] = nil
    local pos = player:get_pos()
    for i, stack in ipairs(extra) do
        if inv:room_for_item("main", stack) then
            inv:add_item("main", stack)
        else
            core.item_drop(stack, player, pos)
        end
    end

    core.remove_detached_inventory("openinv" .. tostring(index))
    core.create_detached_inventory("openinv" .. tostring(index))
    return true
end

local function show_formspec(name)
    local player = core.get_player_by_name(name)
    if not player then
        return false
    end

    local form = ""

    if core.get_modpath('mcl_formspec') then
        form = table.concat({
            "formspec_version[4]",
            "size[18, 15]",
            "image[1.2,0.8;2,2;openerest_inventory.png]",

            mcl_formspec.get_itemslot_bg_v4(1.5, 4.5, 8, 4),
            "list[detached:openinv1;main;1.5,4.5;8,4;]",
            "label[1.5,4.1;" .. (opened[1] or "---") .. "]",

            mcl_formspec.get_itemslot_bg_v4(1.5, 10, 8, 4),
            "list[detached:openinv2;main;1.5,10;8,4;]",
            "label[1.5,9.6;" .. (opened[2] or "---") .. "]",

            mcl_formspec.get_itemslot_bg_v4(12.5, 4.75, 4, 8),
            "list[current_player;main;12.5,4.75;4,8;]",
            mcl_formspec.get_itemslot_bg_v4(4.75, 0.75, 2, 2),
            "list[current_player;craft;4.75,0.75;2,2;]",
            mcl_formspec.get_itemslot_bg_v4(8.75, 1.25, 1, 1),
            "list[current_player;craftpreview;8.75,1.25;1,1;]"
        })
    else
        form = [[
            size[16,12]
            image[0.6,0.6;2,2;openerest_inventory.png]

            list[detached:openinv1;main;1,3.5;8,4;]
            label[1,3;]] .. (opened[1] or "---") .. [[]

            list[detached:openinv2;main;1,8;8,4;]
            label[1,7.5;]] .. (opened[2] or "---") .. [[]

            list[current_player;main;11,4;4,8;]
            list[current_player;craft;3,0;3,3;]
            list[current_player;craftpreview;7,1;1,1;]
        ]]
    end
    core.show_formspec(
        name,
        "detached:openinv",
        form
    )
    table.insert(viewing, name)
    return true
end

core.register_chatcommand('open', {
    params = "[<player>]",

    description = "If player is specified, attempt to open an inventory.\n" ..
                    "       Otherwise, open the inventories formspec.",

    privs = {server=true},

    func = function(name, param)
        if param ~= "" then
            if not open_inventory(param) then
                core.chat_send_player(
                    name,
                    "OpenInventory: Couldn't open inventory. " .. 
                        "Invalid player name, or all slots are full."
                )
            end
        else
            show_formspec(name)
        end
    end
})

core.register_chatcommand('close', {
    params = "[<index>]",

    description = "If index is specified, flush inventory at index.\n" .. 
                    "        Otherwise, flush all inventories.",

    privs = {server=true},

    func = function(name, param)
        if param ~= "" then
            index = tonumber(param)
            if index then
                if not close_inventory(index) then
                    core.chat_send_player(
                        name,
                        "OpenInventory: Couldn't close at index."
                    )
                end
            else
                return false
            end
            return true
        end

        close_inventory(1)
        close_inventory(2)
        return true

    end
})

core.register_chatcommand('openinv', {
    params = "",

    description = "Shows which inventories are currently open.",

    privs = {server=true},

    func = function(name)
        core.chat_send_player(name, "Slot 1 :  " .. (opened[1] or "---"))
        core.chat_send_player(name, "Slot 2 :  " .. (opened[2] or "---"))
    end
})

core.register_chatcommand('viewers', {
    params = "",

    description = "Shows which players are currently viewing inventories.",

    privs = {server=true},

    func = function(name)
        if #viewing == 0 then
            core.chat_send_player(
                name,
                "OpenInventory: No current viewers."
            )
            return
        end
        core.chat_send_player(name, "OpenInventory:")
        for i, player in ipairs(viewing) do
            core.chat_send_player(
                name,
                "  " .. tostring(i) .. " :  " .. player
            )
        end
    end
})

core.register_allow_player_inventory_action(
    function(player, action, inventory, info)
        if action == "move" then
            if info.to_list ~= "main" and info.from_list ~= "main" then
                return
            end
        else
            if info.listname ~= "main" then
                return
            end
        end
        local meta = player:get_meta()
        if meta then
            if meta:get_string('openinv') ~= "" then
                local location = inventory:get_location()
                if location.type:find('player') then
                    return 0
                end
            end
        end
    end
)

core.register_on_player_receive_fields(
    function(player, formname, fields)
        if fields.quit == "true" then
            local index = table.indexof(viewing, player:get_player_name())
            if index == -1 then
                return
            end
            table.remove(viewing, index)
            if #viewing == 0 then
                close_inventory(1)
                close_inventory(2)
            end
        end
    end
)

core.register_on_joinplayer(
    function(player)
        player:get_meta():set_string("openinv", "")
    end
)