local function truncate(num)
    return math.floor(num * 10000) / 10000
end

local function get_time()
    local now = os.date("*t")
    local time = now.hour * 3600 + now.min * 60 + now.sec
    return time / (24 * 3600)
end

local function sync_time()
    minetest.set_timeofday(get_time())
end

local function sync_time_loop()
    local game_time = truncate(minetest.get_timeofday())
    local world_time = truncate(get_time())
    if game_time ~= world_time then
        sync_time()
    end
    minetest.after(60, sync_time_loop)
end

minetest.after(0, function()
    minetest.settings:set("time_speed", 1)
    sync_time()
    sync_time_loop()
end)

minetest.register_chatcommand("sync_time", {
    privs = { server = true },
    func = function(name, _)
        sync_time()
        minetest.chat_send_player(name, "Time synced with real-world time")
    end
})
