local storage = core.get_mod_storage()

core.register_chatcommand("chatsound", {
	params = "[active]",
	description = "Check, enable or disable the chat sound effect",
	func = function (name, param)
		core.chat_send_player(name, param)
		if param == "yes" or param == "on" or param == "true" or param == "1" then
			storage:set_string(name, "1")
			core.chat_send_player(name, "Chat sound has been enabled")
		elseif param == "no" or param == "off" or param == "false" or param == "0" then
			storage:set_string(name, "0")
			core.chat_send_player(name, "Chat sound has been disabled")
		else
			core.chat_send_player(name, "Chat sound is currently " .. (storage:get(name) ~= "0" and "enabled" or "disabled"))
		end
	end,
})

chatsound = function ()
	for _, player in ipairs(core.get_connected_players()) do
		local name = player:get_player_name()
		if storage:get(name) ~= "0" then
			core.sound_play("chatsound", {gain = 1, to_player = name})
		end
	end
end

core.register_on_chat_message(function (name, message)
	chatsound()
	return false
end)
