local function auto_pickup(player)
    local pos = player:get_pos()

    for _, obj in ipairs(minetest.get_objects_inside_radius(pos, 3)) do
        if obj:is_player() == false and obj:get_luaentity() and obj:get_luaentity().name == "__builtin:item" then
            local stack = obj:get_luaentity().itemstring

            local inv = player:get_inventory()
            if inv:room_for_item("main", stack) then
                inv:add_item("main", stack)
                obj:remove()
            end
        end
    end
end

minetest.register_globalstep(function(dtime)
    for _, player in ipairs(minetest.get_connected_players()) do
        auto_pickup(player)
    end
end)
