rawset(_G, "farming", {})

minetest.register_node("farming:soil", {
	description = "Soil",
	tiles = { "soil.png", "mud.png" },
	groups = { dirt = 2 },
	drop = "default:dirt",
	sounds = default.node_sound.dirt,
})

local function on_place(itemstack, placer, pointed_thing)
	if pointed_thing.type == "node" then
		local pos = pointed_thing.under
		local node = minetest.get_node(pos)

		if node.name == "farming:soil" then
			return minetest.item_place(itemstack, placer, pointed_thing)
		end
	end
end

minetest.register_node("farming:wheat_seeds", {
	description = "Wheat Seeds",
	drawtype = "plantlike",
	walkable = false,
	tiles = { "wheat_seeds_node.png" },
	wield_image = "wheat_seeds.png",
	inventory_image = "wheat_seeds.png",
	groups = { dig_hand = 2 },
	sounds = default.node_sound.dirt,
	on_place = on_place,
})

minetest.register_node("farming:wheat", {
	description = "Wheat",
	drawtype = "plantlike",
	walkable = false,
	tiles = { "wheat_node.png" },
	wield_image = "wheat.png",
	inventory_image = "wheat.png",
	groups = { dig_hand = 2 },
	sounds = default.node_sound.dirt,
	on_place = function() end,
	drop = "farming:wheat 2",
})

minetest.register_craft({
	output = "farming:wheat_seeds 2",
	recipe = { { "farming:wheat" } },
})

minetest.register_node("farming:carrot", {
	description = "Carrot",
	drawtype = "plantlike",
	walkable = false,
	tiles = { "carrot_node.png" },
	wield_image = "carrot.png",
	inventory_image = "carrot.png",
	groups = { dig_hand = 2 },
	sounds = default.node_sound.dirt,
	on_use = minetest.item_eat(3),
	on_place = on_place,
})

minetest.register_node("farming:carrot_grown", {
	description = "Grown Carrot",
	drawtype = "plantlike",
	walkable = false,
	tiles = { "carrot_grown_node.png" },
	wield_image = "carrot.png",
	inventory_image = "carrot.png",
	groups = { dig_hand = 2 },
	sounds = default.node_sound.dirt,
	drop = "farming:carrot 3",
	on_place = function() end,
})

minetest.register_node("farming:bush", {
	description = "Bush",
	drawtype = "plantlike",
	walkable = false,
	tiles = { "bush.png" },
	groups = { dig_hand = 2 },
	sounds = default.node_sound.dirt,
	drop = {
		items = {
			{ items = { "farming:wheat_seeds" }, rarity = 3 },
			{ items = { "farming:wheat_seeds" }, rarity = 3 },
			{ items = { "farming:wheat_seeds" }, rarity = 3 },
			{ items = { "farming:wheat_seeds" }, rarity = 3 },
			{ items = { "farming:wheat_seeds" }, rarity = 3 },
			{ items = { "farming:carrot" }, rarity = 3 },
			{ items = { "farming:carrot" }, rarity = 3 },
			{ items = { "farming:carrot" }, rarity = 3 },
			{ items = { "farming:carrot" }, rarity = 3 },
			{ items = { "farming:carrot" }, rarity = 3 },
		},
	},
})

farming.seed_plant = {}
farming.seed_plant["farming:carrot"] = "farming:carrot_grown"
farming.seed_plant["farming:wheat_seeds"] = "farming:wheat"

minetest.register_node("farming:sugar_cane", {
	description = "Sugar Cane",
	drawtype = "plantlike",
	-- Note: Minetest 0.3 actually rotates the faces of plantlike differently
	-- by a single degree than the current engine. Nobody will ever notice this.
	tiles = { "sugar_cane.png" },
	inventory_image = "sugar_cane.png",
	wield_image = "sugar_cane.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	groups = { dig_hand = 2 },
	sounds = default.node_sound.leaves,
	after_dig_node = function(pos, node, metadata, digger)
		default.dig_up(pos, node, digger)
	end,
})

minetest.register_node("farming:cactus", {
	description = "Cactus",
	tiles = { "cactus_top.png", "cactus_top.png", "cactus_side.png" },
	groups = { wood = 5 },
	sounds = default.node_sound.wood,
	after_dig_node = function(pos, node, metadata, digger)
		default.dig_up(pos, node, digger)
	end,
})

function farming.is_crop(id)
	if
		id == "farming:wheat"
		or id == "farming:wheat_seeds"
		or id == "farming:carrot"
		or id == "farming:carrot_grown"
	then
		return true
	else
		return false
	end
end

local modpath = minetest.get_modpath(minetest.get_current_modname())
dofile(modpath .. "/abm.lua")
