materials = {}

local function register_lump(name)
	local lowered = string.lower(name)
	minetest.register_craftitem("minerals:lump_" .. lowered, {
		description = name .. " Lump",
		inventory_image = "lump_" .. lowered .. ".png",
		groups = {},
	})
end

local function register_final(name)
	local lowered = string.lower(name)
	minetest.register_craftitem("minerals:" .. lowered, {
		description = name,
		inventory_image = lowered .. ".png",
		groups = {},
	})
end

local function register_ingot(name, cooktime)
	local lowered = string.lower(name)
	minetest.register_craftitem("minerals:ingot_" .. lowered, {
		description = name .. " Ingot",
		inventory_image = "ingot_" .. lowered .. ".png",
		groups = {},
	})
	minetest.register_craft({
		type = "cooking",
		output = "minerals:ingot_" .. lowered,
		recipe = "minerals:lump_" .. lowered,
		cooktime = cooktime,
	})
end

local function register_ore(name, hardness, lump)
	local lowered = string.lower(name)
	local drop = "minerals:ore_" .. lowered
	if lump then
		drop = "minerals:lump_" .. lowered
	end
	minetest.log("warning", "registering minerals:ore_" .. lowered)
	minetest.register_node("minerals:ore_" .. lowered, {
		description = name .. " Ore",
		tiles = { "stone.png^ore_" .. lowered .. ".png" },
		groups = { stone = hardness },
		drop = drop,
		sounds = default.node_sound.stone,
	})
end

local function register_block(name, hardness, ingot)
	local lowered = string.lower(name)
	minetest.register_node("minerals:block_" .. lowered, {
		description = name .. " Block",
		tiles = { "block_" .. lowered .. ".png" },
		groups = { stone = hardness },
		sounds = default.node_sound.stone,
	})
	local beggining = "minerals:lump_"
	if ingot then
		beggining = "minerals:ingot_"
	end
	minetest.register_craft({
		output = "minerals:block_" .. lowered,
		recipe = {
			{ beggining .. lowered, beggining .. lowered, beggining .. lowered },
			{ beggining .. lowered, beggining .. lowered, beggining .. lowered },
			{ beggining .. lowered, beggining .. lowered, beggining .. lowered },
		},
	})
	minetest.register_craft({
		output = beggining .. lowered .. " 9",
		recipe = { { "minerals:block_" .. lowered } },
	})
end

local function register_mineral(name, hardness, ingot, cooktime, final, lump, ore, block)
	if final then
		register_final(name)
	end
	if lump or ingot then
		register_lump(name)
	end
	if ingot then
		register_ingot(name, cooktime)
	end
	if ore or block then
		register_ore(name, hardness, lump)
	end
	if block then
		register_block(name, hardness, ingot)
	end
end

local function register_mineral_mapgen(name, best_min, best_max, scarcity, ores, size)
	local lowered = string.lower(name)
	local worse_scarcity = scarcity + 4
	local worse_size = size + 2
	local worse_ores = ores - 2
	-- above best
	minetest.register_ore({
		ore_type = "scatter",
		ore = "minerals:ore_" .. lowered,
		wherein = "default:stone",
		clust_scarcity = worse_scarcity * worse_scarcity * worse_scarcity,
		clust_num_ores = worse_ores,
		clust_size = worse_size,
		y_max = 31000,
		y_min = best_max,
	})

	-- best
	minetest.register_ore({
		ore_type = "scatter",
		ore = "minerals:ore_" .. lowered,
		wherein = "default:stone",
		clust_scarcity = scarcity,
		scarcity,
		scarcity,
		clust_num_ores = ores,
		clust_size = size,
		y_max = best_max,
		y_min = best_min,
	})

	-- below best
	minetest.register_ore({
		ore_type = "scatter",
		ore = "minerals:ore_" .. lowered,
		wherein = "default:stone",
		clust_scarcity = worse_scarcity * worse_scarcity * worse_scarcity,
		clust_num_ores = worse_ores,
		clust_size = worse_size,
		y_max = best_min,
		y_min = -31000,
	})
end

register_mineral("Coal", 5, false, 0, false, true, true, true)
register_mineral_mapgen("Coal", -128, -2, 20, 3, 1)

minetest.register_craft({
	type = "fuel",
	recipe = "minerals:lump_coal",
	burntime = 60,
})

minetest.register_craft({
	type = "fuel",
	recipe = "minerals:block_coal",
	burntime = 540,
})

minetest.register_craft({
	type = "cooking",
	output = "minerals:lump_coal",
	recipe = "default:tree",
	cooktime = 10
})

register_mineral("Iron", 5, true, 5, false, true, true, true)
register_mineral_mapgen("Iron", -256, -16, 20, 3, 1)

-- Steel

minetest.register_craftitem("minerals:scrap_steel", {
	description = "Steel Scrap",
	inventory_image = "scrap_steel.png",
	groups = {},
})

minetest.register_craftitem("minerals:ingot_steel", {
	description = "Steel Ingot",
	inventory_image = "ingot_steel.png",
	groups = {},
})

minetest.register_craft({
	output = "minerals:ingot_steel",
	recipe = {
		{ "minerals:scrap_steel" },
		{ "minerals:scrap_steel" },
		{ "minerals:scrap_steel" },
	},
})

minetest.register_craft({
	type = "cooking",
	output = "minerals:scrap_steel",
	recipe = "minerals:ingot_iron",
	cooktime = 10,
})

register_block("Steel", 5, true)
