dofile(minetest.get_modpath("player_api") .. "/api.lua")

core.override_item("", {
	wield_scale = { x = 1.5, y = 2.5, z = 3.75 },
	tool_capabilities = {
		full_punch_interval = 0.9,
		max_drop_level = 0,
		groupcaps = {
			crumbly = { times = { [2] = 3.00, [3] = 0.70 }, uses = 0, maxlevel = 1 },
			snappy = { times = { [3] = 0.40 }, uses = 0, maxlevel = 1 },
			oddly_breakable_by_hand = { times = { [1] = 3.50, [2] = 2.00, [3] = 0.70 }, uses = 0 },
		},
		damage_groups = { fleshy = 1 },
	},
})

-- Default player appearance
player_api.register_model("character.b3d", {
	animation_speed = 30,
	textures = { "character.png" },
	animations = {
		-- Standard animations.
		stand = { x = 0, y = 79 },
		lay = {
			x = 162,
			y = 166,
			eye_height = 0.3,
			override_local = true,
			collisionbox = { -0.6, 0.0, -0.6, 0.6, 0.3, 0.6 },
		},
		walk = { x = 168, y = 187 },
		mine = { x = 189, y = 198 },
		walk_mine = { x = 200, y = 219 },
		sit = {
			x = 81,
			y = 160,
			eye_height = 0.8,
			override_local = true,
			collisionbox = { -0.3, 0.0, -0.3, 0.3, 1.0, 0.3 },
		},
	},
	collisionbox = { -0.3, 0.0, -0.3, 0.3, 1.7, 0.3 },
	stepheight = 0.6,
	eye_height = 1.47,
})

-- Update appearance when the player joins
minetest.register_on_joinplayer(function(player)
	player_api.set_model(player, "character.b3d")
end)
