function register_slab(baseid, id, name, image, groups, sounds)
	if baseid then
		minetest.register_craft({
			output = id .. " 6",
			recipe = {
				{ baseid, baseid, baseid },
			},
		})
	end
	minetest.register_node(id, {
		description = name,
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -0.5, 0.5, 0, 0.5 },
		},
		selection_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -0.5, 0.5, 0, 0.5 },
		},
		tiles = { image },
		groups = groups,
		sounds = sounds,
	})
end

register_slab(
	"default:cobble",
	"slabs:cobble",
	"Cobblestone slab",
	"cobble.png",
	{ stone = 4 },
	default.node_sound.stone
)

register_slab("default:wood", "slabs:wood", "Wooden slab", "wood.png", { wood = 5 }, default.node_sound.wood)

register_slab("default:sand", "slabs:sand", "Sand slab", "sand.png", { dirt = 2 }, default.node_sound.sand)

register_slab("default:gravel", "slabs:gravel", "Gravel Slab", "gravel.png", { dirt = 3 }, default.node_sound.gravel)
