local prop_sneaking = {
	collisionbox = { -0.312, 0, -0.312, 0.312, 1.8, 0.312 },
	eye_height = 1.45,
	nametag_color = { r = 225, b = 225, a = 0, g = 225 },
}

local prop_walking = {
	collisionbox = { -0.312, 0, -0.312, 0.312, 1.8, 0.312 },
	eye_height = 1.6,
	nametag_color = { r = 225, b = 225, a = 225, g = 225 },
}

local players = {}

core.register_on_joinplayer(function(player)
	local player_name = player:get_player_name()

	players[player_name] = player
end)

core.register_on_leaveplayer(function(player)
	local player_name = player:get_player_name()
	players[player_name] = nil
end)

core.register_globalstep(function(dtime)
	for _, player_object in pairs(players) do
		local control = player_object:get_player_control()
		if control.sneak then
			player_object:set_properties(prop_sneaking)
		else
			player_object:set_properties(prop_walking)
		end
	end
end)
