--
-- Aliases for map generators
--

-- All mapgens

minetest.register_alias("mapgen_stone", "default:stone")
minetest.register_alias("mapgen_water_source", "default:water_source")
minetest.register_alias("mapgen_river_water_source", "default:river_water_source")

-- smaller biomes

minetest.set_noiseparams("heat", {
	offset = 5,
	scale = 5,
	spread = { x = 10, y = 10, z = 10 },
	octaves = 3,
	persistence = 0.5,
})

minetest.set_noiseparams("humidity", {
	offset = 5,
	scale = 5,
	spread = { x = 10, y = 10, z = 10 },
	octaves = 3,
	persistence = 0.5,
})

function default.register_ores()
	-- Blob ore.
	-- These before scatter ores to avoid other ores in blobs.

	-- Clay

	minetest.register_ore({
		ore_type = "blob",
		ore = "default:clay",
		wherein = { "default:sand" },
		clust_scarcity = 16 * 16 * 16,
		clust_size = 5,
		y_max = 0,
		y_min = -15,
		noise_threshold = 0.0,
		noise_params = {
			offset = 0.5,
			scale = 0.2,
			spread = { x = 5, y = 5, z = 5 },
			seed = -316,
			octaves = 1,
			persist = 0.0,
		},
	})

	-- Dirt

	minetest.register_ore({
		ore_type = "blob",
		ore = "default:dirt",
		wherein = { "default:stone" },
		clust_scarcity = 16 * 16 * 16,
		clust_size = 5,
		y_max = 31000,
		y_min = -31,
		noise_threshold = 0.0,
		noise_params = {
			offset = 0.5,
			scale = 0.2,
			spread = { x = 5, y = 5, z = 5 },
			seed = 17676,
			octaves = 1,
			persist = 0.0,
		},
		-- Only where default:dirt is present as surface material
		biomes = {
			"forest",
			"plains",
		},
	})

	-- Gravel

	minetest.register_ore({
		ore_type = "blob",
		ore = "default:gravel",
		wherein = { "default:stone" },
		clust_scarcity = 16 * 16 * 16,
		clust_size = 5,
		y_max = 31000,
		y_min = -31000,
		noise_threshold = 0.0,
		noise_params = {
			offset = 0.5,
			scale = 0.2,
			spread = { x = 5, y = 5, z = 5 },
			seed = 766,
			octaves = 1,
			persist = 0.0,
		},
	})
end

--
-- Register biomes
--

function default.register_biomes()
	-- Forest
	minetest.register_biome({
		name = "forest",
		node_top = "default:dirt_with_grass",
		depth_top = 1,
		node_filler = "default:dirt",
		depth_filler = 1,
		node_riverbed = "default:sand",
		depth_riverbed = 2,
		y_max = 31000,
		y_min = 6,
		heat_point = 50,
		humidity_point = 50,
	})
	-- Plains

	minetest.register_biome({
		name = "plains",
		node_top = "default:dirt_with_grass",
		depth_top = 1,
		node_filler = "default:dirt",
		depth_filler = 1,
		node_riverbed = "default:sand",
		depth_riverbed = 2,
		y_max = 31000,
		y_min = 6,
		heat_point = 50,
		humidity_point = 35,
	})

	minetest.register_biome({
		name = "plains_dunes",
		node_top = "default:sand",
		depth_top = 1,
		node_filler = "default:sand",
		depth_filler = 2,
		node_riverbed = "default:sand",
		depth_riverbed = 2,
		vertical_blend = 1,
		y_max = 5,
		y_min = 4,
		heat_point = 50,
		humidity_point = 35,
	})

	minetest.register_biome({
		name = "plains_ocean",
		node_top = "default:sand",
		depth_top = 1,
		node_filler = "default:sand",
		depth_filler = 3,
		node_riverbed = "default:sand",
		depth_riverbed = 2,
		node_cave_liquid = "default:water_source",
		y_max = 3,
		y_min = -255,
		heat_point = 50,
		humidity_point = 35,
	})

	minetest.register_biome({
		name = "plains_under",
		node_cave_liquid = { "default:water_source", "default:lava_source" },
		y_max = -256,
		y_min = -31000,
		heat_point = 50,
		humidity_point = 35,
	})

	-- Desert

	minetest.register_biome({
		name = "desert",
		node_top = "default:sand",
		depth_top = 1,
		node_filler = "default:sand",
		depth_filler = 1,
		node_stone = "default:sandstone",
		node_riverbed = "default:sand",
		depth_riverbed = 2,
		y_max = 31000,
		y_min = 4,
		heat_point = 92,
		humidity_point = 16,
	})

	minetest.register_biome({
		name = "desert_ocean",
		node_top = "default:sand",
		depth_top = 1,
		node_filler = "default:sand",
		depth_filler = 3,
		node_stone = "default:sandstone",
		node_riverbed = "default:sand",
		depth_riverbed = 2,
		node_cave_liquid = "default:water_source",
		vertical_blend = 1,
		y_max = 3,
		y_min = -255,
		heat_point = 92,
		humidity_point = 16,
	})

	minetest.register_biome({
		name = "desert_under",
		node_cave_liquid = { "default:water_source", "default:lava_source" },
		y_max = -256,
		y_min = -31000,
		heat_point = 92,
		humidity_point = 16,
	})
end

--
-- Register decorations
--

function default.register_decorations()
	-- Bush
	minetest.register_decoration({
		name = "default:bush",
		deco_type = "schematic",
		place_on = { "default:dirt_with_grass" },
		sidelen = 64,
		noise_params = {
			offset = 0.001,
			scale = 0.00001,
			spread = { x = 1000, y = 1000, z = 1000 },
			seed = 2,
			octaves = 3,
			persist = 0.96,
		},
		biomes = { "forest", "plains" },
		y_max = 31000,
		y_min = 1,
		schematic = minetest.get_modpath("mapgen") .. "/schematics/bush.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
		place_offset_y = 1,
	})

	-- Apple tree and log in forest

	minetest.register_decoration({
		name = "default:tree",
		deco_type = "schematic",
		place_on = { "default:dirt_with_grass" },
		sidelen = 64,
		noise_params = {
			offset = 0.0001,
			scale = 0.005,
			spread = { x = 100, y = 100, z = 100 },
			seed = 2,
			octaves = 3,
			persist = 0.96,
		},
		biomes = { "forest" },
		y_max = 31000,
		y_min = 1,
		schematic = minetest.get_modpath("cl_default") .. "/schematics/tree.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
		place_offset_y = 1,
	})
	minetest.register_decoration({
		name = "default:tree1",
		deco_type = "schematic",
		place_on = { "default:dirt_with_grass" },
		sidelen = 64,
		fill_ratio = 0.0001,
		noise_params = {
			offset = 0.0001,
			scale = 0.005,
			spread = { x = 100, y = 100, z = 100 },
			seed = 2,
			octaves = 3,
			persist = 0.96,
		},
		biomes = { "forest" },
		y_max = 31000,
		y_min = 1,
		schematic = minetest.get_modpath("cl_default") .. "/schematics/tree1.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
		place_offset_y = 1,
	})
	minetest.register_decoration({
		name = "default:tree2",
		deco_type = "schematic",
		place_on = { "default:dirt_with_grass" },
		sidelen = 64,
		fill_ratio = 0.0001,
		noise_params = {
			offset = 0.0001,
			scale = 0.005,
			spread = { x = 100, y = 100, z = 100 },
			seed = 2,
			octaves = 3,
			persist = 0.96,
		},
		biomes = { "forest" },
		y_max = 31000,
		y_min = 1,
		schematic = minetest.get_modpath("cl_default") .. "/schematics/tree2.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
		place_offset_y = 1,
	})

	-- Apple tree in plains
	minetest.register_decoration({
		name = "default:tree plains",
		deco_type = "schematic",
		place_on = { "default:dirt_with_grass" },
		sidelen = 64,
		noise_params = {
			offset = 0.001,
			scale = 0.00001,
			spread = { x = 1000, y = 1000, z = 1000 },
			seed = 2,
			octaves = 3,
			persist = 0.96,
		},
		biomes = { "plains" },
		y_max = 31000,
		y_min = 1,
		schematic = minetest.get_modpath("cl_default") .. "/schematics/tree.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
		place_offset_y = 1,
	})
	minetest.register_decoration({
		name = "default:tree1 plains",
		deco_type = "schematic",
		place_on = { "default:dirt_with_grass" },
		sidelen = 64,
		fill_ratio = 0.0001,
		noise_params = {
			offset = 0.001,
			scale = 0.00001,
			spread = { x = 1000, y = 1000, z = 1000 },
			seed = 2,
			octaves = 3,
			persist = 0.96,
		},
		biomes = { "plains" },
		y_max = 31000,
		y_min = 1,
		schematic = minetest.get_modpath("cl_default") .. "/schematics/tree1.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
		place_offset_y = 1,
	})
	minetest.register_decoration({
		name = "default:tree2 plains",
		deco_type = "schematic",
		place_on = { "default:dirt_with_grass" },
		sidelen = 64,
		fill_ratio = 0.0001,
		noise_params = {
			offset = 0.001,
			scale = 0.00001,
			spread = { x = 1000, y = 1000, z = 1000 },
			seed = 2,
			octaves = 3,
			persist = 0.96,
		},
		biomes = { "plains" },
		y_max = 31000,
		y_min = 1,
		schematic = minetest.get_modpath("cl_default") .. "/schematics/tree2.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
		place_offset_y = 1,
	})

	-- Sugar cane

	minetest.register_decoration({
		name = "farming:sugar_cane",
		deco_type = "schematic",
		place_on = { "default:sand", "default:dirt", "default:dirt_with_grass" },
		sidelen = 16,
		fill_ratio = 0.1,
		y_min = 1,
		y_max = 100,
		spawn_by = "default:water_source",
		num_spawn_by = 1,
		schematic = minetest.get_modpath("mapgen") .. "/schematics/sugar_cane.mts",
		flags = "place_center_x, place_center_z, force_placement",
		place_offset_y = 1,
	})

	-- Bush

	minetest.register_decoration({
		name = "farming:bush",
		deco_type = "simple",
		place_on = { "default:dirt", "default:dirt_with_grass" },
		sidelen = 16,
		noise_params = {
			offset = -0.00003,
			scale = 0.09,
			spread = { x = 1, y = 1, z = 1 },
			seed = 230,
			octaves = 3,
			persist = 0.6,
		},
		biomes = { "plains", "forest" },
		y_max = 31000,
		y_min = 4,
		decoration = "farming:bush",
		height = 1,
		height_max = 1,
	})

	-- Cactus

	minetest.register_decoration({
		name = "farming:cactus",
		deco_type = "simple",
		place_on = { "default:sand" },
		sidelen = 16,
		noise_params = {
			offset = 0.0001,
			scale = 0.009,
			spread = { x = 10, y = 10, z = 10 },
			seed = 230,
			octaves = 3,
			persist = 0.6,
		},
		biomes = { "desert" },
		y_max = 31000,
		y_min = 4,
		decoration = "farming:cactus",
		height = 1,
		height_max = 3,
	})
end

default.register_biomes()
default.register_ores()
default.register_decorations()
