function register_slab(baseid, id, name, image, groups, sounds)
	if baseid then
		minetest.register_craft({
			output = id .. " 6",
			recipe = {
				{ baseid, baseid, baseid },
			},
		})
	end
	minetest.register_node(id, {
		description = name,
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -0.5, 0.5, 0, 0.5 },
		},
		selection_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -0.5, 0.5, 0, 0.5 },
		},
		tiles = { image },
		groups = groups,
		sounds = sounds,
	})
end

register_slab(
	"default:cobble",
	"slabs:cobble",
	"Cobblestone slab",
	"cobble.png",
	{ stone = 4 },
	default.node_sound.stone
)

register_slab("default:sand", "slabs:sand", "Sand slab", "sand.png", { dirt = 2 }, default.node_sound.sand)
register_slab("default:gravel", "slabs:gravel", "Gravel slab", "gravel.png", { dirt = 3 }, default.node_sound.gravel)
register_slab(
	"default:stone",
	"slabs:stone",
	"Stone slab",
	"stone.png",
	{ stone = 3, level = 1 },
	default.node_sound.stone
)
register_slab(
	"default:stone_bricks",
	"slabs:stone_bricks",
	"Stone bricks slab",
	"stone_bricks.png",
	{ stone = 3, level = 1 },
	default.node_sound.stone
)
register_slab(
	"default:cobble",
	"slabs:cobble",
	"Cobblestone slab",
	"cobble.png",
	{ stone = 3, level = 1 },
	default.node_sound.stone
)
register_slab(
	"default:cobble_bricks",
	"slabs:cobble_bricks",
	"Cobblestone bricks slab",
	"cobble_bricks.png",
	{ stone = 3, level = 1 },
	default.node_sound.stone
)
