local function can_dig_chest(pos, player)
	local meta = minetest.get_meta(pos)
	local inv = meta:get_inventory()
	if not inv:is_empty("main") then
		return false
	end
	local player_name = player:get_player_name()
	if minetest.is_protected(pos, player_name) then
		minetest.record_protection_violation(pos, player_name)
		return false
	end
	return true
end

function register_chest(id, material, name)
	local l = string.lower(name)
	minetest.register_node(id, {
		description = name .. " Chest",
		tiles = {
			l .. "_chest_top.png",
			l .. "_chest_top.png",
			l .. "_chest_side.png",
			l .. "_chest_side.png",
			l .. "_chest_side.png",
			l .. "_chest_front.png",
		},
		paramtype2 = "facedir",
		legacy_facedir_simple = true,
		groups = { wood = 6 },
		is_ground_content = false,
		sounds = default.node_sound.wood,
		on_construct = function(pos)
			local meta = minetest.get_meta(pos)
			meta:set_string(
				"formspec",
				"size[8,9]"
					.. "list[current_name;main;0,0;8,4;]"
					.. "list[current_player;main;0,5;8,4;]"
					.. "listring[current_name;main]"
					.. "listring[current_player;main]"
			)
			meta:set_string("infotext", name .. " Chest")
			local inv = meta:get_inventory()
			inv:set_size("main", 8 * 4)
		end,
		can_dig = can_dig_chest,
	})
	minetest.register_craft({
		output = id,
		recipe = {
			{ material, material, material },
			{ material, "", material },
			{ material, material, material },
		},
	})
end
