-- Convert grass into mud if under something else than air
minetest.register_abm({
	label = "Mud to Grass",
	nodenames = { "default:dirt" },
	neighbors = { "group:air_equivalent" },
	interval = 1,
	chance = 20,
	catch_up = false, -- Back in my day we had no such thing
	action = function(pos, node)
		local p1 = vector.offset(pos, 0, 1, 0)
		local above = minetest.get_node(p1)
		if minetest.get_item_group(above.name, "air_equivalent") > 0 and minetest.get_node_light(p1) >= 13 then
			node.name = "default:dirt_with_grass"
			minetest.swap_node(pos, node)
		end
	end,
})

-- Convert grass into mud if under something else than air
minetest.register_abm({
	label = "Grass to Mud",
	nodenames = { "default:dirt_with_grass" },
	interval = 3,
	catch_up = false,
	action = function(pos, node)
		local above = minetest.get_node(vector.offset(pos, 0, 1, 0))
		if above.name ~= "farming:bush" and minetest.get_item_group(above.name, "air_equivalent") == 0 then
			node.name = "default:dirt"
			minetest.swap_node(pos, node)
		end
	end,
})

minetest.register_abm({
	label = "Saplings",
	nodenames = { "default:sapling" },
	interval = 5,
	chance = 10,
	catch_up = false,
	action = function(pos, node)
		minetest.log("action", "A sapling grows into a tree at " .. minetest.pos_to_string(pos))
		local trees = { "tree.mts", "tree1.mts", "tree2.mts" }
		minetest.set_node(pos, { name = "air" })
		minetest.place_schematic(
			pos,
			minetest.get_modpath("cl_default") .. "/schematics/" .. trees[math.random(2) + 1],
			math.random(4) * 90,
			{},
			false,
			{}
		)
	end,
})

minetest.register_abm({
	label = "Leaf decay",
	nodenames = { "default:leaves" },
	interval = 1,
	chance = 5,
	action = function(pos, node)
		if not minetest.find_node_near(pos, 5, { "default:tree" }) then
			minetest.set_node(pos, { name = "air" })
			if math.random(0, 100) > 50 then -- 50%
				minetest.add_item(pos, node)
			end
		end
	end,
})
