removing = false

minetest.register_node("teleporter:teleporter", {
  description = "Teleporter",
  tiles = { "teleporter.png" },
  groups = { stone = 5, level = 3 },
  drop = "minerals:ingot_steel 4",

  on_destruct = function(pos)
    if removing then
      return
    end
    local meta = minetest.get_meta(pos)
    local x = meta:get_int("x")
    local y = meta:get_int("y")
    local z = meta:get_int("z")
    removing = true
    minetest.set_node({ x = x, y = y, z = z }, { name = "air" })
    removing = false
    --minetest.log("warning",
      --"Removed a teleporter at " ..
      --minetest.pos_to_string(pos, 0) .. " that links to " .. string.format("%d, %d, %d", x, y, z))
  end,

  after_place_node = function(pos)
    local meta = minetest.get_meta(pos)
    local x,y,z
    minetest.log("warning", "placing teleporter")
    x = math.random(-20000, 20000)
    z = math.random(-20000, 20000)
    local pos1 = { x = x - 1, y = -100, z = z - 1 }
    local pos2 = { x = x + 1, y = 100, z = z + 1 }
    minetest.log("warning", "emerging area " .. string.format("X: %d, Z: %d", x, z))
    minetest.emerge_area(pos1, pos2, function(blockpos, action, calls_remaining, param)
        -- hold until done
        if calls_remaining == 0 then
          minetest.log("warning", "emerged area")
          for i=-10,100 do
            y = i
            if minetest.get_node({ x = x, y = y + 1, z = z }).name == "air" and
              minetest.get_node({ x = x, y = y + 2, z = z }).name == "air" and
              minetest.get_node({ x = x, y = y - 1, z = z }).name ~= "air" then
              break
            end
            if y == 100 then minetest.log("FAILED FINDING CORRECT SPOT") end
          end
          meta:set_int("x", x)
          meta:set_int("y", y)
          meta:set_int("z", z)
          minetest.set_node({ x = x, y = y, z = z }, { name = "teleporter:teleporter" })
          local meta_other = minetest.get_meta({ x = x, y = y, z = z })
          meta_other:set_int("x", pos.x)
          meta_other:set_int("y", pos.y)
          meta_other:set_int("z", pos.z)
          minetest.log("warning",
            "Placed a teleporter at " ..
            minetest.pos_to_string(pos, 0) .. "that links to " .. string.format("%d, %d, %d", x, y, z))
        end
      end
    )
  end,

  on_rightclick = function(pos, node, clicker)
    local meta = minetest.get_meta(pos)
    local x = meta:get_int("x")
    local y = meta:get_int("y")
    local z = meta:get_int("z")
    minetest.chat_send_player(clicker:get_player_name(),
      "Sending to " .. string.format("%d, %d, %d", x, y + 1, z) .. "..")
    clicker:set_pos({ x = x, y = y + 1, z = z })
  end,
})

minetest.register_craft({
  output = "teleporter:teleporter",
  recipe = {
    { "minerals:ingot_steel", "minerals:ingot_steel", "minerals:ingot_steel" },
    { "minerals:ingot_steel", "",                     "minerals:ingot_steel" },
    { "minerals:ingot_iron",  "minerals:ingot_iron",  "minerals:ingot_iron" },
  }
})
