--------------
-- Spawning --
--------------

local random = math.random

local common_spawn_chance = tonumber(minetest.settings:get("animalia_common_chance")) or 60000
local ambient_spawn_chance = tonumber(minetest.settings:get("animalia_ambient_chance")) or 9000

local pest_spawn_chance = tonumber(minetest.settings:get("animalia_pest_chance")) or 3000

creatura.register_abm_spawn("animalia:chicken", {
	chance = common_spawn_chance,
	spawn_active = true,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 5,
	spawn_cap = 3,
	nodes = { "group:soil" },
	neighbors = { "air", "group:grass", "group:flora" },
})

creatura.register_abm_spawn("animalia:cow", {
	chance = common_spawn_chance,
	spawn_active = true,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 4,
	spawn_cap = 3,
	nodes = { "group:soil" },
	neighbors = { "air", "group:grass", "group:flora" },
})

creatura.register_abm_spawn("animalia:horse", {
	chance = common_spawn_chance,
	spawn_active = true,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 4,
	spawn_cap = 3,
	nodes = { "group:soil" },
	neighbors = { "air", "group:grass", "group:flora" },
})

creatura.register_abm_spawn("animalia:rat", {
	chance = pest_spawn_chance,
	interval = 60,
	min_height = -1,
	max_height = 1024,
	min_group = 1,
	max_group = 3,
	spawn_in_nodes = true,
	nodes = { "group:crop" },
})

creatura.register_abm_spawn("animalia:pig", {
	chance = common_spawn_chance,
	spawn_active = true,
	min_height = 0,
	max_height = 1024,
	min_group = 2,
	max_group = 3,
	spawn_cap = 3,
	nodes = { "group:soil" },
	neighbors = { "air", "group:grass", "group:flora" },
})

creatura.register_abm_spawn("animalia:sheep", {
	chance = common_spawn_chance,
	spawn_active = true,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 6,
	spawn_cap = 3,
	nodes = { "group:soil" },
	neighbors = { "air", "group:grass", "group:flora" },
})

creatura.register_abm_spawn("animalia:bat", {
	chance = ambient_spawn_chance,
	interval = 30,
	min_light = 0,
	min_height = -31000,
	max_height = 1,
	min_group = 3,
	max_group = 5,
	spawn_cap = 6,
	nodes = { "group:stone" },
})

-- World Gen Spawning

minetest.register_node("animalia:spawner", {
	description = "???",
	drawtype = "airlike",
	walkable = false,
	pointable = false,
	sunlight_propagates = true,
	groups = { oddly_breakable_by_hand = 1, not_in_creative_inventory = 1 },
})

minetest.register_decoration({
	name = "animalia:world_gen_spawning",
	deco_type = "simple",
	place_on = { "group:stone", "group:sand", "group:soil" },
	sidelen = 1,
	fill_ratio = 0.01, -- One node per chunk
	decoration = "animalia:spawner",
})

local function do_on_spawn(pos, obj)
	local name = obj and obj:get_luaentity().name
	if not name then
		return
	end
	local spawn_functions = creatura.registered_on_spawns[name] or {}

	if #spawn_functions > 0 then
		for _, func in ipairs(spawn_functions) do
			func(obj:get_luaentity(), pos)
			if not obj:get_yaw() then
				break
			end
		end
	end
end

minetest.register_abm({
	label = "[animalia] World Gen Spawning",
	nodenames = { "animalia:spawner" },
	interval = 10, -- TODO: Set this to 1 if world is singleplayer and just started
	chance = 1,

	action = function(pos, _, active_object_count)
		minetest.remove_node(pos)

		local spawnable_mobs = {}

		local spawn_definitions = creatura.registered_mob_spawns

		for mob, def in pairs(spawn_definitions) do
			if mob:match("^animalia:") then
				table.insert(spawnable_mobs, mob)
			end
		end

		if #spawnable_mobs > 0 then
			local mob_to_spawn = spawnable_mobs[math.random(#spawnable_mobs)]
			local spawn_definition = creatura.registered_mob_spawns[mob_to_spawn]

			local group_size = random(spawn_definition.min_group or 1, spawn_definition.max_group or 1)
			local obj

			if group_size > 1 then
				local offset
				local spawn_pos
				for _ = 1, group_size do
					offset = group_size * 0.5
					spawn_pos = creatura.get_ground_level({
						x = pos.x + random(-offset, offset),
						y = pos.y,
						z = pos.z + random(-offset, offset),
					}, 3)

					if not creatura.is_pos_moveable(spawn_pos, 0.5, 0.5) then
						spawn_pos = pos
					end

					obj = minetest.add_entity(spawn_pos, mob_to_spawn)
					do_on_spawn(spawn_pos, obj)
				end
			else
				obj = minetest.add_entity(pos, mob_to_spawn)
				do_on_spawn(pos, obj)
			end
		end
	end,
})
