local function register_tree(name)
	local l = string.lower(name)
	minetest.register_node("foraging:" .. l .. "_log", {
		description = name .. " Log",
		tiles = { l .. "_log_top.png", l .. "_log_top.png", l .. "_log.png" },
		groups = { wood = 6, log = 1 },
		sounds = default.node_sound.wood,
		after_dig_node = function(pos, node, metadata, digger)
			if digger:get_player_control().sneak then
				default.dig_up(pos, node, digger)
			end
		end,
	})

	minetest.register_node("foraging:" .. l .. "_leaves", {
		description = name .. " Leaves",
		tiles = { l .. "_leaves.png" },
		special_tiles = { l .. "_leaves.png" },
		groups = { wood = 2, leaves = 1 },
		drawtype = "allfaces_optional",
		waving = 1,
		paramtype = "light",
		is_ground_content = false,
		sounds = default.node_sound.leaves,
	})

	minetest.register_node("foraging:" .. l .. "_plank", {
		description = name .. " Plank",
		tiles = { l .. "_plank.png" },
		groups = { wood = 5, plank = 1 },
		sounds = default.node_sound.wood,
	})

	minetest.register_craft({
		output = "foraging:" .. l .. "_plank 4",
		recipe = {
			{ "foraging:" .. l .. "_log" },
		},
	})

	minetest.register_craft({
		type = "fuel",
		recipe = "foraging:" .. l .. "_plank",
		burntime = 10,
	})

	minetest.register_craft({
		type = "fuel",
		recipe = "foraging:" .. l .. "_log",
		burntime = 40,
	})

	register_stair(
		"foraging:" .. l .. "_plank",
		"foraging:" .. l .. "_plank_stair",
		name .. " Wood Stair",
		l .. "_plank.png",
		{ wood = 5 },
		default.node_sound.wood
	)

	register_slab(
		"foraging:" .. l .. "_plank",
		"foraging:" .. l .. "_plank_slab",
		name .. " Wood Slab",
		l .. "_plank.png",
		{ wood = 5 },
		default.node_sound.wood
	)

	register_fence(
		"foraging:" .. l .. "_plank",
		"foraging:" .. l .. "_fence",
		name .. " Wood Fence",
		l .. "_plank.png",
		{ wood = 3 },
		default.node_sound.wood
	)

	doors.register_fencegate("foraging:" .. l .. "_gate", {
		description = name .. " Wood Gate",
		texture = "oak_plank.png",
		material = "foraging:" .. l .. "_plank",
		groups = { wood = 2 },
	})

	doors.register_trapdoor("foraging:" .. l .. "_trapdoor", {
		description = name .. " Wood Trapdoor",
		inventory_image = l .. "_trapdoor.png",
		wield_image = l .. "_trapdoor.png",
		tile_front = l .. "_trapdoor.png",
		tile_side = l .. "_trapdoor_side.png",
		gain_open = 0.06,
		gain_close = 0.13,
		groups = { choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, door = 1 },
		material = "foraging:" .. l .. "_plank",
	})

	doors.register("foraging:" .. l .. "_door", {
		tiles = { { name = l .. "_door.png", backface_culling = true } },
		description = name .. "Wood Door",
		inventory_image = l .. "_door_item.png",
		groups = { node = 1, choppy = 2, oddly_breakable_by_hand = 2, flammable = 2 },
		gain_open = 0.06,
		gain_close = 0.13,
		material = "foraging:" .. l .. "_plank",
	})

	register_chest("foraging:" .. l .. "_chest", "foraging:" .. l .. "_plank", name)
end

register_tree("Oak")
