minetest.register_node("newhorizons:Redstone", {
    description = "Redstone",
    tiles = {"Redstone.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:RedstoneBlock", {
    description = "Redstone Block",
    tiles = {"RedstoneBlock.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:RedstoneBrick", {
    description = "Redstone Brick",
    tiles = {"RedstoneBrick.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:RedstonePillar", {
    description = "Redstone Pillar",
    tiles = {"RedstonePillar.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:RedstonePillarTop", {
    description = "Redstone Pillar Top",
    tiles = {"RedstonePillarTop.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:RedstonePillarBottom", {
    description = "Redstone Pillar Bottom",
    tiles = {"RedstonePillarBottom.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:RedstoneInscribedTop", {
    description = "Redstone Inscribed Top",
    tiles = {"RedstoneEnscribedTop.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:RedstoneInscribedBottom", {
    description = "Redstone Inscribed Bottom",
    tiles = {"RedstoneEnscribedBottom.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})


minetest.register_node("newhorizons:RedstoneCracked", {
    description = "Craked Redstone",
    tiles = {"RedstoneCracked.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})





minetest.register_craft( {
        type = "shapeless",
	output = "newhorizons:RedstoneBlock 4",
	recipe = {
		"newhorizons:Redstone", 
		"newhorizons:Redstone",
		"newhorizons:Redstone",
		"newhorizons:Redstone", 
		
	},
})



minetest.register_craft({
    type = "cooking",
    output = "newhorizons:RedstoneBrick",
    recipe = "newhorizons:Redstone",
    
})





minetest.register_craft({
    type = "shaped",
    output = "newhorizons:RedstoneInscribedBottom 3",
    recipe = {
        {"", "",  ""},
        {"", "",  ""},
        {"newhorizons:RedstoneBrick", "newhorizons:RedstoneBrick", "newhorizons:RedstoneBrick"}
    }
})




minetest.register_craft({
    type = "shaped",
    output = "newhorizons:RedstonePillarTop 6",
    recipe = {
        {"newhorizons:RedstoneBrick", "newhorizons:RedstoneBrick", "newhorizons:RedstoneBrick"}, 
        {"newhorizons:RedstoneBrick", "",  "newhorizons:RedstoneBrick"},
        {"newhorizons:RedstoneBrick", "",  "newhorizons:RedstoneBrick"}
        
    }
})

minetest.register_craft({
    type = "shaped",
    output = "newhorizons:RedstonePillar 6",
    recipe = {
        {"newhorizons:RedstoneBrick", "",  "newhorizons:RedstoneBrick"}, 
        {"newhorizons:RedstoneBrick", "",  "newhorizons:RedstoneBrick"},
        {"newhorizons:RedstoneBrick", "",  "newhorizons:RedstoneBrick"}
        
    }
})



minetest.register_craft({
    type = "shaped",
    output = "newhorizons:RedstonePillarBottom 6",
    recipe = {
        {"newhorizons:RedstoneBrick", "",  "newhorizons:RedstoneBrick"}, 
        {"newhorizons:RedstoneBrick", "",  "newhorizons:RedstoneBrick"},
        {"newhorizons:RedstoneBrick", "newhorizons:RedstoneBrick",  "newhorizons:RedstoneBrick"}
        
    }
})





minetest.register_craft( {
        type = "shapeless",
	output = "newhorizons:RedstoneCracked 4",
	recipe = {
		"newhorizons:RedstoneBrick", 
		"newhorizons:RedstoneBrick",
		"newhorizons:RedstoneBrick",
		"newhorizons:RedstoneBrick",
		
	},
})







minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:RedstoneInscribedTop 5",
    recipe = {
        "newhorizons:RedstoneBrick",
        "newhorizons:RedstoneBrick",
        "newhorizons:RedstoneBrick",
        "newhorizons:RedstoneBrick",
        "newhorizons:RedstoneBrick",
    },
})


























































minetest.register_node("newhorizons:Lightstone", {
    description = "Lightstone",
    tiles = {"Lightstone.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:LightstoneBlock", {
    description = "Lightstone Block",
    tiles = {"LightstoneBlock.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:LightstoneBrick", {
    description = "Lightstone Brick",
    tiles = {"LightstoneBrick.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:LightstonePillar", {
    description = "Lightstone Pillar",
    tiles = {"LightstonePillar.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:LightstonePillarTop", {
    description = "Lightstone Pillar Top",
    tiles = {"LightstonePillarTop.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:LightstonePillarBottom", {
    description = "Lightstone Pillar Bottom",
    tiles = {"LightstonePillarBottom.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:LightstoneInscribedTop", {
    description = "Lightstone Inscribed Top",
    tiles = {"LightstoneEnscribedTop.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:LightstoneInscribedBottom", {
    description = "Lightstone Inscribed Bottom",
    tiles = {"LightstoneEnscribedBottom.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})


minetest.register_node("newhorizons:LightstoneCracked", {
    description = "Cracked Lightstone",
    tiles = {"LightstoneCracked.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})





minetest.register_craft( {
        type = "shapeless",
	output = "newhorizons:LightstoneBlock 4",
	recipe = {
		"newhorizons:Lightstone", 
		"newhorizons:Lightstone",
		"newhorizons:Lightstone",
		"newhorizons:Lightstone", 
		
	},
})



minetest.register_craft({
    type = "cooking",
    output = "newhorizons:LightstoneBrick",
    recipe = "newhorizons:Lightstone",
    
})








minetest.register_craft({
    type = "shaped",
    output = "newhorizons:LightstonePillarTop 6",
    recipe = {
        {"newhorizons:LightstoneBrick", "newhorizons:LightstoneBrick", "newhorizons:LightstoneBrick"}, 
        {"newhorizons:LightstoneBrick", "",  "newhorizons:LightstoneBrick"},
        {"newhorizons:LightstoneBrick", "",  "newhorizons:LightstoneBrick"}
        
    }
})

minetest.register_craft({
    type = "shaped",
    output = "newhorizons:LightstonePillar 6",
    recipe = {
        {"newhorizons:LightstoneBrick", "",  "newhorizons:LightstoneBrick"}, 
        {"newhorizons:LightstoneBrick", "",  "newhorizons:LightstoneBrick"},
        {"newhorizons:LightstoneBrick", "",  "newhorizons:LightstoneBrick"}
        
    }
})



minetest.register_craft({
    type = "shaped",
    output = "newhorizons:LightstonePillarBottom 6",
    recipe = {
        {"newhorizons:LightstoneBrick", "",  "newhorizons:LightstoneBrick"}, 
        {"newhorizons:LightstoneBrick", "",  "newhorizons:LightstoneBrick"},
        {"newhorizons:LightstoneBrick", "newhorizons:LightstoneBrick",  "newhorizons:LightstoneBrick"}
        
    }
})





minetest.register_craft( {
        type = "shapeless",
	output = "newhorizons:LightstoneCracked 4",
	recipe = {
		"newhorizons:LightstoneBrick", 
		"newhorizons:LightstoneBrick",
		"newhorizons:LightstoneBrick",
		"newhorizons:LightstoneBrick", 
		
	},
})




minetest.register_craft({
    type = "shaped",
    output = "newhorizons:LightstoneInscribedBottom 3",
    recipe = {
        {"", "",  ""},
        {"", "",  ""},
        {"newhorizons:LightstoneBrick", "newhorizons:LightstoneBrick", "newhorizons:LightstoneBrick"}
    }
})




minetest.register_craft({
    type = "shaped",
    output = "newhorizons:WarningBlock 2",
    recipe = {
        {"", "",  "dye:yellow"},
        {"", "dye:black",  ""},
        {"dye:yellow", "", ""}
    }
})






minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:LightstoneInscribedTop 5",
    recipe = {
        "newhorizons:LightstoneBrick",
        "newhorizons:LightstoneBrick",
        "newhorizons:LightstoneBrick",
        "newhorizons:LightstoneBrick",
        "newhorizons:LightstoneBrick",
    },
})

































minetest.register_node("newhorizons:Bluestone", {
    description = "Bluestone",
    tiles = {"Bluestone.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:BluestoneBlock", {
    description = "Bluestone Block",
    tiles = {"BluestoneBlock.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:BluestoneBrick", {
    description = "Bluestone Brick",
    tiles = {"BluestoneBrick.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:BluestonePillar", {
    description = "Bluestone Pillar",
    tiles = {"BluestonePillar.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:BluestonePillarTop", {
    description = "Bluestone Pillar Top",
    tiles = {"BluestonePillarTop.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:BluestonePillarBottom", {
    description = "Bluestone Pillar Bottom",
    tiles = {"BluestonePillarBottom.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:BluestoneInscribedTop", {
    description = "Bluestone Inscribed Top",
    tiles = {"BluestoneEnscribedTop.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:BluestoneInscribedBottom", {
    description = "Bluestone Inscribed Bottom",
    tiles = {"BluestoneEnscribedBottom.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})


minetest.register_node("newhorizons:BluestoneCracked", {
    description = "Craked Bluestone",
    tiles = {"BluestoneCracked.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})





minetest.register_craft( {
        type = "shapeless",
	output = "newhorizons:BluestoneBlock 4",
	recipe = {
		"newhorizons:Bluestone", 
		"newhorizons:Bluestone",
		"newhorizons:Bluestone",
		"newhorizons:Bluestone", 
		
	},
})



minetest.register_craft({
    type = "cooking",
    output = "newhorizons:BluestoneBrick",
    recipe = "newhorizons:Bluestone",
    
})





minetest.register_craft({
    type = "shaped",
    output = "newhorizons:BluestoneInscribedBottom 3",
    recipe = {
        {"", "",  ""},
        {"", "",  ""},
        {"newhorizons:BluestoneBrick", "newhorizons:BluestoneBrick", "newhorizons:BluestoneBrick"}
    }
})




minetest.register_craft({
    type = "shaped",
    output = "newhorizons:BluestonePillarTop 6",
    recipe = {
        {"newhorizons:BluestoneBrick", "newhorizons:BluestoneBrick", "newhorizons:BluestoneBrick"}, 
        {"newhorizons:BluestoneBrick", "",  "newhorizons:BluestoneBrick"},
        {"newhorizons:BluestoneBrick", "",  "newhorizons:BluestoneBrick"}
        
    }
})

minetest.register_craft({
    type = "shaped",
    output = "newhorizons:BluestonePillar 6",
    recipe = {
        {"newhorizons:BluestoneBrick", "",  "newhorizons:BluestoneBrick"}, 
        {"newhorizons:BluestoneBrick", "",  "newhorizons:BluestoneBrick"},
        {"newhorizons:BluestoneBrick", "",  "newhorizons:BluestoneBrick"}
        
    }
})



minetest.register_craft({
    type = "shaped",
    output = "newhorizons:BluestonePillarBottom 6",
    recipe = {
        {"newhorizons:BluestoneBrick", "",  "newhorizons:BluestoneBrick"}, 
        {"newhorizons:BluestoneBrick", "",  "newhorizons:BluestoneBrick"},
        {"newhorizons:BluestoneBrick", "newhorizons:BluestoneBrick",  "newhorizons:BluestoneBrick"}
        
    }
})





minetest.register_craft( {
        type = "shapeless",
	output = "newhorizons:BluestoneCracked 4",
	recipe = {
		"newhorizons:BluestoneBrick", 
		"newhorizons:BluestoneBrick",
		"newhorizons:BluestoneBrick",
		"newhorizons:BluestoneBrick",
		
	},
})







minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:BluestoneInscribedTop 5",
    recipe = {
        "newhorizons:BluestoneBrick",
        "newhorizons:BluestoneBrick",
        "newhorizons:BluestoneBrick",
        "newhorizons:BluestoneBrick",
        "newhorizons:BluestoneBrick",
    },
})


















minetest.register_node("newhorizons:Darkstone", {
    description = "Darkstone",
    light_source = 8,
    tiles = {"Darkstone.png"},
    is_ground_content = true,
    
    groups = {cracky=3, stone=1}
    
})

minetest.register_node("newhorizons:DarkstoneBlock", {
    description = "Darkstone Block",
    tiles = {"DarkstoneBlock.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:DarkstoneBrick", {
    description = "Darkstone Brick",
    tiles = {"DarkstoneBrick.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:DarkstonePillar", {
    description = "Darkstone Pillar",
    tiles = {"DarkstonePillar.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:DarkstonePillarTop", {
    description = "Darkstone Pillar Top",
    tiles = {"DarkstonePillarTop.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:DarkstonePillarBottom", {
    description = "Darkstone Pillar Bottom",
    tiles = {"DarkstonePillarBottom.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:DarkstoneInscribedTop", {
    description = "Darkstone Inscribed Top",
    tiles = {"DarkstoneEnscribedTop.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:DarkstoneInscribedBottom", {
    description = "Darkstone Inscribed Bottom",
    tiles = {"DarkstoneEnscribedBottom.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})


minetest.register_node("newhorizons:DarkstoneCracked", {
    description = "Craked Darkstone",
    tiles = {"DarkstoneCracked.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})




minetest.register_craft( {
        type = "shapeless",
	output = "newhorizons:DarkstoneBlock 4",
	recipe = {
		"newhorizons:Darkstone", 
		"newhorizons:Darkstone",
		"newhorizons:Darkstone",
		"newhorizons:Darkstone", 
		
	},
})



minetest.register_craft({
    type = "cooking",
    output = "newhorizons:DarkstoneBrick",
    recipe = "newhorizons:Darkstone",
    
})





minetest.register_craft({
    type = "shaped",
    output = "newhorizons:DarkstoneInscribedBottom 3",
    recipe = {
        {"", "",  ""},
        {"", "",  ""},
        {"newhorizons:DarkstoneBrick", "newhorizons:DarkstoneBrick", "newhorizons:DarkstoneBrick"}
    }
})




minetest.register_craft({
    type = "shaped",
    output = "newhorizons:DarkstonePillarTop 6",
    recipe = {
        {"newhorizons:DarkstoneBrick", "newhorizons:DarkstoneBrick", "newhorizons:DarkstoneBrick"}, 
        {"newhorizons:DarkstoneBrick", "",  "newhorizons:DarkstoneBrick"},
        {"newhorizons:DarkstoneBrick", "",  "newhorizons:DarkstoneBrick"}
        
    }
})

minetest.register_craft({
    type = "shaped",
    output = "newhorizons:DarkstonePillar 6",
    recipe = {
        {"newhorizons:DarkstoneBrick", "",  "newhorizons:DarkstoneBrick"}, 
        {"newhorizons:DarkstoneBrick", "",  "newhorizons:DarkstoneBrick"},
        {"newhorizons:DarkstoneBrick", "",  "newhorizons:DarkstoneBrick"}
        
    }
})



minetest.register_craft({
    type = "shaped",
    output = "newhorizons:DarkstonePillarBottom 6",
    recipe = {
        {"newhorizons:DarkstoneBrick", "",  "newhorizons:DarkstoneBrick"}, 
        {"newhorizons:DarkstoneBrick", "",  "newhorizons:DarkstoneBrick"},
        {"newhorizons:DarkstoneBrick", "newhorizons:DarkstoneBrick",  "newhorizons:DarkstoneBrick"}
        
    }
})





minetest.register_craft( {
        type = "shapeless",
	output = "newhorizons:DarkstoneCracked 4",
	recipe = {
		"newhorizons:DarkstoneBrick", 
		"newhorizons:DarkstoneBrick",
		"newhorizons:DarkstoneBrick",
		"newhorizons:DarkstoneBrick",
		
	},
})







minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:DarkstoneInscribedTop 5",
    recipe = {
        "newhorizons:DarkstoneBrick",
        "newhorizons:DarkstoneBrick",
        "newhorizons:DarkstoneBrick",
        "newhorizons:DarkstoneBrick",
        "newhorizons:DarkstoneBrick",
    },
})
















minetest.register_node("newhorizons:BurntWood", {
    description = "Burnt Wood",
    tiles = {"BurntWoodTop.png",    
        "BurntWoodTop.png",  
        "BurntWoodSide.png", 
        "BurntWoodSide.png",  
        "BurntWoodSide.png",  
        "BurntWoodSide.png", },
    is_ground_content = true,
    groups = {choppy=3, wood=1}
})




minetest.register_node("newhorizons:BurntPlanks", {
    description = "Burnt Planks",
    tiles = {"BurntPlanks.png"},
    is_ground_content = true,
    groups = {choppy=3, wood=1}
})





minetest.register_craft({
    type = "cooking",
    output = "newhorizons:BurntWood",
    recipe = "default:tree",
    cooktime = 3,
})







minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:BurntPlanks 8",
    recipe = {
        "newhorizons:BurntWood",
        "newhorizons:BurntWood",
    },
})






minetest.register_node("newhorizons:SolidAir", {
    description = "Solid Air",
    drawtype = "airlike",
    paramtype = "light",
    sunlight_propagates = true,
    inventory_image = "SolidAirInv.png",
    wield_image = "SolidAirInv.png",
    

    walkable     = true, -- Would make the player collide with the air node
    pointable    = true, -- You can't select the node
    diggable     = true, -- You can't dig the node
    buildable_to = false,  -- Nodes can be replace this node.
                          -- (you can place a node and remove the air node
                          -- that used to be there)

    air_equivalent = true,
    groups = {cracky=3}
})



minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:SolidAir 16",
    recipe = {
        "default:mese_crystal",
        "default:steel_ingot",
        "default:paper",
    },
})








minetest.register_node("newhorizons:SteelScaffolding", {
    description = "Steel Scaffolding",
    drawtype = "glasslike",
    tiles = {"SteelScaffolding.png"},
    paramtype = "light",
    is_ground_content = false,
    sunlight_propagates = true,
    climbable = true,
    walkable = false,

    sounds = default.node_sound_stone_defaults(),
    groups = {cracky=3,oddly_breakable_by_hand=3},
    
    
})




minetest.register_node("newhorizons:BluestoneGlass", {
    description = "Bluestone Glass",
    drawtype = "glasslike_framed",
    tiles = {"BluestoneGlass.png", "BluestoneGlass2.png"},
    paramtype = "light",
    light_source = 13,
    sunlight_propagates = true, -- Sunlight can shine through block
    groups = {cracky = 3, oddly_breakable_by_hand = 3},
    sounds = default.node_sound_glass_defaults()
    
})



minetest.register_node("newhorizons:RedstoneGlass", {
    description = "Redstone Glass",
    drawtype = "glasslike_framed",
    tiles = {"RedstoneGlass.png", "BluestoneGlass2.png"},
    paramtype = "light",
    light_source = 13,
    sunlight_propagates = true, -- Sunlight can shine through block
    groups = {cracky = 3, oddly_breakable_by_hand = 3},
    sounds = default.node_sound_glass_defaults()
})





minetest.register_node("newhorizons:DarkstoneGlass", {
    description = "Darkstone Glass",
    drawtype = "glasslike_framed",
    tiles = {"BlackstoneGlass.png", "BluestoneGlass2.png"},
    paramtype = "light",
    light_source = 13,
    sunlight_propagates = true, -- Sunlight can shine through block
    groups = {cracky = 3, oddly_breakable_by_hand = 3},
    sounds = default.node_sound_glass_defaults()
})




minetest.register_node("newhorizons:LightstoneGlass", {
    description = "Lightstone Glass",
    drawtype = "glasslike_framed",
    tiles = {"LightstoneGlass.png", "BluestoneGlass2.png"},
    paramtype = "light",
    light_source = 13,
    sunlight_propagates = true, -- Sunlight can shine through block
    groups = {cracky = 3, oddly_breakable_by_hand = 3},
    sounds = default.node_sound_glass_defaults()
})


minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:SteelScaffolding 5",
    recipe = {
        "default:steel_ingot",
        "default:steel_ingot",
        "default:steel_ingot",
        "default:steel_ingot",
        "default:steel_ingot",
    },
})


minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:BluestoneGlass 1",
    recipe = {
        "default:glass",
        "default:torch",
        "default:torch",
        "newhorizons:Bluestone",
        "default:glass",
    },
})





minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:RedstoneGlass 1",
    recipe = {
        "default:glass",
        "default:torch",
        "default:torch",
        "newhorizons:Redstone",
        "default:glass",
    },
})


minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:DarkstoneGlass 1",
    recipe = {
        "default:glass",
        "default:torch",
        "default:torch",
        "newhorizons:Darkstone",
        "default:glass",
    },
})



minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:LightstoneGlass 1",
    recipe = {
        "default:glass",
        "default:torch",
        "default:torch",
        "newhorizons:Lightstone",
        "default:glass",
    },
})







minetest.register_node("newhorizons:Marble", {
    description = "Marble",
    tiles = {"Marble.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})
	
	

	
minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:Marble 8",
    recipe = {
        "newhorizons:Lightstone",
        "dye:white",
        "newhorizons:Lightstone",
        "newhorizons:Lightstone",
        "newhorizons:Lightstone",
        "newhorizons:Lightstone",
        "newhorizons:Lightstone",
        "newhorizons:Lightstone",
        "newhorizons:Lightstone",
    },
})




minetest.register_biome({
    name = "NuclearWasteland",
    node_top = "newhorizons:Darkstone",
    depth_top = 1,
    node_filler = "newhorizons:DarkstoneCracked",
    depth_filler = 200,
    y_max = 1000,
    y_min = -3,
    heat_point = 100,
    humidity_point = 0,
})




minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"newhorizons:Darkstone"},
    sidelen = 16,
    fill_ratio = 0.0005,
    biomes = {"NuclearWasteland"},
    y_max = 200,
    y_min = 1,
    schematic = minetest.get_modpath("newhorizons") .. "/SchemsC/DeadTree.mts",
    flags = "place_center_x, place_center_z",
    rotation = "random",
})







minetest.register_node("newhorizons:BlueDirtWithGrass", {
    description = "Blue Dirt With Grass",
    tiles = {"BlueGrassTop.png",    
        "BlueDirt.png",  
        "BluegrassSide.png", 
        "BluegrassSide.png",  
        "BluegrassSide.png",  
        "BluegrassSide.png", },
    is_ground_content = true,
    
    groups = {crumbly=3, dirt=1}
    
})








minetest.register_biome({
    name = "FungiForest",
    node_top = "newhorizons:BlueDirtWithGrass",
    depth_top = 1,
    node_filler = "newhorizons:Bluestone",
    depth_filler = 4,
    y_max = 1000,
    y_min = -3,
    heat_point = 25,
    humidity_point = 75,
})






minetest.register_node("newhorizons:BlueGrassPlant", {
    drawtype = "plantlike",
    description = "Blue Grass",
    -- Only one texture used
    tiles = {"BlueGrass.png"},
    paramtype = "light",
    sunlight_propagates = true,
    buildable_to = true,
    groups = {oddly_breakable_by_hand = 3},
    walkable = false,
    selection_box = {
        type = "fixed",
        fixed = {-6 / 16, -0.5, -6 / 16, 6 / 16, 0.5, 6 / 16},
    },
})







minetest.register_node("newhorizons:PurpleMushroom", {
    drawtype = "plantlike",
    description = "Purple Mushroom",
    -- Only one texture used
    tiles = {"PurpleMushroom.png"},
    paramtype = "light",
    sunlight_propagates = true,
    buildable_to = true,
    groups = {oddly_breakable_by_hand = 3},
    walkable = false,
    selection_box = {
        type = "fixed",
        fixed = {-6 / 16, -0.5, -6 / 16, 6 / 16, 0.5, 6 / 16},
    },

    
})



minetest.register_node("newhorizons:MushroomStem", {
    description = "Mushroom Stem",
    tiles = {"MushroomStem.png"},
    is_ground_content = true,
    groups = {choppy=3, wood=1, tree}
})

minetest.register_node("newhorizons:MushroomCap", {
    description = "Mushroom Cap",
    tiles = {"MushroomCap.png"},
    is_ground_content = true,
    light_source = 10,
    groups = {choppy=3, wood=1}
})

minetest.register_node("newhorizons:BlueDirt", {
    description = "Blue Dirt",
    tiles = {"BlueDirt.png"},
    is_ground_content = true,
    groups = {crumbly=3,}
})

minetest.register_node("newhorizons:MushroomCapPurple", {
    description = "Mushroom Cap Purple",
    tiles = {"MushroomCapPurple.png"},
    is_ground_content = true,
    light_source = 10,
    groups = {choppy=3, wood=1}
})






minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"newhorizons:BlueDirtWithGrass"},
    sidelen = 16,
    fill_ratio = 0.005,
    biomes = {"FungiForest"},
    y_max = 200,
    y_min = 1,
    schematic = minetest.get_modpath("newhorizons") .. "/SchemsC/GiantRedMushroom.mts",
    flags = "place_center_x, place_center_z",
    rotation = "random",
})



minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"newhorizons:BlueDirtWithGrass"},
    sidelen = 16,
    fill_ratio = 0.005,
    biomes = {"FungiForest"},
    y_max = 200,
    y_min = 1,
    schematic = minetest.get_modpath("newhorizons") .. "/SchemsC/GiantPurpleMushroom.mts",
    flags = "place_center_x, place_center_z",
    rotation = "random",
})





minetest.register_decoration({
    deco_type = "simple",
    place_on = {"newhorizons:BlueDirtWithGrass"},
    sidelen = 16,
    fill_ratio = 0.1,
    biomes = {"FungiForest"},
    y_max = 200,
    y_min = 1,
    decoration = "newhorizons:BlueGrassPlant",
})


minetest.register_decoration({
    deco_type = "simple",
    place_on = {"newhorizons:BlueDirtWithGrass"},
    sidelen = 16,
    fill_ratio = 0.1,
    biomes = {"FungiForest"},
    y_max = 200,
    y_min = 1,
    decoration = "newhorizons:PurpleMushroom",
})



minetest.register_node("newhorizons:RainbowBlock", {
    description = ("Rainbow Block"),
	tiles = {
		{name="Rainbow.png", animation={type="vertical_frames",
		aspect_w=16, aspect_h=16, length=9}},
	},
	light_source = 9,
	groups = {crumbly=3},
	paramtype = "light",
	sounds = default.node_sound_dirt_defaults(),
})

minetest.register_node("newhorizons:WarningBlock", {
    description = ("Warning Block"),
	tiles = {
		{name="TestGrade.png", animation={type="vertical_frames",
		aspect_w=16, aspect_h=16, length=2}},
	},
	light_source = 9,
	groups = {crumbly=3},
	paramtype = "light",
	sounds = default.node_sound_dirt_defaults(),
})




minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:RainbowBlock 3",
    recipe = {
        "dye:red",
        "dye:blue",
        "dye:green",
        
    },
})

minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:RainbowBlock 3",
    recipe = {
        "dye:white",
        "dye:black",
        "dye:yellow",
        
    },
})



minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:FuturaBlockPillar 2",
    recipe = {
        
        "dye:black",
        "default:steel_ingot",
        "dye:white",
        
    },
})


minetest.register_craft({
    type = "shaped",
    output = "newhorizons:FuturaBlockPillarTop 2",
    recipe = {
        {"dye:black", "default:steel_ingot", "dye:black"}, 
        {"dye:black", "",  ""},
        {"", "",  ""}
        
    }
})



minetest.register_craft({
    type = "shaped",
    output = "newhorizons:FuturaBlockPillarBottom 1",
    recipe = {
        {"", "", ""}, 
        {"", "",  ""},
        {"dye:black", "default:steel_ingot",  "dye:black"}
        
    }
})



minetest.register_node("newhorizons:FuturaBlockPillar", {
    description = "Futura Block Pillar",
    tiles = {"FuturaBlockPillar.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})


minetest.register_node("newhorizons:FuturaBlockPillarTop", {
    description = "Futura Block Pillar Top",
    tiles = {"FuturaBlockPillarTop.png.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_node("newhorizons:FuturaBlockPillarBottom", {
    description = "Futura Block Pillar Bottom",
    tiles = {"FuturaBlockPillarBottom.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})


minetest.register_node("newhorizons:FuturaBlock", {
    description = "Futura Block ",
    tiles = {"FuturaBlock.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})



minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:FuturaBlock 2",
    recipe = {
        
        "dye:white",
        "default:steel_ingot",
        "dye:white",
        
    },
})


minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:FuturaBlockDark 2",
    recipe = {
        
        "dye:grey",
        "default:steel_ingot",
        "dye:grey",
        
    },
})



minetest.register_node("newhorizons:FuturaBlockDark", {
    description = "Futura Block Dark",
    tiles = {"FuturaBlockDark.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})



minetest.register_node("newhorizons:MetallicStripe", {
    description = "Futura Metallic Stripe",
    tiles = {"MetallicStriped.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:MetallicStripe 2",
    recipe = {
        
        "dye:grey",
        "default:steel_ingot",
        "dye:blue",
        
    },
})



minetest.register_node("newhorizons:DarkGrate", {
    description = "Futura Dark Grate",
    drawtype = "glasslike",
    tiles = {"DarkGrate.png"},
    paramtype = "light",
    is_ground_content = false,
    sunlight_propagates = true,
    sounds = default.node_sound_stone_defaults(),
    groups = {cracky=3},
})






minetest.register_node("newhorizons:GoldMetal", {
    description = "Futura Gold Metal",
    tiles = {"GoldFuturaBlock.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})





minetest.register_node("newhorizons:StopSign", {
    description = ("Stop Sign"),
	tiles = {
		{name="StopSign.png", animation={type="vertical_frames",
		aspect_w=16, aspect_h=16, length=2}},
	},
	light_source = 9,
	groups = {crumbly=3},
	paramtype = "light",
	sounds = default.node_sound_dirt_defaults(),
})



minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:StopSign 1",
    recipe = {
        
        "dye:red",
        "dye:blue",
        "dye:black",
        
    },
})



minetest.register_node("newhorizons:ArrowSign", {
    description = ("Arrow Sign"),
	tiles = {
		{name="Arrow.png", animation={type="vertical_frames",
		aspect_w=16, aspect_h=16, length=1}},
	},
	light_source = 9,
	groups = {crumbly=3},
	paramtype = "light",
	sounds = default.node_sound_dirt_defaults(),
})


minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:ArrowSign 1",
    recipe = {
        
        "dye:yellow",
        "dye:yellow",
        "dye:black",
        
    },
})


minetest.register_node("newhorizons:NoSign", {
    description = ("No Sign"),
	tiles = {
		{name="NoSign.png", animation={type="vertical_frames",
		aspect_w=16, aspect_h=16, length=1}},
	},
	light_source = 9,
	groups = {crumbly=3},
	paramtype = "light",
	sounds = default.node_sound_dirt_defaults(),
})


minetest.register_craft({
    type = "shaped",
    output = "newhorizons:NoSign 2",
    recipe = {
        {"dye:black", "", "dye:black"}, 
        {"", "dye:red",  ""},
        {"dye:yellow", "",  "dye:yellow"}
        
    }
})




minetest.register_node("newhorizons:WhiteWood", {
    description = "White Wood",
    tiles = {"WhiteWoodTop.png",    
        "WhiteWoodTop.png",  
        "WhiteWoodSide.png", 
        "WhiteWoodSide.png",  
        "WhiteWoodSide.png",  
        "WhiteWoodSide.png", },
    is_ground_content = true,
    groups = {choppy=3, wood=1}
})




minetest.register_node("newhorizons:WhitePlanks", {
    description = "White Planks",
    tiles = {"WhiteWoodPlanks.png"},
    is_ground_content = true,
    groups = {choppy=3, wood=1}
})

minetest.register_node("newhorizons:WhiteGrass", {
    description = "White Grass",
    tiles = {"LightstoneGrassTop.png"},
    is_ground_content = true,
    groups = {crumbly=3}
})


minetest.register_node("newhorizons:WhiteDirt", {
    description = "White Dirt",
    tiles = {"WhiteDirt.png"},
    is_ground_content = true,
    groups = {crumbly=3}
    
})


minetest.register_node("newhorizons:CamoBlock", {
    description = "Camo Block",
    tiles = {"Camo.png"},
    is_ground_content = true,
    groups = {choppy=3, wood=1}
    
})





minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:WhitePlanks 8",
    recipe = {
        "newhorizons:WhiteWood",
        "newhorizons:WhiteWood",
    },
})



minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:CamoBlock 4",
    recipe = {
        
        "dye:green",
        "default:steel_ingot",
        "dye:green",
        
    },
})


minetest.register_node("newhorizons:BlueLamp", {
    description = "Blue Lamp",
    tiles = {"BlueLamp.png"},
    is_ground_content = true,
    light_source = 13,
    groups = {choppy=3, wood=1}
    
})


minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:BlueLamp 4",
    
    recipe = {
        "default:steel_ingot",
        "dye:blue",
        "default:steel_ingot",
    },
})



minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:WhiteLamp 4",
    
    recipe = {
        "default:steel_ingot",
        "dye:white",
        "default:steel_ingot",
    },
})



minetest.register_node("newhorizons:WhiteLamp", {
    description = "White Lamp",
    tiles = {"WhiteLamp.png"},
    is_ground_content = true,
    light_source = 13,
    groups = {choppy=3, wood=1}
    
})

minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:B 4",
    
    recipe = {
        "default:steel_ingot",
        "dye:blue",
        "default:steel_ingot",
    },
})


minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:GoldMetal 32",
    
    recipe = {
        "default:steel_ingot",
        "dye:white",
        "default:gold_ingot",
    },
})



minetest.register_node("newhorizons:WhiteLeaves", {
    description = "White Leaves",
    drawtype = "glasslike",
    tiles = {"WhiteLeaves.png"},
    is_ground_content = true,
    paramtype = "light",
    sunlight_propagates = true,
    groups = {snappy=3}
    
})






minetest.register_node("newhorizons:StableWaterGreen", {
    description = "Stable Water Green ",
    drawtype = "glasslike",
    tiles = {
		{name="GreenWater.png", animation={type="vertical_frames",
		aspect_w=16, aspect_h=16, length=2}},
	},
    is_ground_content = true,
    walkable = false,
    buildable_to = false,
    paramtype = "light",
    light_source = 13,
    sunlight_propagates = true,
    climbable = true,
    post_effect_color = {a=100, r=98, g=209, b=106},
    groups = {cracky=3}
 
})


minetest.register_node("newhorizons:StableWaterRed", {
    description = "Stable Water Red",
    drawtype = "glasslike",
    tiles = {
		{name="Redwater.png", animation={type="vertical_frames",
		aspect_w=16, aspect_h=16, length=2}},
	},
    is_ground_content = true,
    walkable = false,
    buildable_to = false,
    paramtype = "light",
    light_source = 13,
    sunlight_propagates = true,
    climbable = true,
    post_effect_color = {a=100, r=227, g=11, b=11},
    groups = {cracky=3}
 
})






minetest.register_node("newhorizons:StableWaterBlue", {
    description = "Stable Water Blue",
    drawtype = "glasslike",
    tiles = {
		{name="BlueWater.png", animation={type="vertical_frames",
		aspect_w=16, aspect_h=16, length=2}},
	},
    is_ground_content = true,
    walkable = false,
    buildable_to = false,
    paramtype = "light",
    light_source = 13,
    sunlight_propagates = true,
    climbable = true,
    post_effect_color = {a=100, r=11, g=223, b=227},
    groups = {cracky=3}
 
})
  
  
  
  
  minetest.register_node("newhorizons:QuestionBlock", {
    description = ("Question Sign"),
	tiles = {
		{name="QuestionSign.png", animation={type="vertical_frames",
		aspect_w=16, aspect_h=16, length=2}},
	},
	light_source = 9,
	groups = {crumbly=3},
	paramtype = "light",
	sounds = default.node_sound_dirt_defaults(),
})








minetest.register_craft({
    type = "shaped",
    output = "newhorizons:DarkGrate 4",
    recipe = {
        {"default:steel_ingot", "default:steel_ingot",  "default:steel_ingot"},
        {"dye:black", "dye:black",  "dye:black"},
        {"default:steel_ingot", "default:steel_ingot", "default:steel_ingot"}
    }
})


minetest.register_craft({
    type = "shaped",
    output = "newhorizons:QuestionBlock 4",
    recipe = {
        {"dye:yellow", "dye:yellow",  "dye:yellow"},
        {"dye:black", "dye:black",  "dye:black"},
        {"", "dye:black", ""}
    }
})


minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:StableWaterGreen 1",
    
    recipe = {
        "newhorizons:StableWaterRed",
        "dye:green",
        
    },
})



minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:StableWaterBlue 1",
    
    recipe = {
        "newhorizons:StableWaterRed",
        "dye:blue",
        
    },
})



minetest.register_node("newhorizons:WhiteGrassPlant", {
    drawtype = "plantlike",
    description = "White Grass",
    -- Only one texture used
    tiles = {"WhiteGrass.png"},
    paramtype = "light",
    sunlight_propagates = true,
    light_source = 13,
    buildable_to = true,
    groups = {oddly_breakable_by_hand = 3},
    walkable = false,
    selection_box = {
        type = "fixed",
        fixed = {-6 / 16, -0.5, -6 / 16, 6 / 16, 0.5, 6 / 16},
    },
})


minetest.register_biome({
    name = "ColorlessForest",
    node_top = "newhorizons:WhiteGrass",
    depth_top = 1,
    node_filler = "newhorizons:Lightstone",
    depth_filler = 4,
    y_max = 1000,
    y_min = -3,
    heat_point = 20,
    humidity_point = 20,
})


minetest.register_decoration({
    deco_type = "simple",
    place_on = {"newhorizons:WhiteGrass"},
    sidelen = 16,
    fill_ratio = 0.09,
    biomes = {"ColorlessForest"},
    y_max = 200,
    y_min = 1,
    decoration = "newhorizons:WhiteGrassPlant",
})





minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"newhorizons:WhiteGrass"},
    sidelen = 16,
    fill_ratio = 0.04,
    biomes = {"ColorlessForest"},
    y_max = 200,
    y_min = 1,
    schematic = minetest.get_modpath("newhorizons") .. "/SchemsC/WhiteTree.mts",
    flags = "place_center_x, place_center_z",
    rotation = "random",
})






minetest.register_node("newhorizons:Smoke", {
    description = "Smoke",
    drawtype = "glasslike",
    tiles = {
		{name="Smoke.png", animation={type="vertical_frames",
		aspect_w=16, aspect_h=16, length=2}},
	},
    is_ground_content = true,
    walkable = false,
    buildable_to = false,
    paramtype = "light",
    sunlight_propagates = true,
    climbable = false,
    light_source = 13,
    damage_per_second = 3,
    post_effect_color = {a=150, r=172, g=172, b=172},
    groups = {cracky=3}
    
 
})



minetest.register_biome({
    name = "Redscape",
    node_top = "newhorizons:RedDirt",
    depth_top = 1,
    node_filler = "newhorizons:Redstone",
    depth_filler = 4,
    y_max = 1000,
    y_min = -3,
    heat_point = 70,
    humidity_point = 1,
})


minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:StableWaterRed 16",
    
    recipe = {
        "bucket:bucket_water",
        "dye:red",
        
    },
})


minetest.register_node("newhorizons:RedDirt", {
    description = "Red Dirt",
    tiles = {"RedDirt.png"},
    light_source = 4,
    is_ground_content = true,
    groups = {crumbly=3}
})


minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"newhorizons:RedDirt"},
    sidelen = 16,
    fill_ratio = 0.0005,
    biomes = {"Redscape"},
    y_max = 200,
    y_min = 1,
    schematic = minetest.get_modpath("newhorizons") .. "/SchemsC/Volcano2.mts",
    flags = "place_center_x, place_center_z",
    rotation = "random",
})




minetest.register_node("newhorizons:InvisibleLadder", {
    description = "Invisible Ladder",
    drawtype = "airlike",
    paramtype = "light",
    sunlight_propagates = true,
    inventory_image = "InvisibleLadder.png",
    wield_image = "InvisibleLadder.png",
    

    walkable     = false, -- Would make the player collide with the air node
    pointable    = true, -- You can't select the node
    diggable     = true, -- You can't dig the node
    buildable_to = false,  -- Nodes can be replace this node.
    climbable     = true,                      -- (you can place a node and remove the air node
                          -- that used to be there)

    air_equivalent = true,
    groups = {cracky=3}
})



minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:InvisibleLadder 16",
    recipe = {
        "default:mese_crystal",
        "default:steel_ingot",
        "default:paper",
        "default:ladder",
    },
})



minetest.register_node("newhorizons:InvisibleLadder", {
    description = "Invisible Ladder",
    drawtype = "airlike",
    paramtype = "light",
    sunlight_propagates = true,
    inventory_image = "InvisibleLadder.png",
    wield_image = "InvisibleLadder.png",
    light_source = 13,
    

    walkable     = false, -- Would make the player collide with the air node
    pointable    = true, -- You can't select the node
    diggable     = true, -- You can't dig the node
    buildable_to = false,  -- Nodes can be replace this node.
    climbable     = true,                      -- (you can place a node and remove the air node
                          -- that used to be there)

    air_equivalent = true,
    groups = {cracky=3}
})


minetest.register_node("newhorizons:InvisibleLamp", {
    description = "Invisible Lamp",
    drawtype = "airlike",
    paramtype = "light",
    sunlight_propagates = true,
    inventory_image = "InvisibleLamp.png",
    wield_image = "InvisibleLamp.png",
    light_source = 13,

    walkable     = true, -- Would make the player collide with the air node
    pointable    = true, -- You can't select the node
    diggable     = true, -- You can't dig the node
    buildable_to = false,  -- Nodes can be replace this node.
    climbable     = false,                      -- (you can place a node and remove the air node
                          -- that used to be there)

    air_equivalent = true,
    groups = {cracky=3}
})



minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:InvisibleLamp 4",
    recipe = {
        "default:mese_crystal",
        "default:steel_ingot",
        "default:paper",
        "default:torch",
    },
})


minetest.register_node("newhorizons:InvisibleHealing", {
    description = "Invisible Healer",
    drawtype = "airlike",
    paramtype = "light",
    sunlight_propagates = true,
    inventory_image = "Heart.png",
    wield_image = "Heart.png",
    damage_per_second = -3,

    walkable     = false, -- Would make the player collide with the air node
    pointable    = true, -- You can't select the node
    diggable     = true, -- You can't dig the node
    buildable_to = false,  -- Nodes can be replace this node.
    climbable     = false,                      -- (you can place a node and remove the air node
                          -- that used to be there)

    air_equivalent = true,
    groups = {cracky=3},
})


minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:InvisibleHealing 1",
    recipe = {
        "default:mese_crystal",
        "default:steel_ingot",
        "default:paper",
        "dye:red",
        "default:diamond",
    },
})




minetest.register_node("newhorizons:MetalHD", {
    description = "Metal HD",
    tiles = {"MetalPlus.jpg"},
    is_ground_content = true,
    groups = {cracky=3},
})


minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:MetalHD 4",
    recipe = {
        "dye:black",
        "default:steel_ingot",
        "dye:grey",
        "dye:white",
       
    },
})





minetest.register_node("newhorizons:StoneHD", {
    description = "Stone HD",
    tiles = {"HDStone.jpg"},
    is_ground_content = true,
    groups = {cracky=3,stone=1},
})


minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:StoneHD 4",
    recipe = {
        "dye:black",
        "default:cobble",
        "dye:grey",
        "dye:white",
       
    },
})





minetest.register_node("newhorizons:WhitePlanksHD", {
    description = "White Wood HD",
    tiles = {"HDWhiteWood.jpg"},
    is_ground_content = true,
    groups = {choppy=3,wood=1},
})


minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:WhitePlanksHD 4",
    recipe = {
        
        "newhorizons:WhitePlanks",
        
        "dye:white",
       
    },
})






minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:BurntWoodHD 4",
    recipe = {
        "dye:black",
        "newhorizons",
       
       
    },
})


minetest.register_node("newhorizons:BurntWoodHD", {
    description = "Burnt Wood HD",
    tiles = {"HDBurntWood.jpg"},
    is_ground_content = true,
    groups = {choppy=3,wood=1},
})


minetest.register_craft({
    type = "shapeless",
    output = "newhorizons:WhitePlanksHD 4",
    recipe = {
        
        "newhorizons:BurntPlanks",
        
        "dye:black",
       
    },
})











minetest.register_node("newhorizons:StonePillar1", {
    drawtype = "mesh",
    description = "Stone Pillar Bottom",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDStone.jpg"
    },

    -- Path to the mesh
    mesh = "MarblePillar1.obj",
    groups = {cracky=3,stone=1},
})




minetest.register_node("newhorizons:StonePillar2", {
    drawtype = "mesh",
    description = "Stone Pillar Middle",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDStone.jpg"
    },

    -- Path to the mesh
    mesh = "MarblePillar2.obj",
    groups = {cracky=3,stone=1},
})





minetest.register_node("newhorizons:StonePillar3", {
    drawtype = "mesh",
    description = "Stone Pillar Top",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDStone.jpg"
    },

    -- Path to the mesh
    mesh = "MarblePillar3.obj",
    groups = {cracky=3,stone=1},
})














minetest.register_node("newhorizons:BrickPillar1", {
    drawtype = "mesh",
    description = "Brick Pillar Bottom",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDBrick.jpg"
    },

    -- Path to the mesh
    mesh = "MarblePillar1.obj",
    groups = {cracky=3,Brick=1},
})




minetest.register_node("newhorizons:BrickPillar2", {
    drawtype = "mesh",
    description = "Brick Pillar Middle",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDBrick.jpg"
    },

    -- Path to the mesh
    mesh = "MarblePillar2.obj",
    groups = {cracky=3,Brick=1},
})





minetest.register_node("newhorizons:BrickPillar3", {
    drawtype = "mesh",
    description = "Brick Pillar Top",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDBrick.jpg"
    },

    -- Path to the mesh
    mesh = "MarblePillar3.obj",
    groups = {cracky=3,Brick=1},
})



































minetest.register_node("newhorizons:BurntWoodPillar1", {
    drawtype = "mesh",
    description = "BurntWood Pillar Bottom",
    paramtype = "light",
    
    -- Holds the texture for each "material"
    tiles = {
        "HDBurntWood.jpg"
    },

    -- Path to the mesh
    mesh = "MarblePillar1.obj",
    groups = {cracky=3,BurntWood=1},
})




minetest.register_node("newhorizons:BurntWoodPillar2", {
    drawtype = "mesh",
    description = "BurntWood Pillar Middle",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDBurntWood.jpg"
    },

    -- Path to the mesh
    mesh = "MarblePillar2.obj",
    groups = {cracky=3,BurntWood=1},
})





minetest.register_node("newhorizons:BurntWoodPillar3", {
    drawtype = "mesh",
    description = "BurntWood Pillar Top",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDBurntWood.jpg"
    },

    -- Path to the mesh
    mesh = "MarblePillar3.obj",
    groups = {cracky=3,BurntWood=1},
})

























minetest.register_node("newhorizons:WhiteWoodPillar1", {
    drawtype = "mesh",
    description = "WhiteWood Pillar Bottom",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDWhiteWood.jpg"
    },

    -- Path to the mesh
    mesh = "MarblePillar1.obj",
    groups = {cracky=3,WhiteWood=1},
})




minetest.register_node("newhorizons:WhiteWoodPillar2", {
    drawtype = "mesh",
    description = "WhiteWood Pillar Middle",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDWhiteWood.jpg"
    },

    -- Path to the mesh
    mesh = "MarblePillar2.obj",
    groups = {cracky=3,WhiteWood=1},
})





minetest.register_node("newhorizons:WhiteWoodPillar3", {
    drawtype = "mesh",
    description = "WhiteWood Pillar Top",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDWhiteWood.jpg"
    },

    -- Path to the mesh
    mesh = "MarblePillar3.obj",
    groups = {cracky=3,WhiteWood=1},
})



 





































minetest.register_node("newhorizons:MarblePillar1", {
    drawtype = "mesh",
    description = "Marble Pillar Bottom",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDMarble.png"
    },

    -- Path to the mesh
    mesh = "MarblePillar1.obj",
    groups = {cracky=3,Marble=1},
})




minetest.register_node("newhorizons:MarblePillar2", {
    drawtype = "mesh",
    description = "Marble Pillar Middle",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDMarble.png"
    },

    -- Path to the mesh
    mesh = "MarblePillar2.obj",
    groups = {cracky=3,Marble=1},
})





minetest.register_node("newhorizons:MarblePillar3", {
    drawtype = "mesh",
    description = "Marble Pillar Top",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDMarble.png"
    },

    -- Path to the mesh
    mesh = "MarblePillar3.obj",
    groups = {cracky=3,Marble=1},
})







































minetest.register_node("newhorizons:StoneSphere1", {
    drawtype = "mesh",
    description = "Stone Sphere Bottom",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDStone.jpg"
    },

    -- Path to the mesh
    mesh = "MiniSphere.obj",
    groups = {cracky=3,stone=1},
})

















minetest.register_node("newhorizons:BrickSphere1", {
    drawtype = "mesh",
    description = "Brick Sphere Bottom",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDBrick.jpg"
    },

    -- Path to the mesh
    mesh = "MiniSphere.obj",
    groups = {cracky=3,Brick=1},
})

































minetest.register_node("newhorizons:BurntWoodSphere1", {
    drawtype = "mesh",
    description = "BurntWood Sphere Bottom",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDBurntWood.jpg"
    },

    -- Path to the mesh
    mesh = "MiniSphere.obj",
    groups = {cracky=3,BurntWood=1},
})




























minetest.register_node("newhorizons:WhiteWoodSphere1", {
    drawtype = "mesh",
    description = "WhiteWood Sphere Bottom",
    paramtype = "light",

    -- Holds the texture for each "material"
    tiles = {
        "HDWhiteWood.jpg"
    },

    -- Path to the mesh
    mesh = "MiniSphere.obj",
    groups = {cracky=3,WhiteWood=1},
})






 





































minetest.register_node("newhorizons:MarbleSphere1", {
    drawtype = "mesh",
    description = "Marble Sphere Bottom",
    
    -- Holds the texture for each "material"
    tiles = {
        "HDMarble.png"
    },

    -- Path to the mesh
    mesh = "MiniSphere.obj",
    groups = {cracky=3,Marble=1},
})











minetest.register_node("newhorizons:BrickHD", {
    description = "Brick HD",
    tiles = {"HDBrick.jpg"},
    is_ground_content = true,
    groups = {cracky=3,brick=1},
})



minetest.register_craft({
    type = "shaped",
    output = "newhorizons:BrickHD",
    recipe = {
        {"default:brick", "dye:orange", ""},
        {"dye:white", "dye:black", ""},
        {"", "", ""}
    }
})



































minetest.register_craft({
    type = "shaped",
    output = "newhorizons:BrickPillar3 5",
    recipe = {
        {"newhorizons:BrickHD", "newhorizons:BrickHD", "newhorizons:BrickHD"},
        {"", "newhorizons:BrickHD", ""},
        {"", "newhorizons:BrickHD", ""}
    }
})





minetest.register_craft({
    type = "shaped",
    output = "newhorizons:BrickPillar2 3",
    recipe = {
        {"", "newhorizons:BrickHD", ""},
        {"", "newhorizons:BrickHD", ""},
        {"", "newhorizons:BrickHD", ""}
    }
})






minetest.register_craft({
    type = "shaped",
    output = "newhorizons:BrickPillar1 5",
    recipe = {
        {"", "newhorizons:BrickHD", ""},
        {"", "newhorizons:BrickHD", ""},
        {"newhorizons:BrickHD", "newhorizons:BrickHD", "newhorizons:BrickHD"}
    }
})




minetest.register_craft({
    type = "shaped",
    output = "newhorizons:BrickSphere1 4",
    recipe = {
        {"", "newhorizons:BrickHD", ""},
        {"newhorizons:BrickHD", "newhorizons:BrickHD", "newhorizons:BrickHD"},
        {"", "newhorizons:BrickHD", ""}
    }
})




















































minetest.register_craft({
    type = "shaped",
    output = "newhorizons:MarblePillar3 5",
    recipe = {
        {"newhorizons:Marble", "newhorizons:Marble", "newhorizons:Marble"},
        {"", "newhorizons:Marble", ""},
        {"", "newhorizons:Marble", ""}
    }
})





minetest.register_craft({
    type = "shaped",
    output = "newhorizons:MarblePillar2 3",
    recipe = {
        {"", "newhorizons:Marble", ""},
        {"", "newhorizons:Marble", ""},
        {"", "newhorizons:Marble", ""}
    }
})






minetest.register_craft({
    type = "shaped",
    output = "newhorizons:MarblePillar1 5",
    recipe = {
        {"", "newhorizons:Marble", ""},
        {"", "newhorizons:Marble", ""},
        {"newhorizons:Marble", "newhorizons:Marble", "newhorizons:Marble"}
    }
})




minetest.register_craft({
    type = "shaped",
    output = "newhorizons:MarbleSphere1 4",
    recipe = {
        {"", "newhorizons:Marble", ""},
        {"newhorizons:Marble", "newhorizons:Marble", "newhorizons:Marble"},
        {"", "newhorizons:Marble", ""}
    }
})

























minetest.register_craft({
    type = "shaped",
    output = "newhorizons:StonePillar3 5",
    recipe = {
        {"newhorizons:StoneHD", "newhorizons:StoneHD", "newhorizons:StoneHD"},
        {"", "newhorizons:StoneHD", ""},
        {"", "newhorizons:StoneHD", ""}
    }
})





minetest.register_craft({
    type = "shaped",
    output = "newhorizons:StonePillar2 3",
    recipe = {
        {"", "newhorizons:StoneHD", ""},
        {"", "newhorizons:StoneHD", ""},
        {"", "newhorizons:StoneHD", ""}
    }
})






minetest.register_craft({
    type = "shaped",
    output = "newhorizons:StonePillar1 5",
    recipe = {
        {"", "newhorizons:StoneHD", ""},
        {"", "newhorizons:StoneHD", ""},
        {"newhorizons:StoneHD", "newhorizons:StoneHD", "newhorizons:StoneHD"}
    }
})




minetest.register_craft({
    type = "shaped",
    output = "newhorizons:StoneSphere1 4",
    recipe = {
        {"", "newhorizons:StoneHD", ""},
        {"newhorizons:StoneHD", "newhorizons:StoneHD", "newhorizons:StoneHD"},
        {"", "newhorizons:StoneHD", ""}
    }
})





























minetest.register_craft({
    type = "shaped",
    output = "newhorizons:BurntWoodPillar3 5",
    recipe = {
        {"newhorizons:BurntWoodHD", "newhorizons:BurntWoodHD", "newhorizons:BurntWoodHD"},
        {"", "newhorizons:BurntWoodHD", ""},
        {"", "newhorizons:BurntWoodHD", ""}
    }
})





minetest.register_craft({
    type = "shaped",
    output = "newhorizons:BurntWoodPillar2 3",
    recipe = {
        {"", "newhorizons:BurntWoodHD", ""},
        {"", "newhorizons:BurntWoodHD", ""},
        {"", "newhorizons:BurntWoodHD", ""}
    }
})






minetest.register_craft({
    type = "shaped",
    output = "newhorizons:BurntWoodPillar1 5",
    recipe = {
        {"", "newhorizons:BurntWoodHD", ""},
        {"", "newhorizons:BurntWoodHD", ""},
        {"newhorizons:BurntWoodHD", "newhorizons:BurntWoodHD", "newhorizons:BurntWoodHD"}
    }
})




minetest.register_craft({
    type = "shaped",
    output = "newhorizons:BurntWoodSphere1 4",
    recipe = {
        {"", "newhorizons:BurntWoodHD", ""},
        {"newhorizons:BurntWoodHD", "newhorizons:BurntWoodHD", "newhorizons:BurntWoodHD"},
        {"", "newhorizons:BurntWoodHD", ""}
    }
})


































minetest.register_craft({
    type = "shaped",
    output = "newhorizons:WhiteWoodPillar3 5",
    recipe = {
        {"newhorizons:WhiteWood", "newhorizons:WhiteWood", "newhorizons:WhiteWood"},
        {"", "newhorizons:WhiteWood", ""},
        {"", "newhorizons:WhiteWood", ""}
    }
})





minetest.register_craft({
    type = "shaped",
    output = "newhorizons:WhiteWoodPillar2 3",
    recipe = {
        {"", "newhorizons:WhiteWood", ""},
        {"", "newhorizons:WhiteWood", ""},
        {"", "newhorizons:WhiteWood", ""}
    }
})






minetest.register_craft({
    type = "shaped",
    output = "newhorizons:WhiteWoodPillar1 5",
    recipe = {
        {"", "newhorizons:WhiteWood", ""},
        {"", "newhorizons:WhiteWood", ""},
        {"newhorizons:WhiteWood", "newhorizons:WhiteWood", "newhorizons:WhiteWood"}
    }
})




minetest.register_craft({
    type = "shaped",
    output = "newhorizons:WhiteWoodSphere1 4",
    recipe = {
        {"", "newhorizons:WhiteWood", ""},
        {"newhorizons:WhiteWood", "newhorizons:WhiteWood", "newhorizons:WhiteWood"},
        {"", "newhorizons:WhiteWood", ""}
    }
})




























minetest.register_craft({
    type = "shapeless",
    output = "dye:white 4",
    recipe = {
        "newhorizons:WhiteDirt",
       
    },
})









