





minetest.register_on_newplayer(function(player)
	print("[minimal] giving initial stuff to player")
	player:get_inventory():add_item('main', 'quest_lib:quest_book')
	player:get_inventory():add_item('main', 'default:axe_wood')
        
       
        
end)


minetest.register_on_joinplayer(function(player)
	
        skybox.set(player, 3)
        minetest.chat_send_all(" ")
        minetest.chat_send_all(" ")
        minetest.chat_send_all(" ")
        minetest.chat_send_all(" ")
        minetest.chat_send_all(" ")
        minetest.chat_send_all(" ")
        
        
        
end)



minetest.clear_registered_biomes()
    
    

minetest.clear_registered_decorations()
  

minetest.clear_registered_schematics()






-- Alien Plains Biome

minetest.register_node("newplanet:GreenPlant1", {
    drawtype = "plantlike",
    description = "Alien Reeds",
    light_source = 6,
    -- Only one texture used
    tiles = {"GreenPlant1.png"},
    paramtype = "light",
    buildable_to = true,
    walkable     = false,

    groups = {snappy = 3},
    selection_box = {
        type = "fixed",
        fixed = {-6 / 16, -0.5, -6 / 16, 6 / 16, 0.5, 6 / 16},
        
    },
})


minetest.register_node("newplanet:GreenPlant2", {
    drawtype = "plantlike",
    description = "Alien Blue Flower",

    -- Only one texture used
    tiles = {"GreenPlant2.png"},
    paramtype = "light",
    buildable_to = true,
    walkable     = false,

    groups = {snappy = 3},
    selection_box = {
        type = "fixed",
        fixed = {-6 / 16, -0.5, -6 / 16, 6 / 16, 0.5, 6 / 16},
        
    },
})


minetest.register_node("newplanet:GreenPlant3", {
    drawtype = "plantlike",
    description = "Alien Red Flower",

    -- Only one texture used
    tiles = {"GreenPlant3.png"},
    paramtype = "light",
    buildable_to = true,
    walkable     = false,
    groups = {snappy = 3},
    selection_box = {
        type = "fixed",
        fixed = {-6 / 16, -0.5, -6 / 16, 6 / 16, 0.5, 6 / 16},
        
    },
})



minetest.register_node("newplanet:AlienGrass", {
    description = "Alien Grass",
    tiles = {"GreenGrass.png"},
    is_ground_content = true,
    groups = {crumbly=3}
})




minetest.register_node("newplanet:AlienStone1", {
    description = "Alien Stone",
    tiles = {"AlienStone1.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})



minetest.register_biome({
    name = "AlienPlains",
    node_top = "newplanet:AlienGrass",
    depth_top = 5,
    node_filler = "newplanet:AlienStone1",
    depth_filler = 10,
    y_max = 1000,
    y_min = -3,
    heat_point = 60,
    humidity_point = 60,
})





minetest.register_decoration({
    deco_type = "simple",
    place_on = {"newplanet:AlienGrass"},
    sidelen = 16,
    fill_ratio = 0.02,
    biomes = {"AlienPlains"},
    y_max = 200,
    y_min = 1,
    decoration = "newplanet:GreenPlant1",
})


minetest.register_decoration({
    deco_type = "simple",
    place_on = {"newplanet:AlienGrass"},
    sidelen = 16,
    fill_ratio = 0.02,
    biomes = {"AlienPlains"},
    y_max = 200,
    y_min = 1,
    decoration = "newplanet:GreenPlant2",
})


minetest.register_decoration({
    deco_type = "simple",
    place_on = {"newplanet:AlienGrass"},
    sidelen = 16,
    fill_ratio = 0.02,
    biomes = {"AlienPlains"},
    y_max = 200,
    y_min = 1,
    decoration = "newplanet:GreenPlant3",
})


minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"newplanet:AlienGrass"},
    sidelen = 16,
    fill_ratio = 0.0001,
    biomes = {"AlienPlains"},
    y_max = 200,
    y_min = 1,
    schematic = minetest.get_modpath("newplanet") .. "/SchemsC/Boulder.mts",
    flags = "place_center_x, place_center_z",
    rotation = "random",
})


minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"newplanet:AlienGrass"},
    sidelen = 16,
    fill_ratio = 0.00005,
    biomes = {"AlienPlains"},
    y_max = 200,
    y_min = 1,
    schematic = minetest.get_modpath("newplanet") .. "/SchemsC/Tree.mts",
    flags = "place_center_x, place_center_z",
    rotation = "random",
})







-- Alien Swamp Biome








minetest.register_node("newplanet:PurplePlant1", {
    drawtype = "plantlike",
    description = "Alien Swamp Grass",
    light_source = 8,
    -- Only one texture used
    tiles = {"PurpleGrassPlant.png"},
    paramtype = "light",
    buildable_to = true,
    walkable     = false,

    groups = {snappy = 3},
    selection_box = {
        type = "fixed",
        fixed = {-6 / 16, -0.5, -6 / 16, 6 / 16, 0.5, 6 / 16},
        
    },
})




minetest.register_node("newplanet:PurpleGrass", {
    description = "Purple Grass",
    tiles = {"PurpleGrass.png"},
    
    is_ground_content = true,
    groups = {crumbly=3}
})




minetest.register_node("newplanet:PurpleStone", {
    description = "Alien Stone",
    tiles = {"PurpleStone.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})


minetest.register_node("newplanet:PurpleLeaves", {
    description = "Purple Leaves",
    drawtype = "glasslike",
    tiles = {"PurpleLeaves.png"},
    paramtype = "light",
    is_ground_content = false,
    sunlight_propagates = true,
    
    groups = {snappy=3,oddly_breakable_by_hand=3, leaves=1},
})




minetest.register_biome({
    name = "AlienSwamp",
    node_top = "newplanet:PurpleGrass",
    depth_top = 3,
    node_filler = "newplanet:PurpleStone",
    depth_filler = 15,
    y_max = 1000,
    y_min = -3,
    heat_point = 40,
    humidity_point = 60,
})




minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"newplanet:PurpleGrass"},
    sidelen = 16,
    fill_ratio = 0.005,
    biomes = {"AlienSwamp"},
    y_max = 200,
    y_min = 1,
    schematic = minetest.get_modpath("newplanet") .. "/SchemsC/PurpleTree.mts",
    flags = "place_center_x, place_center_z",
    rotation = "random",
})



minetest.register_decoration({
    deco_type = "simple",
    place_on = {"newplanet:PurpleGrass"},
    sidelen = 16,
    fill_ratio = 0.05,
    biomes = {"AlienSwamp"},
    y_max = 200,
    y_min = 1,
    decoration = "newplanet:PurplePlant1",
})


-- Fire Biome





minetest.register_node("newplanet:FireFlower", {
    description = "FireFlower",
    drawtype = "plantlike",
    wield_image = "FireFlowerInv.png",
    inventory_image = "FireFlowerInv.png",
    tiles = {
		{name="FireFlower.png", animation={type="vertical_frames",
		aspect_w=16, aspect_h=16, length=1}},
	},
    paramtype = "light",
    light_source = 13,
    buildable_to = true,
        walkable     = false,
        damage_per_second = 2,
    sunlight_propagates = true, -- Sunlight can shine through block
    groups = {snappy = 3, oddly_breakable_by_hand = 3},
    sounds = default.node_sound_leaves_defaults()
    
})


minetest.register_node("newplanet:FireGrass", {
    drawtype = "plantlike",
    description = "FireGrass",

    -- Only one texture used
    tiles = {"FireGrass.png"},
    paramtype = "light",
    buildable_to = true,
    walkable     = false,

    groups = {snappy = 3},
    selection_box = {
        type = "fixed",
        fixed = {-6 / 16, -0.5, -6 / 16, 6 / 16, 0.5, 6 / 16},
        
    },
})

minetest.register_node("newplanet:FireLeaves", {
    description = "Fire Leaves",
    drawtype = "glasslike",
    tiles = {"FireLeaves.png"},
    paramtype = "light",
    is_ground_content = false,
    sunlight_propagates = true,
    
    groups = {snappy=3,oddly_breakable_by_hand=3, leaves=1},
})


minetest.register_node("newplanet:FireWood", {
    description = "Fire Wood",
    tiles = {"FireWood.png"},
    paramtype2 = "facedir",
    is_ground_content = true,
    
    groups = {choppy=3, tree=1}
})

minetest.register_node("newplanet:FireDirt", {
    description = "Fire Dirt",
    tiles = {"FireDirt.png"},
    is_ground_content = true,
    groups = {crumbly=3, dirt=1}
})


minetest.register_node("newplanet:FireStone", {
    description = "Fire Stone",
    tiles = {"FireStone.png"},
    is_ground_content = true,
    groups = {cracky=3, stone=1}
})

minetest.register_biome({
    name = "FireFields",
    node_top = "newplanet:FireDirt",
    depth_top = 2,
    node_filler = "newplanet:FireStone",
    depth_filler = 4,
    y_max = 1000,
    y_min = -3,
    heat_point = 100,
    humidity_point = 45,
})

minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"newplanet:FireDirt"},
    sidelen = 16,
    fill_ratio = 0.001,
    biomes = {"FireField"},
    y_max = 200,
    y_min = 1,
    schematic = minetest.get_modpath("newplanet") .. "/SchemsC/FirePine.mts",
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

minetest.register_decoration({
    deco_type = "simple",
    place_on = {"newplanet:FireDirt"},
    sidelen = 16,
    fill_ratio = 0.05,
    biomes = {"FireField"},
    y_max = 200,
    y_min = 1,
    decoration = "newplanet:FireFlower",
})

minetest.register_decoration({
    deco_type = "simple",
    place_on = {"newplanet:FireDirt"},
    sidelen = 16,
    fill_ratio = 0.05,
    biomes = {"FireField"},
    y_max = 200,
    y_min = 1,
    decoration = "newplanet:FireGrass",
})



-- Dye Crafting Recipies

minetest.register_craft({
    type = "shapeless",
    output = "dye:red 4",
    recipe = {
        "newplanet:FireDirt",
        
    },
})

minetest.register_craft({
    type = "shapeless",
    output = "dye:yellow 4",
    recipe = {
        "newplanet:FireFlower",
        
    },
})


  -- Badlands Biome

minetest.register_biome({
    name = "Strange Sea",
    node_top = "newhorizons:StableWaterBlue",
    depth_top = 2,
    node_filler = "newhorizons:StableWaterBlue",
    depth_filler = 4,
    y_max = 1000,
    y_min = -3,
    heat_point = 1,
    humidity_point = 99,
})



minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"air"},
    sidelen = 16,
    fill_ratio = 0.9,
    biomes = {"Strange Sea"},
    y_max = 200,
    y_min = 1,
    schematic = minetest.get_modpath("newplanet") .. "/SchemsC/Island.mts",
    flags = "place_center_x, place_center_z",
    rotation = "random",
})


minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"air"},
    sidelen = 16,
    fill_ratio = 0.9,
    biomes = {"Strange Sea"},
    y_max = 200,
    y_min = 1,
    schematic = minetest.get_modpath("newplanet") .. "/SchemsC/Island2.mts",
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

