-- Biomes
-- Icesheet
cartographer.biomes.add {
    name = "icesheet",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_snow",
    }
}
cartographer.biomes.add {
    name = "icesheet_ocean",
    textures = {
        "ctg_mtg_simple_water",
        "ctg_mtg_colored_water",
    },
    max_height = 0,
}
cartographer.biomes.add {
    name = "icesheet_ocean",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_snow",
    },
    min_height = 1,
}

-- Tundra
cartographer.biomes.add {
    name = "tundra",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_snow",
        "ctg_mtg_colored_snow",
        "ctg_mtg_tundra",
    }
}
cartographer.biomes.add {
    name = "tundra_highland",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_snow",
        "ctg_mtg_colored_snow",
        "ctg_mtg_tundra",
    }
}
cartographer.biomes.add {
    name = "tundra_beach",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_sand",
        "ctg_mtg_tundra",
    }
}
cartographer.biomes.add {
    name = "tundra_ocean",
    textures = {
        "ctg_mtg_simple_water",
        "ctg_mtg_colored_water",
    }
}

-- Taiga
cartographer.biomes.add {
    name = "taiga",
    textures = {
        "ctg_mtg_simple_forest",
        "ctg_mtg_snowy_forest",
        "ctg_mtg_coniferous_snowy",
    }
}
cartographer.biomes.add {
    name = "taiga_ocean",
    textures = {
        "ctg_mtg_simple_water",
        "ctg_mtg_colored_water",
    },
    max_height = 0,
}
cartographer.biomes.add {
    name = "taiga_ocean",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_snow",
    },
    min_height = 1,
}

-- Snowy Grassland
cartographer.biomes.add {
    name = "snowy_grassland",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_snow",
    }
}
cartographer.biomes.add {
    name = "snowy_grassland_ocean",
    textures = {
        "ctg_mtg_simple_water",
        "ctg_mtg_colored_water",
    },
    max_height = 0,
}
cartographer.biomes.add {
    name = "snowy_grassland_ocean",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_snow",
    },
    min_height = 1,
}


-- Grassland
cartographer.biomes.add {
    name = "grassland",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_land",
    }
}
cartographer.biomes.add {
    name = "grassland_dunes",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_sand",
    }
}
cartographer.biomes.add {
    name = "grassland_ocean",
    textures = {
        "ctg_mtg_simple_water",
        "ctg_mtg_colored_water",
    },
    max_height = 0
}
cartographer.biomes.add {
    name = "grassland_ocean",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_sand",
    },
    min_height = 1
}

-- Coniferous Forest
cartographer.biomes.add {
    name = "coniferous_forest",
    textures = {
        "ctg_mtg_simple_forest",
        "ctg_mtg_colored_forest",
        "ctg_mtg_coniferous_forest",
    }
}
cartographer.biomes.add {
    name = "coniferous_forest_dunes",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_sand",
    }
}
cartographer.biomes.add {
    name = "coniferous_forest_ocean",
    textures = {
        "ctg_mtg_simple_water",
        "ctg_mtg_colored_water",
    },
    max_height = 0
}
cartographer.biomes.add {
    name = "coniferous_forest_ocean",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_sand",
    },
    min_height = 1
}

-- Deciduous Forest
cartographer.biomes.add {
    name = "deciduous_forest",
    textures = {
        "ctg_mtg_simple_forest",
        "ctg_mtg_colored_forest",
        "ctg_mtg_deciduous_forest",
    }
}
cartographer.biomes.add {
    name = "deciduous_forest_shore",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_sand",
    }
}
cartographer.biomes.add {
    name = "deciduous_forest_ocean",
    textures = {
        "ctg_mtg_simple_water",
        "ctg_mtg_colored_water",
    },
    max_height = 0
}
cartographer.biomes.add {
    name = "deciduous_forest_ocean",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_sand",
    },
    min_height = 1
}

-- Desert
cartographer.biomes.add {
    name = "desert",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_sand",
        "ctg_mtg_colored_sand",
        "ctg_mtg_desert_sand",
    }
}
cartographer.biomes.add {
    name = "desert_ocean",
    textures = {
        "ctg_mtg_simple_water",
        "ctg_mtg_colored_water",
    },
    max_height = 0
}
cartographer.biomes.add {
    name = "desert_ocean",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_sand",
    },
    min_height = 1
}

-- Sandstone Desert
cartographer.biomes.add {
    name = "sandstone_desert",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_sand",
    }
}
cartographer.biomes.add {
    name = "sandstone_desert_ocean",
    textures = {
        "ctg_mtg_simple_water",
        "ctg_mtg_colored_water",
    },
    max_height = 0
}
cartographer.biomes.add {
    name = "sandstone_desert_ocean",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_sand",
    },
    min_height = 1
}

-- Cold Desert
cartographer.biomes.add {
    name = "cold_desert",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_sand",
        "ctg_mtg_colored_sand",
        "ctg_mtg_silver_sand",
    }
}
cartographer.biomes.add {
    name = "cold_desert_ocean",
    textures = {
        "ctg_mtg_simple_water",
        "ctg_mtg_colored_water",
    },
    max_height = 0
}
cartographer.biomes.add {
    name = "cold_desert_ocean",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_sand",
    },
    min_height = 1
}

-- Savanna
cartographer.biomes.add {
    name = "savanna",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_land",
        "ctg_mtg_colored_land",
        "ctg_mtg_savanna",
    }
}
cartographer.biomes.add {
    name = "savanna_shore",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_sand",
    }
}
cartographer.biomes.add {
    name = "savanna_ocean",
    textures = {
        "ctg_mtg_simple_water",
        "ctg_mtg_colored_water",
    },
    max_height = 0
}
cartographer.biomes.add {
    name = "savanna_ocean",
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_sand",
    },
    min_height = 1
}

-- Rainforest
cartographer.biomes.add {
    name = "rainforest",
    textures = {
        "ctg_mtg_simple_forest",
        "ctg_mtg_colored_forest",
        "ctg_mtg_rainforest",
    }
}
cartographer.biomes.add {
    name = "rainforest_swamp",
    textures = {
        "ctg_mtg_simple_water",
        "ctg_mtg_colored_water",
        "ctg_mtg_swamp",
    }
}
cartographer.biomes.add {
    name = "rainforest_ocean",
    textures = {
        "ctg_mtg_simple_water",
        "ctg_mtg_colored_water",
    }
}

-- Fallback biomes
cartographer.biomes.add_fallback {
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_sand",
        "ctg_mtg_colored_sand",
        "ctg_mtg_desert_sand",
    },
    min_height = 1,
    min_heat = 75,
    max_humidity = 25,
}
cartographer.biomes.add_fallback {
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_land",
        "ctg_mtg_colored_land",
        "ctg_mtg_savanna",
    },
    min_height = 1,
    min_heat = 75,
}
cartographer.biomes.add_fallback {
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_snow",
    },
    min_height = 1,
    max_heat = 25,
}
cartographer.biomes.add_fallback {
    textures = {
        "ctg_mtg_simple_water",
        "ctg_mtg_colored_water",
    },
    max_height = 0,
}
cartographer.biomes.add_fallback {
    textures = {
        "ctg_mtg_simple_land",
        "ctg_mtg_colored_land",
    }
}

-- Markers
-- General markers
cartographer.markers.add("ctg_mtg:house", "House", {
    "ctg_mtg_marker_house",
    "ctg_mtg_marker_house_2",
});
cartographer.markers.add("ctg_mtg:skull", "Skull", {
    "ctg_mtg_marker_skull",
});
cartographer.markers.add("ctg_mtg:diamond", "diamond", {
    "ctg_mtg_marker_diamond",
    "ctg_mtg_marker_diamond_2",
});
cartographer.markers.add("ctg_mtg:mese", "mese", {
    "ctg_mtg_marker_mese",
    "ctg_mtg_marker_mese_2",
});
cartographer.markers.add("ctg_mtg:x", "X", {
    "ctg_mtg_marker_x",
    "ctg_mtg_marker_x_2",
});
cartographer.markers.add("ctg_mtg:flag", "Flag", {
    "ctg_mtg_marker_flag",
    "ctg_mtg_marker_flag_2",
});

-- Line drawing markers
cartographer.markers.add("ctg_mtg:line_h", "Line (Horizontal)", {
    "ctg_mtg_marker_line_h",
});
cartographer.markers.add("ctg_mtg:line_v", "Line (Vertical)", {
    "ctg_mtg_marker_line_v",
});
cartographer.markers.add("ctg_mtg:line_c_ne", "Line (North-East Corner)", {
    "ctg_mtg_marker_line_c_ne",
});
cartographer.markers.add("ctg_mtg:line_c_se", "Line (South-East Corner)", {
    "ctg_mtg_marker_line_c_se",
});
cartographer.markers.add("ctg_mtg:line_c_nw", "Line (North-West Corner)", {
    "ctg_mtg_marker_line_c_nw",
});
cartographer.markers.add("ctg_mtg:line_c_sw", "Line (South-West Corner)", {
    "ctg_mtg_marker_line_c_sw",
});
cartographer.markers.add("ctg_mtg:line_t_n", "Line (North T-Intersection)", {
    "ctg_mtg_marker_line_t_n",
});
cartographer.markers.add("ctg_mtg:line_t_s", "Line (South T-Intersection)", {
    "ctg_mtg_marker_line_t_s",
});
cartographer.markers.add("ctg_mtg:line_t_e", "Line (East T-Intersection)", {
    "ctg_mtg_marker_line_t_e",
});
cartographer.markers.add("ctg_mtg:line_t_w", "Line (West T-Intersection)", {
    "ctg_mtg_marker_line_t_w",
});
cartographer.markers.add("ctg_mtg:line_cross", "Line (Crossing)", {
    "ctg_mtg_marker_line_cross",
});

-- Arrow markers
cartographer.markers.add("ctg_mtg:arrow_n", "Arrow (North)", {
    "ctg_mtg_marker_arrow_n",
});
cartographer.markers.add("ctg_mtg:arrow_s", "Arrow (South)", {
    "ctg_mtg_marker_arrow_s",
});
cartographer.markers.add("ctg_mtg:arrow_e", "Arrow (East)", {
    "ctg_mtg_marker_arrow_e",
});
cartographer.markers.add("ctg_mtg:arrow_w", "Arrow (West)", {
    "ctg_mtg_marker_arrow_w",
});
cartographer.markers.add("ctg_mtg:arrow_ne", "Arrow (North-East)", {
    "ctg_mtg_marker_arrow_ne",
});
cartographer.markers.add("ctg_mtg:arrow_se", "Arrow (South-East)", {
    "ctg_mtg_marker_arrow_se",
});
cartographer.markers.add("ctg_mtg:arrow_nw", "Arrow (North-West)", {
    "ctg_mtg_marker_arrow_nw",
});
cartographer.markers.add("ctg_mtg:arrow_sw", "Arrow (South-West)", {
    "ctg_mtg_marker_arrow_sw",
});

-- Materials
cartographer.materials.register_by_name("default:paper", "paper");
cartographer.materials.register_by_name("default:coal_lump", "pigment");
cartographer.materials.register_by_name("default:coalblock", "pigment", 9);
cartographer.materials.register_by_name("dye:black", "pigment");

-- Crafting Recipes
minetest.register_craft({
	output = "cartographer:simple_table",
	recipe = {
		{"group:wood", "group:wood", "group:wood"},
		{"group:stick", "", "group:stick"},
		{"group:stick", "group:stick", "group:stick"},
	}
});
minetest.register_craft({
	output = "cartographer:standard_table",
	recipe = {
		{"default:steel_ingot", "default:steel_ingot", "default:steel_ingot"},
		{"default:steel_ingot", "cartographer:simple_table", "default:steel_ingot"},
		{"default:steel_ingot", "default:steel_ingot", "default:steel_ingot"},
	}
});
minetest.register_craft({
	output = "cartographer:advanced_table",
	recipe = {
		{"default:mese_crystal_fragment", "default:mese_crystal_fragment", "default:mese_crystal_fragment"},
		{"default:mese_crystal_fragment", "cartographer:standard_table", "default:mese_crystal_fragment"},
		{"default:mese_crystal_fragment", "default:mese_crystal_fragment", "default:mese_crystal_fragment"},
	}
});

-- Skin
for _,skin in pairs(cartographer.skin.table_skins) do
    skin.paper_texture = "default_paper";
    skin.pigment_texture = "dye_black";
end

cartographer.skin.table_skins.advanced_table.background.texture = "ctg_mtg_advanced_table_bg";

-- Overrides
minetest.override_item("cartographer:simple_table", {
    tiles = { "ctg_mtg_simple_table.png" };
});
minetest.override_item("cartographer:standard_table", {
    tiles = { "ctg_mtg_standard_table.png" };
});
minetest.override_item("cartographer:advanced_table", {
    tiles = { "ctg_mtg_advanced_table.png" };
	light_source = 5,
});
