-- Biomes
cartographer.biomes.add {
    name = "Marsh",
    textures = {
        "ctg_pix_simple_land",
        "ctg_pix_colored_land",
    }
}
cartographer.biomes.add {
    name = "Swamp",
    textures = {
        "ctg_pix_simple_land",
        "ctg_pix_colored_land",
        "ctg_pix_colored_land",
        "ctg_pix_swamp",
    }
}
cartographer.biomes.add {
    name = "Deep Forest",
    textures = {
        "ctg_pix_simple_forest",
        "ctg_pix_colored_forest",
        "ctg_pix_deep_forest",
    }
}
cartographer.biomes.add {
    name = "Forest",
    textures = {
        "ctg_pix_simple_forest",
        "ctg_pix_colored_forest",
        "ctg_pix_dense_forest",
    }
}
cartographer.biomes.add {
    name = "Grove",
    textures = {
        "ctg_pix_simple_forest",
        "ctg_pix_colored_forest",
        "ctg_pix_grove",
    }
}
cartographer.biomes.add {
    name = "Wilderness",
    textures = {
        "ctg_pix_simple_forest",
        "ctg_pix_colored_forest",
    }
}
cartographer.biomes.add {
    name = "Grassland",
    textures = {
        "ctg_pix_simple_land",
        "ctg_pix_colored_land",
    }
}
cartographer.biomes.add {
    name = "Orchard",
    textures = {
        "ctg_pix_simple_forest",
        "ctg_pix_colored_forest",
    }
}
cartographer.biomes.add {
    name = "Chaparral",
    textures = {
        "ctg_pix_simple_land",
        "ctg_pix_colored_land",
        "ctg_pix_colored_land",
        "ctg_pix_chaparral",
    }
}
cartographer.biomes.add {
    name = "Savanna",
    textures = {
        "ctg_pix_simple_land",
        "ctg_pix_colored_land",
        "ctg_pix_colored_land",
        "ctg_pix_savanna",
    }
}
cartographer.biomes.add {
    name = "Desert",
    textures = {
        "ctg_pix_simple_land",
        "ctg_pix_colored_sand",
        "ctg_pix_colored_sand",
    }
}
cartographer.biomes.add {
    name = "Wasteland",
    textures = {
        "ctg_pix_simple_land",
        "ctg_pix_colored_sand",
        "ctg_pix_colored_sand",
        "ctg_pix_wasteland",
    },
    min_height = 1
}
cartographer.biomes.add {
    name = "Wasteland",
    textures = {
        "ctg_pix_simple_water",
        "ctg_pix_colored_water",
    },
    max_height = 0
}
cartographer.biomes.add {
    name = "Grassland Ocean",
    textures = {
        "ctg_pix_simple_water",
        "ctg_pix_colored_water",
    },
    max_height = 0
}
cartographer.biomes.add {
    name = "Grassland Ocean",
    textures = {
        "ctg_pix_simple_land",
        "ctg_pix_colored_sand",
    },
    min_height = 1
}
cartographer.biomes.add {
    name = "Gravel Beach",
    textures = {
        "ctg_pix_simple_water",
        "ctg_pix_colored_water",
    },
    max_height = 0
}
cartographer.biomes.add {
    name = "Gravel Beach",
    textures = {
        "ctg_pix_simple_land",
        "ctg_pix_colored_sand",
        "ctg_pix_gravel",
    },
    min_height = 1
}
cartographer.biomes.add {
    name = "Savanna Ocean",
    textures = {
        "ctg_pix_simple_water",
        "ctg_pix_colored_water",
    },
    max_height = 0,
}
cartographer.biomes.add {
    name = "Savanna Ocean",
    textures = {
        "ctg_pix_simple_land",
        "ctg_pix_colored_sand",
    },
    min_height = 1,
}

-- Fallback biomes
cartographer.biomes.add_fallback {
    textures = {
        "ctg_pix_simple_water",
        "ctg_pix_colored_water",
    },
    max_height = 0,
}
cartographer.biomes.add_fallback {
    textures = {
        "ctg_pix_simple_land",
        "ctg_pix_colored_land",
    }
}

-- Markers
-- General markers
cartographer.markers.add("ctg_pix:house", "House", {
    "ctg_pix_marker_house",
    "ctg_pix_marker_house_2",
});
cartographer.markers.add("ctg_pix:skull", "Skull", {
    "ctg_pix_marker_skull",
});
cartographer.markers.add("ctg_pix:jewel", "Jewel", {
    "ctg_pix_marker_jewel",
    "ctg_pix_marker_jewel_2",
});
cartographer.markers.add("ctg_pix:x", "X", {
    "ctg_pix_marker_x",
    "ctg_pix_marker_x_2",
});
cartographer.markers.add("ctg_pix:flag", "Flag", {
    "ctg_pix_marker_flag",
    "ctg_pix_marker_flag_2",
});

-- Line drawing markers
cartographer.markers.add("ctg_pix:line_h", "Line (Horizontal)", {
    "ctg_pix_marker_line_h",
});
cartographer.markers.add("ctg_pix:line_v", "Line (Vertical)", {
    "ctg_pix_marker_line_v",
});
cartographer.markers.add("ctg_pix:line_c_ne", "Line (North-East Corner)", {
    "ctg_pix_marker_line_c_ne",
});
cartographer.markers.add("ctg_pix:line_c_se", "Line (South-East Corner)", {
    "ctg_pix_marker_line_c_se",
});
cartographer.markers.add("ctg_pix:line_c_nw", "Line (North-West Corner)", {
    "ctg_pix_marker_line_c_nw",
});
cartographer.markers.add("ctg_pix:line_c_sw", "Line (South-West Corner)", {
    "ctg_pix_marker_line_c_sw",
});
cartographer.markers.add("ctg_pix:line_t_n", "Line (North T-Intersection)", {
    "ctg_pix_marker_line_t_n",
});
cartographer.markers.add("ctg_pix:line_t_s", "Line (South T-Intersection)", {
    "ctg_pix_marker_line_t_s",
});
cartographer.markers.add("ctg_pix:line_t_e", "Line (East T-Intersection)", {
    "ctg_pix_marker_line_t_e",
});
cartographer.markers.add("ctg_pix:line_t_w", "Line (West T-Intersection)", {
    "ctg_pix_marker_line_t_w",
});
cartographer.markers.add("ctg_pix:line_cross", "Line (Crossing)", {
    "ctg_pix_marker_line_cross",
});

-- Arrow markers
cartographer.markers.add("ctg_pix:arrow_n", "Arrow (North)", {
    "ctg_pix_marker_arrow_n",
});
cartographer.markers.add("ctg_pix:arrow_s", "Arrow (South)", {
    "ctg_pix_marker_arrow_s",
});
cartographer.markers.add("ctg_pix:arrow_e", "Arrow (East)", {
    "ctg_pix_marker_arrow_e",
});
cartographer.markers.add("ctg_pix:arrow_w", "Arrow (West)", {
    "ctg_pix_marker_arrow_w",
});
cartographer.markers.add("ctg_pix:arrow_ne", "Arrow (North-East)", {
    "ctg_pix_marker_arrow_ne",
});
cartographer.markers.add("ctg_pix:arrow_se", "Arrow (South-East)", {
    "ctg_pix_marker_arrow_se",
});
cartographer.markers.add("ctg_pix:arrow_nw", "Arrow (North-West)", {
    "ctg_pix_marker_arrow_nw",
});
cartographer.markers.add("ctg_pix:arrow_sw", "Arrow (South-West)", {
    "ctg_pix_marker_arrow_sw",
});

-- Materials
cartographer.materials.register_by_name("rp_default:paper", "paper");
cartographer.materials.register_by_name("rp_default:lump_coal", "pigment");
cartographer.materials.register_by_name("rp_default:block_coal", "pigment", 9);

-- Crafting Recipes
crafting.register_craft({
    output = "cartographer:simple_table",
    items = {
        "rp_default:fiber 2",
        "rp_default:stick 8",
        "group:wood 6",
    },
});
crafting.register_craft({
    output = "cartographer:standard_table",
    items = {
        "cartographer:simple_table",
        "rp_default:ingot_steel 6",
    },
});
crafting.register_craft({
    output = "cartographer:advanced_table",
    items = {
        "cartographer:standard_table",
        "rp_default:ingot_carbon_steel 6",
    },
});

-- Skin
for _,skin in pairs(cartographer.skin.table_skins) do
    skin.paper_texture = "default_paper";
    skin.pigment_texture = "default_lump_coal";
end

cartographer.skin.table_skins.advanced_table.background.texture = "ctg_pix_advanced_table_bg";

-- Overrides
minetest.override_item("cartographer:map", {
    inventory_image = "ctg_pix_map.png";
    wield_image = "ctg_pix_map.png";
});
minetest.override_item("cartographer:standard_table", {
    tiles = { "ctg_pix_standard_table.png" };
});
minetest.override_item("cartographer:advanced_table", {
    tiles = { "ctg_pix_advanced_table.png" };
});
