-- Biomes
cartographer.biomes.add("Marsh", {
    "ctg_pix_simple_land",
    "ctg_pix_colored_land",
});
cartographer.biomes.add("Swamp", {
    "ctg_pix_simple_land",
    "ctg_pix_colored_land",
    "ctg_pix_colored_land",
    "ctg_pix_swamp",
});
cartographer.biomes.add("Deep Forest", {
    "ctg_pix_simple_forest",
    "ctg_pix_colored_forest",
    "ctg_pix_deep_forest",
});
cartographer.biomes.add("Forest", {
    "ctg_pix_simple_forest",
    "ctg_pix_colored_forest",
    "ctg_pix_dense_forest",
});
cartographer.biomes.add("Grove", {
    "ctg_pix_simple_forest",
    "ctg_pix_colored_forest",
    "ctg_pix_grove",
});
cartographer.biomes.add("Wilderness", {
    "ctg_pix_simple_forest",
    "ctg_pix_colored_forest",
});
cartographer.biomes.add("Grassland", {
    "ctg_pix_simple_land",
    "ctg_pix_colored_land",
});
cartographer.biomes.add("Orchard", {
    "ctg_pix_simple_forest",
    "ctg_pix_colored_forest",
});
cartographer.biomes.add("Chaparral", {
    "ctg_pix_simple_land",
    "ctg_pix_colored_land",
    "ctg_pix_colored_land",
    "ctg_pix_chaparral",
});
cartographer.biomes.add("Savanna", {
    "ctg_pix_simple_land",
    "ctg_pix_colored_land",
    "ctg_pix_colored_land",
    "ctg_pix_savanna",
});
cartographer.biomes.add("Desert", {
    "ctg_pix_simple_land",
    "ctg_pix_colored_sand",
    "ctg_pix_colored_sand",
});
cartographer.biomes.add("Wasteland", {
    "ctg_pix_simple_land",
    "ctg_pix_colored_sand",
    "ctg_pix_colored_sand",
    "ctg_pix_wasteland",
}, 1);
cartographer.biomes.add("Wasteland", {
    "ctg_pix_simple_water",
    "ctg_pix_colored_water",
}, nil, 0);
cartographer.biomes.add("Grassland Ocean", {
    "ctg_pix_simple_water",
    "ctg_pix_colored_water",
}, nil, 0);
cartographer.biomes.add("Grassland Ocean", {
    "ctg_pix_simple_land",
    "ctg_pix_colored_sand",
}, 1);
cartographer.biomes.add("Gravel Beach", {
    "ctg_pix_simple_water",
    "ctg_pix_colored_water",
}, nil, 0);
cartographer.biomes.add("Gravel Beach", {
    "ctg_pix_simple_land",
    "ctg_pix_colored_sand",
    "ctg_pix_gravel",
}, 1);
cartographer.biomes.add("Savanna Ocean", {
    "ctg_pix_simple_water",
    "ctg_pix_colored_water",
}, nil, 0);
cartographer.biomes.add("Savanna Ocean", {
    "ctg_pix_simple_land",
    "ctg_pix_colored_sand",
}, 1);

-- Markers
-- General markers
cartographer.markers.add("ctg_pix:house", "House", {
    "ctg_pix_marker_house",
    "ctg_pix_marker_house_2",
});
cartographer.markers.add("ctg_pix:skull", "Skull", {
    "ctg_pix_marker_skull",
});
cartographer.markers.add("ctg_pix:jewel", "Jewel", {
    "ctg_pix_marker_jewel",
    "ctg_pix_marker_jewel_2",
});
cartographer.markers.add("ctg_pix:x", "X", {
    "ctg_pix_marker_x",
    "ctg_pix_marker_x_2",
});
cartographer.markers.add("ctg_pix:flag", "Flag", {
    "ctg_pix_marker_flag",
    "ctg_pix_marker_flag_2",
});

-- Line drawing markers
cartographer.markers.add("ctg_pix:line_h", "Line (Horizontal)", {
    "ctg_pix_marker_line_h",
});
cartographer.markers.add("ctg_pix:line_v", "Line (Vertical)", {
    "ctg_pix_marker_line_v",
});
cartographer.markers.add("ctg_pix:line_c_ne", "Line (North-East Corner)", {
    "ctg_pix_marker_line_c_ne",
});
cartographer.markers.add("ctg_pix:line_c_se", "Line (South-East Corner)", {
    "ctg_pix_marker_line_c_se",
});
cartographer.markers.add("ctg_pix:line_c_nw", "Line (North-West Corner)", {
    "ctg_pix_marker_line_c_nw",
});
cartographer.markers.add("ctg_pix:line_c_sw", "Line (South-West Corner)", {
    "ctg_pix_marker_line_c_sw",
});
cartographer.markers.add("ctg_pix:line_t_n", "Line (North T-Intersection)", {
    "ctg_pix_marker_line_t_n",
});
cartographer.markers.add("ctg_pix:line_t_s", "Line (South T-Intersection)", {
    "ctg_pix_marker_line_t_s",
});
cartographer.markers.add("ctg_pix:line_t_e", "Line (East T-Intersection)", {
    "ctg_pix_marker_line_t_e",
});
cartographer.markers.add("ctg_pix:line_t_w", "Line (West T-Intersection)", {
    "ctg_pix_marker_line_t_w",
});
cartographer.markers.add("ctg_pix:line_cross", "Line (Crossing)", {
    "ctg_pix_marker_line_cross",
});

-- Arrow markers
cartographer.markers.add("ctg_pix:arrow_n", "Arrow (North)", {
    "ctg_pix_marker_arrow_n",
});
cartographer.markers.add("ctg_pix:arrow_s", "Arrow (South)", {
    "ctg_pix_marker_arrow_s",
});
cartographer.markers.add("ctg_pix:arrow_e", "Arrow (East)", {
    "ctg_pix_marker_arrow_e",
});
cartographer.markers.add("ctg_pix:arrow_w", "Arrow (West)", {
    "ctg_pix_marker_arrow_w",
});
cartographer.markers.add("ctg_pix:arrow_ne", "Arrow (North-East)", {
    "ctg_pix_marker_arrow_ne",
});
cartographer.markers.add("ctg_pix:arrow_se", "Arrow (South-East)", {
    "ctg_pix_marker_arrow_se",
});
cartographer.markers.add("ctg_pix:arrow_nw", "Arrow (North-West)", {
    "ctg_pix_marker_arrow_nw",
});
cartographer.markers.add("ctg_pix:arrow_sw", "Arrow (South-West)", {
    "ctg_pix_marker_arrow_sw",
});

-- Materials
cartographer.materials.register_by_name("default:paper", "paper");
cartographer.materials.register_by_name("default:lump_coal", "pigment");
cartographer.materials.register_by_name("default:block_coal", "pigment", 9);

-- Crafting Recipes
crafting.register_craft({
    output = "cartographer:simple_table",
    items = {
        "default:fiber 2",
        "default:stick 8",
        "group:wood 6",
    },
});
crafting.register_craft({
    output = "cartographer:standard_table",
    items = {
        "cartographer:simple_table",
        "default:ingot_steel 6",
    },
});
crafting.register_craft({
    output = "cartographer:advanced_table",
    items = {
        "cartographer:advanced_table",
        "default:ingot_carbon_steel 6",
    },
});

-- Skin
for _,skin in pairs(cartographer.skin.table_skins) do
    skin.paper_texture = "default_paper";
    skin.pigment_texture = "default_lump_coal";
end

cartographer.skin.table_skins.advanced_table.background.texture = "ctg_pix_advanced_table_bg";

-- Overrides
minetest.override_item("cartographer:map", {
    inventory_image = "ctg_pix_map.png";
    wield_image = "ctg_pix_map.png";
});
minetest.override_item("cartographer:standard_table", {
    tiles = { "ctg_pix_standard_table.png" };
});
minetest.override_item("cartographer:advanced_table", {
    tiles = { "ctg_pix_advanced_table.png" };
});
