-- fly_b_gone: Remove butterflies and fireflies from minetest_game

-- Disables a butterfly or firefly node by making it invisible and hiding it
-- from the creative inventory
local function disable_node(name, display_name, texture)
    minetest.override_item(name, {
        description = "Memories of a "..display_name,
        inventory_image = "fly_b_gone_"..texture..".png",
        wield_image = "fly_b_gone_"..texture..".png",
        drawtype = "airlike",
        sunlight_propagates = true,
        walkable = false,
        pointable = false,
        diggable = false,
        light_source = 0,
        drop = "",
        groups = { not_in_creative_inventory = 1 },
        floodable = true,
    });
end

if minetest.settings:get_bool("hide_butterflies") then
    disable_node("butterflies:butterfly_red", "Butterfly", "butterfly")
    disable_node("butterflies:butterfly_violet", "Butterfly", "butterfly")
    disable_node("butterflies:butterfly_white", "Butterfly", "butterfly")
end

if minetest.settings:get_bool("hide_fireflies", "Firefly") then
    disable_node("fireflies:firefly", "Firefly", "firefly");

    -- These nodes need to be 'cycled' to trigger a lighting update
    local to_cycle = { "fireflies:firefly" };

    if minetest.settings:get_bool("keep_bottled_fireflies") == false then
        -- Make firefly_bottle look and behave like a regular glass bottle
        minetest.override_item("fireflies:firefly_bottle", {
            description = "Suspiciously Insect-Free Bottle",
            inventory_image = "fly_b_gone_bottle.png",
            wield_image = "vessels_glass_bottle.png",
            tiles = { "vessels_glass_bottle.png" },
            light_source = 0,
            groups = { dig_immediate = 3, attached_node = 1, not_in_creative_inventory = 1 },
            on_rightclick = nil,
        });

        -- Add firefly_bottle to the list of light nodes to cycle
        to_cycle[#to_cycle + 1] = "fireflies:firefly_bottle";

        -- Fallback for re-using bottles, allow crafting firefly_bottle into glass_bottle
        minetest.register_craft({
            output = "vessels:glass_bottle",
            type = "shapeless",
            recipe = { "fireflies:firefly_bottle" },
        });
    end

    -- Register an LBM that triggers a node update on light-creating firefly
    -- nodes. This will force the lighting to refresh.
    minetest.register_lbm({
        label = "Refresh firefly lights",
        name = "fly_b_gone:cycle_fireflies",
        nodenames = to_cycle,
        run_at_every_load = false,
        action = function(pos, node)
            minetest.set_node(pos, { name = node.name });
        end
    })
end
