-- Reverse all MTG axe recipes
local function register_axe_craft(name, material)
    minetest.register_craft({
        output = "default:axe_" .. name,
		recipe = {
			{material, material},
			{"group:stick", material},
			{"group:stick", ""}
		}
    });
end

register_axe_craft("wood", "group:wood");
register_axe_craft("stone", "default:stone");
register_axe_craft("bronze", "default:bronze_ingot");
register_axe_craft("steel", "default:steel_ingot");
register_axe_craft("mese", "default:mese");
register_axe_craft("diamod", "default:diamod");

-- Extend farming.register_hoe with a reversed recipe
local function register_hoe_craft(name, material)
    minetest.register_craft({
        output = name:sub(2),
        recipe = {
            {material, material},
            {"group:stick", ""},
            {"group:stick", ""}
        }
    })
end

local register_hoe = farming.register_hoe;
farming.register_hoe = function(name, def)
    register_hoe(name, def);

	if not def.recipe and def.material then
        register_hoe_craft(name, def.material);
	end
end

-- Reverse all MTG hoe recipes
register_hoe_craft(":farming:hoe_wood", "group:wood");
register_hoe_craft(":farming:hoe_stone", "group:stone");
register_hoe_craft(":farming:hoe_steel", "default:steel_ingot");


-- Extend stairs.register_stair with a reversed recipe
local function register_stair_craft(subname, recipeitem)
    minetest.register_craft({
        output = "stairs:stair_" .. subname .. " 8",
        recipe = {
            {recipeitem, "", ""},
            {recipeitem, recipeitem, ""},
            {recipeitem, recipeitem, recipeitem},
        },
    })
end

local register_stair = stairs.register_stair;
stairs.register_stair = function(subname, recipeitem, groups, images, description, sounds, worldaligntex)
    register_stair(subname, recipeitem, groups, images, description, sounds, worldaligntex);
    if recipeitem then
        register_stair_craft(subname, recipeitem);
    end
end

-- Reverse all MTG stair recipes
register_stair_craft("wood", "default:wood");
register_stair_craft("junglewood", "default:junglewood");
register_stair_craft("pine_wood", "default:pine_wood");
register_stair_craft("acacia_wood", "default:acacia_wood");
register_stair_craft("aspen_wood", "default:aspen_wood");
register_stair_craft("stone", "default:stone");
register_stair_craft("cobble", "default:cobble");
register_stair_craft("mossycobble", "default:mossycobble");
register_stair_craft("stonebrick", "default:stonebrick");
register_stair_craft("stone_block", "default:stone_block");
register_stair_craft("desert_stone", "default:desert_stone");
register_stair_craft("desert_cobble", "default:desert_cobble");
register_stair_craft("desert_stonebrick", "default:desert_stonebrick");
register_stair_craft("desert_stone_block", "default:desert_stone_block");
register_stair_craft("sandstone", "default:sandstone");
register_stair_craft("sandstonebrick", "default:sandstonebrick");
register_stair_craft("sandstone_block", "default:sandstone_block");
register_stair_craft("desert_sandstone", "default:desert_sandstone");
register_stair_craft("desert_sandstone_brick", "default:desert_sandstone_brick");
register_stair_craft("desert_sandstone_block", "default:desert_sandstone_block");
register_stair_craft("silver_sandstone", "default:silver_sandstone");
register_stair_craft("silver_sandstone_brick", "default:silver_sandstone_brick");
register_stair_craft("silver_sandstone_block", "default:silver_sandstone_block");
register_stair_craft("obsidian", "default:obsidian");
register_stair_craft("obsidianbrick", "default:obsidianbrick");
register_stair_craft("obsidian_block", "default:obsidian_block");
register_stair_craft("brick", "default:brick");
register_stair_craft("steelblock", "default:steelblock");
register_stair_craft("tinblock", "default:tinblock");
register_stair_craft("copperblock", "default:copperblock");
register_stair_craft("bronzeblock", "default:bronzeblock");
register_stair_craft("goldblock", "default:goldblock");
register_stair_craft("ice", "default:ice");
register_stair_craft("snowblock", "default:snowblock");
register_stair_craft("glass", "default:glass");
register_stair_craft("obsidian_glass", "default:obsidian_glass");
register_stair_craft("straw", "farming:straw");

-- Reverse the fancy bed recipe
minetest.register_craft({
    output = "beds:fancy_bed",
    recipe = {
		{"group:stick", "", ""},
		{"wool:white", "wool:white", "wool:white"},
		{"group:wood", "group:wood", "group:wood"},
    }
});
