minetest.register_node("nettle:nettle", {
	description = "Nettle",
	drawtype = "plantlike",
	waving = 1,
	visual_scale = 1.4,
	tiles = {"nettle_nettle.png"},
	inventory_image = "nettle_nettle.png",
	wield_image = "nettle_nettle.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	damage_per_second = 1,
	groups = {snappy = 2, flora = 1, attached_node = 1, flammable = 1},
	sounds = default.node_sound_leaves_defaults(),
	selection_box = {
		type = "fixed",
		fixed = {-6 / 16, -0.5, -6 / 16, 6 / 16, 0.5, 6 / 16},
	},
})

minetest.register_node("nettle:impatiens", {
	description = "Impatiens",
	drawtype = "plantlike",
	waving = 1,
	visual_scale = 1.4,
	tiles = {"nettle_impatiens.png"},
	inventory_image = "nettle_impatiens.png",
	wield_image = "nettle_impatiens.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	groups = {snappy = 2, flora = 1, attached_node = 1, flammable = 1},
	sounds = default.node_sound_leaves_defaults(),
})

minetest.register_node("nettle:cleavers", {
	description = "Cleavers",
	drawtype = "plantlike",
	waving = 1,
	visual_scale = 1.2,
	tiles = {"nettle_cleavers.png"},
	inventory_image = "nettle_cleavers.png",
	wield_image = "nettle_cleavers.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	liquidtype = "source",
	liquid_alternative_flowing = "nettle:cleavers",
	liquid_alternative_source = "nettle:cleavers",
	liquid_renewable = false,
	liquid_range = 0,
	liquid_viscosity = 3,
	groups = {snappy = 2, flora = 1, attached_node = 1, flammable = 1},
	sounds = default.node_sound_leaves_defaults(),
})

minetest.register_node("nettle:carduus", {
	description = "Carduus",
	drawtype = "plantlike",
	waving = 1,
	visual_scale = 1.2,
	tiles = {"nettle_carduus.png"},
	inventory_image = "nettle_carduus.png",
	wield_image = "nettle_carduus.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	damage_per_second = 1,
	groups = {snappy = 2, flora = 1, attached_node = 1, flammable = 1},
	sounds = default.node_sound_leaves_defaults(),
})

minetest.register_node("nettle:scotch_broom", {
	description = "Scotch Broom",
	drawtype = "mesh",
	mesh = "nettle_scotch_broom.obj",
	waving = 1,
	tiles = {"nettle_scotch_broom.png"},
	inventory_image = "nettle_scotch_broom.png",
	wield_image = "nettle_scotch_broom.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = true,
	groups = {choppy = 2, oddly_breakable_by_hand = 1, flora = 1, flammable = 1},
	sounds = default.node_sound_leaves_defaults(),
})

minetest.register_node("nettle:giant_hogweed", {
	description = "Giant Hogweed",
	drawtype = "plantlike",
	waving = 1,
	visual_scale = 2,
	tiles = {"nettle_giant_hogweed.png"},
	inventory_image = "nettle_giant_hogweed.png",
	wield_image = "nettle_giant_hogweed.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	damage_per_second = 2,
	on_punch = function(pos, node, player, pointed_thing)
		player:set_hp(player:get_hp() - 1)
	end,
	groups = {snappy = 2, flora = 1, attached_node = 1, flammable = 1},
	sounds = default.node_sound_leaves_defaults(),
})

minetest.register_abm({
	nodenames = {"group:spreading_dirt_type", "default:dirt", "group:ethereal_grass"},
	neighbors = {"default:dirt"},
	interval = 8,
	chance = 50,
	action = function(pos, node)
		local above = {x=pos.x, y=pos.y+1, z=pos.z}
		if minetest.get_node(above).name ~= "air" then
			return
		end
		local dirts = 0
		local airs = 0
		for x_ = pos.x-1, pos.x+1 do
			for y_ = pos.y-1, pos.y+1 do
				for z_ = pos.z-1, pos.z+1 do
					local nn = minetest.get_node({x=x_, y=y_, z=z_}).name
					if (nn == "default:dirt") or nn == ("default:stone") then
						dirts = dirts+1;
					end
					if (nn == "air") or (minetest.get_item_group(nn, "flora") > 0) then
						airs = airs+1;
					end
				end
			end
		end
		if (dirts < 14) and (airs < 14) then
			return
		end
		if (minetest.get_node({x=pos.x, y=pos.y+2, z=pos.z}).name ~= "air") or (minetest.get_node_light(above, 0.5) < 8) then
			minetest.set_node(above, {name = "nettle:impatiens"})
		elseif minetest.get_node_light(above, 0.5) < 13 then
			minetest.set_node(above, {name = "nettle:cleavers"})
		else
			minetest.set_node(above, {name = "nettle:nettle"})
		end
	end
})

local function count_nodes(pos, name)
	local result = 0
	for x_ = pos.x-1, pos.x+1 do
		for y_ = pos.y-1, pos.y+1 do
			for z_ = pos.z-1, pos.z+1 do
				if minetest.get_node({x=x_, y=y_, z=z_}).name == name then
					result = result+1;
				end
			end
		end
	end
	return result
end

minetest.register_abm({
	nodenames = {"nettle:nettle"},
	neighbors = {"nettle:nettle"},
	interval = 40,
	chance = 10,
	action = function(pos, node)
		if count_nodes(pos, "nettle:nettle") >= 4 then
			minetest.set_node(pos, {name = "nettle:carduus"})
		end
	end
})

minetest.register_abm({
	nodenames = {"nettle:carduus"},
	neighbors = {"nettle:carduus"},
	interval = 40,
	chance = 10,
	action = function(pos, node)
		if count_nodes(pos, "nettle:carduus") >= 2 then
			minetest.set_node(pos, {name = "nettle:scotch_broom"})
		end
	end
})

minetest.register_abm({
	nodenames = {"nettle:cleavers"},
	neighbors = {"nettle:cleavers"},
	interval = 40,
	chance = 10,
	action = function(pos, node)
		if count_nodes(pos, "nettle:cleavers") >= 4 then
			minetest.set_node(pos, {name = "nettle:giant_hogweed"})
		end
	end
})

minetest.register_abm({
	nodenames = {"nettle:nettle"},
	neighbors = {"nettle:impatiens"},
	interval = 40,
	chance = 10,
	action = function(pos, node)
		minetest.set_node(pos, {name = "nettle:impatiens"})
	end
})

minetest.register_abm({
	nodenames = {"nettle:impatiens"},
	neighbors = {"nettle:cleavers"},
	interval = 40,
	chance = 10,
	action = function(pos, node)
		minetest.set_node(pos, {name = "nettle:cleavers"})
	end
})

minetest.register_abm({
	nodenames = {"nettle:cleavers"},
	neighbors = {"nettle:nettle"},
	interval = 40,
	chance = 10,
	action = function(pos, node)
		minetest.set_node(pos, {name = "nettle:nettle"})
	end
})

minetest.register_abm({
	nodenames = {"nettle:impatiens"},
	neighbors = {"nettle:carduus"},
	interval = 40,
	chance = 10,
	action = function(pos, node)
		minetest.set_node(pos, {name = "nettle:nettle"})
	end
})

minetest.register_abm({
	nodenames = {"nettle:nettle"},
	neighbors = {"nettle:scotch_broom"},
	interval = 40,
	chance = 10,
	action = function(pos, node)
		minetest.set_node(pos, {name = "nettle:cleavers"})
	end
})

minetest.register_abm({
	nodenames = {"nettle:cleavers"},
	neighbors = {"nettle:giant_hogweed"},
	interval = 40,
	chance = 10,
	action = function(pos, node)
		minetest.set_node(pos, {name = "nettle:impatiens"})
	end
})

minetest.register_abm({
	nodenames = {"nettle:scotch_broom"},
	interval = 40,
	chance = 10,
	action = function(pos, node)
		local above = {x=pos.x, y=pos.y+1, z=pos.z}
		if minetest.get_node(above).name ~= "air" then
			return
		end
		for x_ = pos.x-1, pos.x+1 do
			for z_ = pos.z-1, pos.z+1 do
				if minetest.get_node({x=x_, y=pos.y, z=z_}).name == "air" then
					return;
				end
			end
		end
		minetest.set_node(above, {name = "nettle:scotch_broom"})
	end
})

minetest.register_craft({
	type = "fuel",
	recipe = "nettle:nettle",
	burntime = 3,
})

minetest.register_craft({
	type = "fuel",
	recipe = "nettle:impatiens",
	burntime = 3,
})

minetest.register_craft({
	type = "fuel",
	recipe = "nettle:cleavers",
	burntime = 3,
})

minetest.register_craft({
	type = "fuel",
	recipe = "nettle:carduus",
	burntime = 3,
})

minetest.register_craft({
	type = "fuel",
	recipe = "nettle:scotch_broom",
	burntime = 6,
})

minetest.register_craft({
	type = "fuel",
	recipe = "nettle:giant_hogweed",
	burntime = 3,
})

