local nc = nodecore

local modname = core.get_current_modname()
local registered_rake_patterns = {}
local register_rake_pattern = function(pattern)
	pattern.name = "_raked" .. pattern.name
	if pattern.group then
		pattern.name = pattern.name .. pattern.group
		pattern.sidetexture = modname .. "_raking_side" .. pattern.group .. ".png"
		pattern.texture = modname .. "_raking_" .. pattern.texture .. pattern.group .. ".png"
	else
		pattern.sidetexture = "nc_writing_raking_side.png"
		pattern.texture = "nc_writing_raking_" .. pattern.texture .. ".png"
	end
	registered_rake_patterns[#registered_rake_patterns + 1] = pattern
end
register_rake_pattern({name = "_side",  texture = "side"})
register_rake_pattern({name = "",       texture = "linear", group = "_zen"})
register_rake_pattern({name = "_nexus", texture = "nexus",  group = "_zen"})
register_rake_pattern({name = "_side",  texture = "side",   group = "_zen"})

local register_raked = function(basename, desc, opacity, recipematch, recipeidx)
	local name = string.gsub(string.lower(desc), "%W", "_")
	local basedef = core.registered_items[basename] or {}
	local commondef = {
		description = "Raked " .. desc,
		paramtype2 = "facedir",
		falling_replacement = basename,
		silktouch_as = basename,
		groups = {
			raked = 1,
			[name .. "_raked"] = 1,
			falling_node = 1,
			soil = basedef.groups and basedef.groups.soil and (basedef.groups.soil + 2) or nil
		},
		on_door_conveyed = function(pos)
			return core.set_node(pos, {name = basename})
		end,
		on_falling_node_crush = function(pos)
			return core.set_node(pos, {name = basename})
		end
	}
	for _, pattern in ipairs(registered_rake_patterns) do
		core.register_node(modname .. ":" .. name .. pattern.name,
			nc.underride({
				tiles = {
					basedef.tiles[1] .. "^(" .. pattern.texture .. "^[opacity:" .. opacity .. ")",
					basedef.tiles[1] .. "^nc_api_loose.png",
					basedef.tiles[1] .. "^(" .. pattern.sidetexture .. "^[opacity:" .. opacity .. ")"
				},
				on_place = function(itemstack, placer, pointed_thing)
					return core.rotate_and_place(itemstack, placer, pointed_thing, false, {force_floor = true})
				end
			}, commondef, basedef)
		)
	end
end

-- Register new raked nodes
register_raked("nc_terrain:sand",   "Sand",    96, {groups = {sand = true,   falling_repose = false}}, {"group:sand"})
register_raked("nc_terrain:gravel", "Gravel", 160, {groups = {gravel = true, falling_repose = false}}, {"group:gravel"})
register_raked("nc_terrain:dirt",   "Dirt",   108, {groups = {dirt = true,   falling_repose = false}}, {"group:dirt"})
register_raked("nc_tree:humus",     "Humus",  116, {groups = {humus = true,  falling_repose = false}}, {"group:humus"})

-- Modify the existing recipes
local pi = math.pi
for _, recipe in ipairs(nc.registered_recipes) do
	local _, _, rakeable = string.find(recipe.label, "^rake (.*)")
	if rakeable then
		local diagonalname = "nc_writing:" .. rakeable .. "_raked"
		local nexusname = diagonalname .. "_nexus"
		local straightname = modname .. ":" .. rakeable .. "_raked_side"
		recipe.after = function(pos, data)
			local newnode = {
				name = nexusname,
				param2 = 0
			}
			if data.crafter and data.crafter.getpos and data.crafter.get_look_horizontal then
				local ppos = data.crafter:get_pos()
				ppos.y = pos.y
				-- If the player is not standing on the node being raked then...
				if vector.distance(pos, ppos) >= 0.4 then
					-- A full turn is 2*pi radians.
					-- Divide that into 8 equal slices of 2*pi/8 == pi/4 radians.
					-- The horizontal and diagonal axes each go through the centres of two slices.
					-- So, the slice centered at 0 radians extends from -pi/8 to +pi/8.
					local dir = data.crafter:get_look_horizontal()
					-- If the player is looking along a diagonal axis then...
					if (dir + pi/8) % (pi/2) > pi/4 then
						newnode.name = diagonalname
						newnode.param2 = core.dir_to_facedir(core.yaw_to_dir((dir + 3*pi/8) % pi - pi/8))
					else
						newnode.name = straightname
						newnode.param2 = core.dir_to_facedir(core.yaw_to_dir((dir + pi/8) % pi - pi/8))
					end
				end
			end
			local node = data.node or core.get_node(pos)
			if node.name == newnode.name and node.param2 == newnode.param2 then
				-- Diagonal lines only have 2 orientations, but curved lines have 4, so:
				if newnode.name == diagonalname then
					newnode.param2 = core.dir_to_facedir(core.yaw_to_dir(data.crafter:get_look_horizontal() + pi/4))
				end
				newnode.name = string.gsub(newnode.name, "^[^:]*", modname) .. "_zen"
			end
			if data.crafter then
				nc.wear_wield(data.crafter, {snappy = 1}, 1)
			end
			nc.set_loud(pos, newnode)
			return nc.fallcheck(pos)
		end
	end
end
