local modpath = minetest.get_modpath"nyanland"
dofile(modpath .. "/nyancat/init.lua")
local settings = dofile(modpath .. "/settings.lua")
assert(loadfile(modpath .. "/portal.lua"))(settings.height)

minetest.register_craft({
	output = "nyanland:mese_shrub_block",
	recipe = {
		{"nyanland:mese_shrub", "nyanland:mese_shrub", "nyanland:mese_shrub"},
		{"nyanland:mese_shrub", "nyanland:mese_shrub", "nyanland:mese_shrub"},
		{"nyanland:mese_shrub", "nyanland:mese_shrub", "nyanland:mese_shrub"},
	}
})

for name, burntime in pairs{
	meseleaves = 5,
	clonestone = 100,
	healstone = 100,
} do
	minetest.register_craft({
		type = "fuel",
		recipe = "nyanland:" .. name,
		burntime = burntime,
	})
end

--Cloudstone
local cloudstone_sounds = {
	dug = {name="default_dug_node", gain=0.25},
	place = {name="default_place_node_hard", gain=0.1},
	footstep = {name="nyanland_cloud_footstep", gain=0.05}
}

minetest.register_node("nyanland:cloudstone", {
	tiles = {"nyanland_cloudstone.png"},
	use_texture_alpha = "blend",
	sunlight_propagates = true,
	light_source = 10,
	groups = {dig_immediate = 3, not_in_creative_inventory=1},
	sounds = cloudstone_sounds
})

minetest.register_node("nyanland:cloudstone_var", {
	tiles = {"nyanland_cloudstone_var.png", "nyanland_cloudstone_var.png", "nyanland_cloudstone.png"},
	use_texture_alpha = "blend",
	sunlight_propagates = true,
	drop = '',
	light_source = 10,
	groups = {dig_immediate = 3, not_in_creative_inventory=1},
	sounds = cloudstone_sounds
})


minetest.register_node("nyanland:mesetree", {
	description = "Mese Tree",
	tiles = {"nyanland_mesetree_top.png", "nyanland_mesetree_top.png", "nyanland_mesetree.png"},
	groups = {tree=1,cracky=1,level=2, not_in_creative_inventory=1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("nyanland:meseleaves", {
	drawtype = "allfaces_optional",
	tiles = {"nyanland_meseleaves.png"},
	paramtype = "light",
	groups = {snappy=3, flammable=2, not_in_creative_inventory=1},
--	groups = {snappy=3, leafdecay=3, flammable=2},
})

minetest.register_node("nyanland:mese_shrub", {
	description = "Mese Shrub",
	drawtype = "plantlike",
	tiles = {"nyanland_mese_shrub.png"},
	inventory_image = "nyanland_mese_shrub.png",
	wield_image = "nyanland_mese_shrub.png",
	paramtype = "light",
	waving = 1,
	walkable = false,
	buildable_to = true,
	groups = {snappy=3,flammable=3,attached_node=1, not_in_creative_inventory=1},
	sounds = default.node_sound_leaves_defaults(),
	selection_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, -0.5, 0.5, -5/16, 0.5},
	},
})

minetest.register_node("nyanland:mese_shrub_fruits", {
	description = "Mese Shrub with fruits",
	drawtype = "plantlike",
	tiles = {"nyanland_mese_shrub.png^nyanland_mese_shrub_fruits.png"},
	inventory_image = "nyanland_mese_shrub.png^nyanland_mese_shrub_fruits.png",
	wield_image = "nyanland_mese_shrub.png^nyanland_mese_shrub_fruits.png",
	paramtype = "light",
	waving = 1,
	walkable = false,
	buildable_to = true,
	groups = {snappy=3,flammable=3,attached_node=1, not_in_creative_inventory=1},
	sounds = default.node_sound_leaves_defaults(),
	selection_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, -0.5, 0.5, -5/16, 0.5},
	},
})

minetest.register_node("nyanland:mese_shrub_block", {
	description = "Mese Shrub Block",
	tiles = {"nyanland_mese_shrub_block.png"},
	groups = {snappy = 3, flammable = 2, level = 2, not_in_creative_inventory = 1},
	sounds = default.node_sound_leaves_defaults(),
})

-- Clonestone
local function clone_node(pos)
	pos.y = pos.y+1
	local nd = minetest.get_node(pos)
	local node_over = nd.name
	if node_over ~= "air"
	and node_over ~= "ignore"
	and node_over ~= "nyanland:clonestone"
	and minetest.registered_nodes[node_over] then
		local metacontent = minetest.get_meta(pos):to_table()
		pos.y = pos.y-1
		minetest.add_node(pos, nd)
		minetest.get_meta(pos):from_table(metacontent)
	end
--	nodeupdate(pos)
end

minetest.register_node("nyanland:clonestone", {
	description = "clonestone",
	tiles = {"nyanland_clonestone.png"},
	groups = {cracky = 1, not_in_creative_inventory=1},
	on_construct = clone_node,
})

minetest.register_abm({
	nodenames = {"nyanland:clonestone"},
	interval = 5,
	chance = 1,
	catch_up = false,
	action = clone_node,
})

-- Healstone
minetest.register_node("nyanland:healstone", {
	description = "nyanland healstone",
	tiles = {"nyanland_healstone.png"},
	groups = {cracky = 1, not_in_creative_inventory=1},
})

minetest.register_abm({
	nodenames = {"nyanland:healstone"},
	interval = 1.0,
	chance = 1,
	action = function(pos)
		for _, obj in pairs(minetest.get_objects_inside_radius(pos, 3)) do
			local hp = obj:get_hp()
			if hp >= 20 then return end
			obj:set_hp(hp+2)
		end
	end,
})

if minetest.global_exists"treecapitator" then
	treecapitator.register_tree{
		trees = {"nyanland:mesetree", "nyanland:healstone"},
		leaves = {"nyanland:meseleaves"},
		range = settings.tree_size,
		fruits = {"default:apple"}
	}
end

--MOVING NYAN CATS
minetest.register_abm({
	nodenames = {"nyancat:nyancat"},
	interval = 10,
	chance = 100,
	catch_up = false,
	action = function(pos)
		if pos.y > settings.height then
			minetest.remove_node(pos)
			minetest.add_entity(pos, "nyanland:head_entity")
			minetest.sound_play("nyanland_cat", {pos = pos,	gain = 0.9, max_hear_distance = 35})
		end
	end,
})

local function spawn_falling_node(pos, node)
	local obj = minetest.add_entity(pos, "__builtin:falling_node")
	if not obj then
		minetest.log("error", "Could not add a falling_node entity")
		return
	end
	obj:get_luaentity():set_node(node)
end

minetest.register_entity("nyanland:head_entity", {
	initial_properties = {
		physical = true,
		textures = {"nyancat_side.png", "nyancat_side.png", "nyancat_side.png",
			"nyancat_side.png", "nyancat_back.png", "nyancat_front.png"},
		collisionbox = {-0.5,-0.5,-0.5, 0.5,0.5,0.5},
		visual = "cube",
		visual_size = {x=1.001, y=1.001},
	},

	on_activate = function(self)
		self.object:set_velocity{x=0, y=0, z=-2}
		self.object:set_armor_groups{immortal=1}
		self.lastpos = vector.round(self.object:get_pos())
		self.timer = math.random()*8-4
	end,

	on_punch = function(self)
		local mesepos = self.object:get_pos()
		if math.random(10) == 1 then
			minetest.sound_play("nyanland_cat",
				{pos = mesepos,	gain = 0.9, max_hear_distance = 35})
		end
		mesepos.y = mesepos.y-1
		spawn_falling_node(mesepos, {name = "default:mese_block"})
	end,

	on_step = function(self, dtime)
		self.timer = self.timer+dtime
		if self.timer >= 16 then
			minetest.add_node(self.lastpos, {name="nyancat:nyancat"})
			self.object:remove()
			return
		end
		local finepos = self.object:get_pos()
		local pos = vector.round(finepos)
		if vector.equals(self.lastpos, pos) then
			return
		end
		self.lastpos = pos
		if minetest.get_node(pos).name == "nyancat:nyancat_rainbow" then
			self.object:remove()
			return
		end
		local p = vector.new(pos)
		for i = math.random(6)+18,300 do
			p.z = pos.z+i
			if minetest.get_node(p).name ~= "nyancat:nyancat_rainbow" then
				break
			end
			minetest.remove_node(p)
		end
		local z = math.floor(finepos.z+0.1)
		for i = 1,6 do
			p.z = z+i
			if minetest.get_node(p).name ~= "air" then
				return
			end
			minetest.add_node(p, {name="nyancat:nyancat_rainbow"})
		end
	end,

	lastpos = {x=0, y=0, z=0},
})


local nt = {
	"[combine:32x16:0,0=nyancat_rainbow.png^[transformFX^[combine:32x16:0,0=nyancat_rainbow.png^[transformR90",
	"[combine:16x32:0,0=nyancat_rainbow.png^[transformFX^[combine:16x32:0,16=nyancat_rainbow.png"
}

for i = 1,2 do
	nt[2*i-1] = {
		name = nt[i],
		animation = {
			type = "vertical_frames",
			aspect_w = 16,
			aspect_h = 16,
			length = 0.3
		}
	}
end

nt[2] = nt[1]

minetest.override_item("nyancat:nyancat_rainbow", {tiles = nt})


minetest.register_node("nyanland:nyancat", {
	description = "golden Nyan Cat",
	tiles = {"nyancat_side.png", "nyancat_side.png", "nyancat_side.png",
		"nyancat_side.png", "default_gold_block.png^nyanland_nc_back.png", "default_gold_block.png^nyanland_nc_front.png"},
	paramtype2 = "facedir",
	groups = {cracky=1, not_in_creative_inventory=1},
	is_ground_content = false,
	legacy_facedir_simple = true,
	sounds = default.node_sound_defaults(),
	after_place_node = function(pos, player)
		minetest.get_meta(pos):set_string("owner", player:get_player_name())
	end,
	can_dig = function(pos, player)
		local owner = minetest.get_meta(pos):get_string"owner"
		return not owner
			or owner == ""
			or (
				owner == player:get_player_name()
				and player:get_player_control().sneak
			)
	end,
})

local punchfct = minetest.registered_nodes["nyanland:nyancat"].on_punch
minetest.override_item("nyanland:nyancat", {
	on_punch = function(pos, node, player, pt, ...)
		if pt.above
		and minetest.get_meta(pos):get_string"owner" == player:get_player_name()
		and not player:get_player_control().sneak
		and minetest.get_node(pt.above).name == "air" then
			minetest.sound_play("nyanland_cat", {pos = pos,	gain = 2, max_hear_distance = 41})
			minetest.set_node(pt.above, {name="default:goldblock"})
		end
		return punchfct(pos, node, player, pt, ...)
	end,
})

local makecat = nyancat.place
function nyancat.place(pos, facedir, length)
	if minetest.get_node(pos).name ~= "default:stone_with_gold" then
		return makecat(pos, facedir, length)
	end
	local tailvec = minetest.facedir_to_dir(facedir)
	local p = vector.new(pos)
	minetest.set_node(p, {name = "nyanland:nyancat", param2 = facedir})
	for _ = 1, length + 5 do
		p.x = p.x + tailvec.x
		p.z = p.z + tailvec.z
		minetest.set_node(p, {
			name = "nyancat:nyancat_rainbow",
			param2 = facedir
		})
	end
end

minetest.register_mapgen_script(modpath .. "/mapgen_script.lua")

if not minetest.settings:get_bool"nyanland.enable_nyanland_legacy" then
	return
end

minetest.register_entity("nyanland:tail_entity", {
	on_activate = function(self)
		self.object:remove()
	end
})

minetest.register_entity("nyanland:mese", {
	on_activate = function(self)
		self.object:remove()
	end,
})
