local settings = dofile(minetest.get_modpath"nyanland" .. "/settings.lua")

-- Weierstrass function code from https://github.com/slemonide/gen
local function do_ws_func(a, x)
	local n = math.pi * x / 16000
	local y = 0
	for k = 1,1000 do
		y = y + math.sin(k^a * n)/(k^a)
	end
	return 1000*y/math.pi
end

-- caching function
local ws_values = {}
local function get_ws_value(a, x)
	local v = ws_values[a]
	if v then
		v = v[x]
		if v then
			return v
		end
	else
		ws_values[a] = {}
		-- weak table, see https://www.lua.org/pil/17.1.html
		setmetatable(ws_values[a], {__mode = "kv"})
	end
	v = do_ws_func(a, x)
	ws_values[a][x] = v
	return v
end


local c_tree = minetest.get_content_id"nyanland:mesetree"
local c_hls = minetest.get_content_id"nyanland:healstone"
local c_apple = minetest.get_content_id"default:apple"
local c_leaves = minetest.get_content_id"nyanland:meseleaves"
local c_air = minetest.get_content_id"air"
local c_ignore = minetest.get_content_id"ignore"

local function mesetree(pos, tran, nodes, area, pr)
	-- stem
	local head_y = pos.y+4+tran
	local vi_trunk = area:indexp(pos)
	for _ = 0, head_y - pos.y do
		if pr:next(1,200) == 1 then
			nodes[vi_trunk] = c_hls
		else
			nodes[vi_trunk] = c_tree
		end
		vi_trunk = vi_trunk + area.ystride
	end
	-- head
	local s = settings.tree_size
	local stest = s*s + s
	for z = -s, s do
		for y = -s, s do
			local zytest = z*z + y*y
			if zytest <= stest then
				local vi = area:index(pos.x-s, head_y+y, pos.z+z)
				for x = -s, s do
					if zytest + x*x <= stest then
						if nodes[vi] == c_air
						or nodes[vi] == c_ignore then
							if pr:next(1,5) ~= 1 then
								nodes[vi] = c_leaves
							elseif pr:next(1,11) == 1 then
								nodes[vi] = c_apple
							end
						end
					end
					vi = vi + 1
				end
			end
		end
	end
end


local c_nyancat = minetest.get_content_id"nyancat:nyancat"
local c_nyancat_rainbow = minetest.get_content_id"nyancat:nyancat_rainbow"
local c_cloudstone = minetest.get_content_id"nyanland:cloudstone"
local c_cloudstone2 = minetest.get_content_id"nyanland:cloudstone_var"
local c_clonestone = minetest.get_content_id"nyanland:clonestone"
local c_mese_shrub = minetest.get_content_id"nyanland:mese_shrub"
local c_mese_shrub_fruits = minetest.get_content_id"nyanland:mese_shrub_fruits"
local c_cloud = minetest.get_content_id"default:cloud"
local c_mese = minetest.get_content_id"default:mese"
local c_ice = minetest.get_content_id"default:ice"

local ypse = settings.height

local hole = {
	seed = 13,
	octaves = 3,
	persist = 0.5,
	spread = {x=500, y=500, z=500},
	scale = 1,
	offset = 0,
}

local height = {
	seed = 133,
	octaves = 3,
	persist = 0.5,
	spread = {x=100, y=100, z=100},
	scale = 1,
	offset = 0,
}


minetest.register_on_generated(function(vm, minp, maxp, blockseed)
	if minp.y >= ypse+10
	or maxp.y <= ypse-10 then
		return
	end

	local t1
	if settings.enable_debug_messages then
		t1 = os.clock()
		local geninfo = "[nyanland] generates: x=[" .. minp.x .. "; " ..
			maxp.x .. "]; y=[" .. minp.y .. "; " .. maxp.y .. "]; z=[" ..
			minp.z .. "; " .. maxp.z .. "]"
		minetest.log("action", geninfo)
	end
	local pr = PseudoRandom(blockseed+112)
	local data = vm:get_data()
	local emin, emax = vm:get_emerged_area()
	local area = VoxelArea:new{MinEdge=emin, MaxEdge=emax}

	local side_length = maxp.x - minp.x + 1
	local map_lengths_xyz = {x=side_length, y=side_length, z=side_length}

	local pmap1 = minetest.get_perlin_map(hole, map_lengths_xyz
		):get_2d_map_flat{x=minp.x, y=minp.z}
	local pmap2 = minetest.get_perlin_map(height, map_lengths_xyz
		):get_2d_map_flat{x=minp.x, y=minp.z}

	local num = 1
	local tab = {}

	local count = 0
	for z=minp.z, maxp.z do
		for x=minp.x, maxp.x do
			count = count+1
			local test2 = math.abs(pmap2[count])
			if test2 >= 0.2 then
				local y = ypse + math.floor(pmap1[count]*3+0.5)
				if y <= maxp.y
				and y >= minp.y then
					local depth = math.floor(
						((get_ws_value(3, x) + get_ws_value(5, z)) % 14)
						* math.min((test2 - 0.2) * 25 / 4, 1)
						+ 0.5)
					if depth ~= 0 then
						local sel = math.floor(get_ws_value(2, x) +
							get_ws_value(2, z) + 0.5) % 10
						local p = area:index(x, y-depth, z)
						if sel <= 5 then
							data[p] = c_cloudstone
						elseif sel == 6 then
							data[p] = c_ice
						elseif sel == 7 then
							data[p] = c_mese
						end
					end
					local p = area:index(x, y, z)
					local tree_rn = pr:next(1, 1000)
					if tree_rn == 1 then
						tab[num] = {x=x, y=y+1, z=z}
						num = num+1
						data[p] = c_cloud
					elseif pr:next(1, 5000) == 1 then
						data[p] = c_clonestone
					elseif pr:next(1, 300) == 1 then
						data[p] = c_cloudstone2
					else
						data[p] = c_cloudstone
					end
					if tree_rn == 4 then
						p = p + area.ystride
						if pr:next(1, 1000) == 2 then
							data[p] = c_mese_shrub_fruits
						else
							data[p] = c_mese_shrub
						end
					end
				end
			end
		end
	end

	for _,p in pairs(tab) do
		mesetree(p, pr:next(1,2), data, area, pr)
	end

	local cat_ymin = ypse + 11
	local cat_ymax = ypse + 30
	if minp.y <= cat_ymax
	and maxp.y >= cat_ymin then
		for _ = 1, settings.nyancat_count do
			if pr:next() <= settings.nyancat_prop * 32767 then
				-- Put a nyancat at one random location
				local cat_y = pr:next(math.max(emin.y, cat_ymin),
					math.min(emax.y, cat_ymax))
				local vi = area:index(pr:next(minp.x, maxp.x),
					cat_y,
					pr:next(minp.z, maxp.z))
				data[vi] = c_nyancat
				for _ = 1, pr:next(4, 15) do
					vi = vi + area.zstride
					data[vi] = c_nyancat_rainbow
				end
			end
		end
	end

	vm:set_data(data)

	if settings.enable_debug_messages then
		local geninfo = string.format("[nyanland] done after: %.2fs",
			os.clock() - t1)
		minetest.log("action", geninfo)
	end
end)
