<!--
SPDX-FileCopyrightText: 2025 IanTwenty <https://gitlab.com/IanTwenty>

SPDX-License-Identifier: CC-BY-SA-4.0

A game mod for Mineclonia - adds more chocolate items to the game

For full copyright information see the AUTHORS file at the top-level
directory of this distribution or at
[AUTHORS](https://gitlab.com/IanTwenty/allthingschocolate/AUTHORS.md)

This work is licensed under the Creative Commons Attribution 4.0 International
License. You should have received a copy of the license along with this work.
If not, visit http://creativecommons.org/licenses/by/4.0/ or send a letter to
Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
-->

# Contributing

Feedback and contribution are welcome.

## Table of Contents

<!--toc:start-->

- [General Information](#general-information)
- [Contributions](#contributions)
  - [Licensing](#licensing)
  - [Development](#development)
  - [Testing](#testing)

<!--toc:end-->

## General Information

Please provide ideas via issues or pull requests to our GitLab repository:
[https://gitlab.com/IanTwenty/allthingschocolate](https://gitlab.com/IanTwenty/allthingschocolate).

Our documentation consists of the following files in the repository:

- AUTHORS.md
- CHANGELOG.md
- CONTRIBUTING.md (this file)
- README.md
- LICENSES directory

## Contributions

### Licensing

All (new) contributed material must be released under the AGPLv3 or later. A copy
of the license is included in the repository, see the LICENSES directory. All
new contributed material that is not executable such as assets, including all
text when not executed, is also released under the [Creative Commons
Attribution ShareAlike 4.0 International (CC BY-SA
4.0)](https://creativecommons.org/licenses/by-sa/4.0/) license.

When reusing software components they MUST have a license compatible with the
license of this software.

### Development

- We're using [devenv](https://devenv.sh/) to manage the dev environment
- Add a `build_local.ninja` and set required custom vars there:

```ninja
builddir=?                      # path to store build output
luanti_install_dir=/.../luanti  # path to luanti install dir
                                # e.g. (flatpak) /home/you/.var/app/net.minetest.Minetest/.minetest
```

Run the build `ninja` to deploy the mod into your local luanti mods dir. Run
`ninja install_test_world` to install a `allthingschocolate_test` world in you
luanti worlds dir.

### Testing

Use our test world and you'll start with all the right items.

- As we need to test eating we need to play with survival/enable damage
- Craft the chocolate bars
  - Check you receive the 'Chocolatier' achievement for either bar, you will
    have to restart each time.
- Craft the chocolate cake and place it down
- Eat raw pufferfish to induce hunger. Once you've taken some damage drink
  milk to stop it.
- Now:
  - Eat the chocolate bars
  - Eat the cake
