<!--
SPDX-FileCopyrightText: 2025 IanTwenty <https://gitlab.com/IanTwenty>

SPDX-License-Identifier: CC-BY-SA-4.0

A game mod for Mineclonia - adds more chocolate items to the game

For full copyright information see the AUTHORS file at the top-level
directory of this distribution or at
[AUTHORS](https://gitlab.com/IanTwenty/allthingschocolate/AUTHORS.md)

This work is licensed under the Creative Commons Attribution 4.0 International
License. You should have received a copy of the license along with this work.
If not, visit http://creativecommons.org/licenses/by/4.0/ or send a letter to
Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
-->

# All Things Chocolate

[![ContentDB](https://content.luanti.org/packages/IanTwenty/mcl_allthingschocolate/shields/downloads/)](https://content.luanti.org/packages/IanTwenty/mcl_allthingschocolate/)

[This](https://gitlab.com/IanTwenty/allthingschocolate) is the code repository
for the ['All Things Chocolate'](https://content.luanti.org/packages/IanTwenty/mcl_allthingschocolate/)
[Luanti](https://www.luanti.org/) game mod, designed for use with the
[Mineclonia](https://content.luanti.org/packages/ryvnf/mineclonia/) game.

Chocolate does not have much use in the game besides making cookies so we
wanted to change that. As cocoa beans can be hard to find we add new items
that are nutritious and rewarding:

- Dark and milk chocolate bars
- Chocolate cake
- ...and more in future

To see our recent changes please see the [CHANGELOG](CHANGELOG.md).

## Screenshots

[<img alt="A chocolate cake sits on a table in a house" src="screenshot.png" width="252" height="168">](/screenshot.png)
[<img alt="A half-eaten chocolate cake sits on a table in a house" src="screenshots/eaten_cake.png" width="252" height="168">](/screenshots/eaten_cake.png)
[<img alt="Crafting a chocolate cake" src="screenshots/crafting_cake.png" width="252" height="168">](/screenshots/crafting_cake.png)
[<img alt="Holding a dark chocolate bar" src="screenshots/holding_dark.png" width="252" height="168">](/screenshots/holding_dark.png)
[<img alt="Crafting a dark chocolate bar" src="screenshots/crafting_dark.png" width="252" height="168">](/screenshots/crafting_dark.png)
[<img alt="Holding a milk chocolate bar" src="screenshots/holding_milk.png" width="252" height="168">](/screenshots/holding_milk.png)
[<img alt="Crafting a milk chocolate bar" src="screenshots/crafting_milk.png" width="252" height="168">](/screenshots/crafting_milk.png)

## Table of Contents

<!--toc:start-->

- [Install](#install)
- [Usage](#usage)
- [To Do](#to-do)
- [Thanks](#thanks)
- [Contributing](#contributing)
- [License](#license)

<!--toc:end-->

## Install

- Via ContentDB (currently awaiting approval, check status
  [here](https://content.luanti.org/packages/IanTwenty/mcl_allthingschocolate/)):
  install from within Luanti by browsing online content from
  the content tab and search for 'all things chocolate'.

- Manual install: copy the contents of this repo into a dir
  `mcl_allthingschocolate` under your luanti mods dir.

## Usage

Chocolate crafting:

```

  Dark     Milk
  Choc     Choc     Choc
  Bar      Bar      Cake
 ┌─┬─┬─┐  ┌─┬─┬─┐  ┌─┬─┬─┐
 │ │ │ │  │ │ │ │  │m│m│m│
 │─┼─┼─│  │─┼─┼─│  │─┼─┼─│
 │c│c│c│  │m│c│c│  │s│e│s│
 │─┼─┼─│  │─┼─┼─│  │─┼─┼─│
 │c│c│c│  │c│c│c│  │c│w│c│
 └─┴─┴─┘  └─┴─┴─┘  └─┴─┴─┘

c = cocoa beans
m = milk bucket
s = sugar
e = egg
w = wheat

```

- A dark chocolate bar gives 5 hunger points, 6 saturation
- A milk chocolate bar gives 5 hunger points, 4 saturation
- Crafting either chocolate bar gives the 'Chocolatier' achievement
- A slice of chocolate cake gives 4 hunger points, 0.6 saturation

## To Do

Meta:

- Announce mod on the forums.
- Why does the webhook not work?
- When build pushes mod to own install dir it would be nice if:
  - It respected `export-ignore` in `.gitattributes` to simulate contentdb.
  - Also treat git lfs files as if we did not have it installed, as content db does
- Use pre-commit hooks to also test above, we never want to ship with missing
  textures.
- Some of the metadata is repeated/replicated. Remove the duplication.
- Improve textures, bit basic at present
- Update galagos

Features:

- Add support for translation
- Ability to melt chocolate in brewing stand into bottles
- Ability to pour chocolate into cauldron
- Ability to dip items in chocolate in cauldron
- Feeding chocolate to wolves hurts them. A typical 4oz chocolate bar would be
  mildly toxic to a 60lb dog apparently so the effect does not need to be strong:
  [Dog Chocolate Toxicity Meter](https://www.petmd.com/dog/chocolate-toxicity)
- Chocolate tipped...
  - Arrows?
  - Weapons?
- Chocolate boxes

## Thanks

Our thanks go to:

- All the Luanti and Mineclonia contributors that make the game possible.
- ContentDB for hosting this mod.
- GitLab for repository hosting.

## Contributing

If you have any suggestions or find any issues please raise an issue in the
GitLab repository. For more information see [CONTRIBUTING](CONTRIBUTING.md).

## License

We declare our licensing by following the REUSE specification - copies of
applicable licenses are stored in the LICENSES directory. Here is a summary:

- All source code is licensed under AGPL-3.0-or-later.
- Assets are licensed under CC-BY-SA-4.0. Our chocolate cake textures are
  derived from those in the Mineclonia project which I believe are licensed
  under the same CC-BY-SA-4.0: [mineclonia/mods/ENTITIES/mobs_mc/LICENSE-media.md](https://codeberg.org/mineclonia/mineclonia/src/branch/main/mods/ENTITIES/mobs_mc/LICENSE-media.md)
- Anything else that is not executable, including the text when extracted from
  code, is licensed under CC-BY-SA-4.0.
- Where we use a range of copyright years it is inclusive and shorthand for
  listing each year individually as a copyrightable year in its own right.

For more accurate information, check individual files.

'All Things Chocolate' is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU Affero General Public License for more
details.
