-- SPDX-FileCopyrightText: 2025 IanTwenty <https://gitlab.com/IanTwenty>
--
-- SPDX-License-Identifier: AGPL-3.0-or-later
--
-- A game mod for Mineclonia - adds more chocolate items to the game
--
-- For full copyright information see the AUTHORS file at the top-level
-- directory of this distribution or at
-- [AUTHORS](https://gitlab.com/IanTwenty/allthingschocolate/AUTHORS.md)
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License
-- along with this program. If not, see <https://www.gnu.org/licenses/>.

local S = minetest.get_translator(minetest.get_current_modname())

minetest.register_craftitem("mcl_allthingschocolate:chocbardark", {
	description = S("Dark Chocolate Bar"),
	_doc_items_longdesc = S("This is a food item which can be eaten."),
	inventory_image = "allthingschocolate_chocbardark.png",
	groups = { food = 2, eatable = 5, compostability = 85, chocolate = 1 },
	_mcl_saturation = 6.0,
	on_place = minetest.item_eat(5),
	on_secondary_use = minetest.item_eat(5),
})

minetest.register_craftitem("mcl_allthingschocolate:chocbarmilk", {
	description = S("Milk Chocolate Bar"),
	_doc_items_longdesc = S("This is a food item which can be eaten."),
	inventory_image = "allthingschocolate_chocbarmilk.png",
	groups = { food = 2, eatable = 5, compostability = 85, chocolate = 1 },
	_mcl_saturation = 4.0,
	on_place = minetest.item_eat(5),
	on_secondary_use = minetest.item_eat(5),
})

minetest.register_craft({
	output = "mcl_allthingschocolate:chocbardark",
	recipe = {
		{ "", "", "" },
		{ "mcl_cocoas:cocoa_beans", "mcl_cocoas:cocoa_beans", "mcl_cocoas:cocoa_beans" },
		{ "mcl_cocoas:cocoa_beans", "mcl_cocoas:cocoa_beans", "mcl_cocoas:cocoa_beans" },
	},
})

minetest.register_craft({
	output = "mcl_allthingschocolate:chocbarmilk",
	recipe = {
		{ "", "", "" },
		{ "mcl_mobitems:milk_bucket", "mcl_cocoas:cocoa_beans", "mcl_cocoas:cocoa_beans" },
		{ "mcl_cocoas:cocoa_beans", "mcl_cocoas:cocoa_beans", "mcl_cocoas:cocoa_beans" },
	},
	replacements = {
		{ "mcl_mobitems:milk_bucket", "mcl_buckets:bucket_empty" },
	},
})

awards.register_achievement("mcl_allthingschocolate:chocolatier", {
	title = S("Chocolatier"),
	description = S("Make a chocolate bar."),
	icon = "allthingschocolate_chocbarmilk.png",
	trigger = {
		type = "craft",
		item = "group:chocolate",
		target = 1,
	},
	type = "Advancement",
	group = "Overworld",
})
