minetest.register_privilege("withdraw", {
		description = "Allows to withdraw hearts from health bar."
})

minetest.register_chatcommand("withdrawme", {
		description = "Takes out hearts from your own health.",
		privs = {
			withdraw = true,
		},
		func = function(name, param)
			local player = minetest.get_player_by_name(name)
			local health = player:get_meta():get_int("health")
			if health == 2 then
				minetest.chat_send_player(player, "Request denied.")
			else
				local inv = player:get_inventory()
				if inv:room_for_item("main", {name = "lifesteal_mod:heart"}) then
					inv:add_item("main", "lifesteal_mod:heart")
				else
					minetest.add_item(player:get_pos(), "lifesteal_mod:heart")
				end
			end
			local health = health - 2
			player:get_meta():set_int("health", health)
			player:set_hp(health)
			player:set_properties({
					hp_max = health
			})
		end
})