local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")

model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2
idioma = settings:get("assets_warehouse_idioma") or "espanol"
playerskin = settings:get("assets_wareohuse_skin") or "playerTQ1.png"

local machete1_descripcion = "To machete"
local fernanda_house_furniture_descripcion = "Furniture of the house of Fernanda"
local fernanda_stinky_bomb_descripcion = "A stinky bomb"
local fernanda_tinajon_descripcion = "A tinajon"
local fernanda_little_treedescripcion = "A little tree for a tinajon"
local fernanda_chairdescripcion = "A chair from Rickos Cafe"
local fernanda_furnituredescripcion = "A furniture from Rickos Cafe"
local fernanda_tochochairdescripcion = "A chair from Tocho house"
local fernanda_littletabledescripcion = "A little table from Tocho house"
local fernanda_couchdescripcion = "A couch from Tocho house"
local fernanda_tochofurnituredescripcion = "A furniture from Tocho house"
local fernanda_tabledescripcion = "A table from Rickos Cafe"
local fernanda_mutant_flowerdescripcion = "A mutant flower"
local elpidio_valdez_zetacio_sworddescripcion = "The sword of Zetacio"
local Elpidio_Valdez_Bandera_de_Ejercito_Espanoldescripcion = "Flag of Spanish Colonial Army"

if idioma == "espanol" then
    machete1_descripcion = "Al machete"
    fernanda_house_furniture_descripcion = "Mueble de la casa de Fernanda"
    fernanda_stinky_bomb_descripcion = "Tremenda bomba de peste"
    fernanda_tinajon_descripcion = "Un tinajon"
    fernanda_little_treedescripcion = "Un pequeño arbol para un tinajon"
    fernanda_chairdescripcion = "Una silla de Rickos Cafe"
    fernanda_furnituredescripcion = "Un mueble de Rickos Cafe"
    fernanda_tochochairdescripcion = "Una silla de casa de Tocho"
    fernanda_littletabledescripcion = "Una pequña mesa de la casa de Tocho"
    fernanda_couchdescripcion = "Un sofa de casa de Tocho"
    fernanda_tochofurnituredescripcion = "Un mueble de casa de Tocho"
    fernanda_tabledescripcion = "Una mesa de Rickos Cafe"
    fernanda_mutant_flowerdescripcion = "Una flor mutante"
    elpidio_valdez_zetacio_sworddescripcion = "La espada de Zetacio"
    Elpidio_Valdez_Bandera_de_Ejercito_Espanoldescripcion = "Bandera del Ejercito Colonial Español"
    
end

assets_warehouse.item("assets_warehouse:elpidio_valdez_machete_1",{
    wield_mesh ='macheteMD'..model_detail..'.obj',
    wielded_entity = true,
    mesh ='macheteMD'..model_detail..'.obj',
    texture = {'elpidio_valdez_machete.png'},
    wield = "elpidio_valdez_machete_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,0.05,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
    description = machete1_descripcion,
    atack = "assets_warehouse2:wesnoth_magic_wand_atack",
    
})

assets_warehouse.set_and_get_storage(5,5,2,8,"assets_warehouse:fernanda_house_furniture",fernanda_house_furniture_descripcion,'fernanda_house_furniture.obj',{'fernanda_house_furniture.png'},
{type = "fixed",fixed = {{-0.5,0.5,0.5,1.5,-0.5,-0.5},},},{type = "fixed",fixed = {{-0.5,0.5,0.5,1.5,-0.5,-0.5},},})



minetest.register_node('assets_warehouse:fernanda_stinky_bomb', {
    drawtype = 'mesh',
    mesh = 'fernanda_stinky_bomb.obj',
    tiles ={'fernanda_stinky_bomb.png'}, 
    description= fernanda_stinky_bomb_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.2,-0.3,0,0.2,-0.5,0.2},
                    
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.2,-0.3,0,0.2,-0.5,0.2},
                    
        },	
    },
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        local pos = pos
        tnt.boom(pos, {damage_radius=3,radius=2,ignore_protection=false})
    end,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    sunlight_propagates=true,
    paramtype = "light",
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

assets_warehouse.set_and_get_storage(5,5,1,4,"assets_warehouse:fernanda_tinajon",fernanda_tinajon_descripcion,'fernanda_tinajonMD'..model_detail..'.obj',{'fernanda_tinajon.png'},
{type = "fixed",fixed = {{-0.5,0.2,-0.5,.5,-0.5,0.5},},},{type = "fixed",fixed = {{-0.5,0.2,-0.5,0.5,-0.5,0.5},},})

assets_warehouse.set_and_get_storage(5,5,3,8,"assets_warehouse:fernanda_house_furniture2",fernanda_house_furniture_descripcion,'fernanda_house_furniture2.obj',{'fernanda_house_furniture2.png'},
{type = "fixed",fixed = {{-0.5,0.5,0.5,1.5,-0.5,0},},},{type = "fixed",fixed = {{-0.5,0.5,0.5,1.5,-0.5,0},},})

assets_warehouse.set_and_get_storage(5,5,2,2,"assets_warehouse:fernanda_house_furniture3",fernanda_house_furniture_descripcion,'fernanda_house_furniture3.obj',{'fernanda_house_furniture3.png'},
{type = "fixed",fixed = {{-0.5,0.5,0.5,0.5,-0.5,-0.5},},},{type = "fixed",fixed = {{-0.5,0.5,0.5,0.5,-0.5,-0.5},},})

minetest.register_node('assets_warehouse:fernanda_little_tree', {
    drawtype = 'mesh',
    mesh = 'fernanda_little_treeMD'..model_detail..'.obj',
    tiles ={'fernanda_little_tree.png'}, 
    description= fernanda_little_treedescripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    selection_box = {
        type = "fixed",
        fixed = {
            {0.1,0.5,0.1,-0.1,-1.0,-0.1},
                    
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {0.1,0.5,0.1,-0.1,-1.0,-0.1},
                    
        },	
    },
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    sunlight_propagates=true,
    use_texture_alpha=false,
    paramtype = "light",
    walkable=true,
    pointable=true,
    
})

minetest.register_node('assets_warehouse:fernanda_chair', {
    drawtype = 'mesh',
    mesh = 'fernanda_chairMD'..model_detail..'.obj',
    tiles ={'fernanda_chair.png'}, 
    description= fernanda_chairdescripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    selection_box = {
        type = "fixed",
        fixed = {
            {0.25,0.,0.5,-0.25,-0.5,0.1},
            {0.25,0.5,0.5,-0.25,0.0,0.4},
                    
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {0.25,0.,0.5,-0.25,-0.5,0.1},
            {0.25,0.5,0.5,-0.25,0.0,0.4},
                    
        },	
    },
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    sunlight_propagates=true,
    paramtype = "light",
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

assets_warehouse.set_and_get_storage(5,5,2,6,"assets_warehouse:fernanda_furniture",fernanda_furnituredescripcion,'fernanda_furniture.obj',{'fernanda_furniture.png'},
{type = "fixed",fixed = {{-0.5,0.5,0.5,1.5,-0.5,-0.5},},},{type = "fixed",fixed = {{-0.5,0.5,0.5,1.5,-0.5,-0.5},},})

minetest.register_node('assets_warehouse:fernanda_chair2', {
    drawtype = 'mesh',
    mesh = 'fernanda_chair2MD'..model_detail..'.obj',
    tiles ={'fernanda_chair2.png'}, 
    description= fernanda_chairdescripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    selection_box = {
        type = "fixed",
        fixed = {
            {0.25,0,0.5,-0.25,-0.5,-0.1},
            {0.25,0.45,0.5,-0.25,0.0,0.4},
                    
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {0.25,0,0.5,-0.25,-0.5,-0.1},
            {0.25,0.45,0.5,-0.25,0.0,0.4},
                    
        },	
    },
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    sunlight_propagates=true,
    use_texture_alpha=false,
    paramtype = "light",
    walkable=true,
    pointable=true,
})



minetest.register_node('assets_warehouse:fernanda_tochochair', {
    drawtype = 'mesh',
    mesh = 'fernanda_tochochairMD'..model_detail..'.obj',
    tiles ={'fernanda_tochochair.png'}, 
    description= fernanda_tochochairdescripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    selection_box = {
        type = "fixed",
        fixed = {
            {0.25,0,0.5,-0.25,-0.5,-0.05},
            {0.25,0.7,0.5,-0.25,0.0,0.4},
                    
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {0.25,0,0.5,-0.25,-0.5,-0.05},
            {0.25,0.7,0.5,-0.25,0.0,0.4},
                    
        },	
    },
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    sunlight_propagates=true,
    use_texture_alpha=false,
    paramtype = "light",
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:fernanda_littletable', {
    drawtype = 'mesh',
    mesh = 'fernanda_littletableMD'..model_detail..'.obj',
    tiles ={'fernanda_littletable.png'}, 
    description= fernanda_littletabledescripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    selection_box = {
        type = "fixed",
        fixed = {
            {0.25,0.5,0.25,-0.25,-0.5,-0.25},
            
                    
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {0.25,0.5,0.25,-0.25,-0.5,-0.25},
                    
        },	
    },
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    sunlight_propagates=true,
    use_texture_alpha=false,
    paramtype = "light",
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:fernanda_couch', {
    drawtype = 'mesh',
    mesh = 'fernanda_couchMD'..model_detail..'.obj',
    tiles ={'fernanda_couch.png'}, 
    description= fernanda_couchdescripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    selection_box = {
        type = "fixed",
        fixed = {
            {0.5,0,0.5,-0.5,-0.5,-0.5},
            {0.5,1.0,0.5,-0.5,0.0,0.3},
                    
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {0.5,0,0.5,-0.5,-0.5,-0.5},
            {0.5,1.0,0.5,-0.5,0.0,0.3},
                    
        },	
    },
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    sunlight_propagates=true,
    use_texture_alpha=false,
    paramtype = "light",
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:fernanda_tochofurniture', {
    drawtype = 'mesh',
    mesh = 'fernanda_tochofurnitureMD'..model_detail..'.obj',
    tiles ={'fernanda_tochofurniture.png'}, 
    description= fernanda_tochofurnituredescripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    selection_box = {
        type = "fixed",
        fixed = {
            {0.5,0,0.5,-0.5,-0.5,-0.5},
            
                    
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {0.5,0,0.5,-0.5,-0.5,-0.5},
           
                    
        },	
    },
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    sunlight_propagates=true,
    use_texture_alpha=false,
    paramtype = "light",
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:fernanda_table', {
    drawtype = 'mesh',
    mesh = 'fernanda_tableMD'..model_detail..'.obj',
    tiles ={'fernanda_table.png'}, 
    description= fernanda_tabledescripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    selection_box = {
        type = "fixed",
        fixed = {
            {1.0,0.5,1.0,-1.0,-0.5,-1.0},
                    
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {1.0,0.5,1.0,-1.0,-0.5,-1.0},
                    
        },	
    },
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    sunlight_propagates=true,
    use_texture_alpha=false,
    paramtype = "light",
    walkable=true,
    pointable=true,
})

if minetest.get_modpath("mobs") then
  
    
    mobs:register_mob("assets_warehouse:fernanda_mutantflower", {
        type = "monster",
        visual_size = {x = 10, y = 10}, 
        passive = false,
        attack_type = "dogshoot",
        damage = 4,
        reach = 1,
        shoot_interval = 1,
        arrow = 'assets_warehouse:testarrow',
        shoot_offset = 0.5,
        knock_back = false,
        hp_min = 50,
        hp_max = 100,
        armor = 80,
        collisionbox = {-0.75, -0.5, -0.75, 0.75, 2.5, 0.75},
        visual = "mesh",
        mesh = "fernanda_mutantflowerMD"..model_detail..".x",
        rotate = 180,
        textures = {
            {"fernanda_mutant_flower.png"}
        },
        view_range = 10,
        walk_velocity = 0,
        run_velocity = 0,
        jump = false,
        jump_height = 0,
        can_leap = true,
        fall_damage = 0,
        stepheight = 2.1,
        --drops = {
        --    {name = "default:mese_crystal", chance = 9, min = 0, max = 2},
        --    {name = "default:mese_crystal_fragment", chance = 1, min = 0, max = 2},
        --},
        animation = {
            --speed_normal = 18,
            --speed_run    = 18,
            --walk_start   = 10,
            --walk_end     = 41,
            --walk_speed   = 20,
            --run_start    = 10,
            --run_end      = 41,
            --run_speed    = 30,
            stand_start  = 30,
            stand_end    = 90,
            shoot_start  = 130,
            shoot_end    = 150,
            --die_start    = 125,
            --die_end      = 141,
            --death_speed  = 25,
            --die_loop     = false,
            --jump_start   = 150 ,
            --jump_end     = 168,
            --jump_loop    = false,
            punch_start  = 90,
            punch_end    = 130
        },
        water_damage = 0,
        lava_damage = 0,
        light_damage = 0,
        
    })

   

    mobs:register_egg("assets_warehouse:fernanda_mutantflower", fernanda_mutant_flowerdescripcion, "fernanda_mutant_flowerpreview.png", 0, false)

    mobs:spawn({
        name = "assets_warehouse:fernanda_mutantflower",
        nodes = {"default:dirt"},
        max_light = 7,
        chance = 5000,
        active_object_count = 3,
        max_height = -20
    })
end



assets_warehouse.item("assets_warehouse:elpidio_valdez_zetacio_sword",{
    wield_mesh ='elpidio_valdez_zetacio_sword.obj',
    wielded_entity = true,
    mesh ='elpidio_valdez_zetacio_sword'..model_detail..'.obj',
    texture = {'elpidio_valdez_zetacio_sword.png'},
    wield = "elpidio_valdez_zetacio_swordpreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,0.05,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
    description = elpidio_valdez_zetacio_sworddescripcion,
    atack = "assets_warehouse2:wesnoth_magic_wand_atack",
    
})

minetest.register_node('assets_warehouse:Elpidio_Valdez_Bandera_del_Ejercito_Espanol', {
    drawtype = 'mesh',
    mesh = 'elpidio_valdez_Bandera_del_Ejercito_Espanol.obj',
    tiles ={'elpidio_valdez_Bandera_del_Ejercito_Espanol.png'}, 
    description= Elpidio_Valdez_Bandera_de_Ejercito_Espanoldescripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-1.0,0.5,0.35,0.5,-0.5,0.5},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-1.0,0.5,0.45,0.5,-0.5,0.5},
        },	
    },
    sunlight_propagates=true,
    paramtype = "light",
    use_texture_alpha=true,
    walkable=true,
    pointable=true,
})