--my code
assets_warehouse.storage = {}

function assets_warehouse.set_and_get_storage(fsx,fsy,invx,invy,name,description,mesh,tiles,selection_box,collision_box)
    function assets_warehouse.storage.get_storage_formspec(pos)
        local spos = pos.x .. "," .. pos.y .. "," .. pos.z
        local formspec =
            "size["..fsx..","..fsy.."]" ..
            "list[nodemeta:" .. spos .. ";main;0,4.3;8,1;]" ..
            "list[current_player;main;0,4.85;8,1;]" ..
            "list[current_player;main;0,6.08;8,3;8]" ..
            "listring[nodemeta:" .. spos .. ";main]" ..
            "listring[current_player;main]" ..
            default.get_hotbar_bg(0,4.85)
        return formspec
    end
    minetest.register_on_player_receive_fields(function(player, formname, fields)
        if formname ~= name then --"assets_warehouse:storage1" then
            return
        end
        if not player or not fields.quit then
            return
        end
        local pn = player:get_player_name()

        return true
    end)
    
    function assets_warehouse.storage.register_storage(prefixed_name, d)
        local name = prefixed_name:sub(1,1) == ':' and prefixed_name:sub(2,-1) or prefixed_name
        local def = table.copy(d)
        
        if def.protected then
            def.on_construct = function(pos)
                local meta = minetest.get_meta(pos)
                meta:set_string("infotext", "Locked Chest")
                meta:set_string("owner", "")
                local inv = meta:get_inventory()
                inv:set_size("main", invx*invy)
            end
            def.after_place_node = function(pos, placer)
                local meta = minetest.get_meta(pos)
                meta:set_string("owner", placer:get_player_name() or "")
                meta:set_string("infotext", "Locked Chest (owned by @1)", meta:get_string("owner"))
            end
            def.can_dig = function(pos,player)
                local meta = minetest.get_meta(pos);
                local inv = meta:get_inventory()
                return inv:is_empty("main") and
                        default.can_interact_with_node(player, pos)
            end
            def.allow_metadata_inventory_move = function(pos, from_list, from_index,
                    to_list, to_index, count, player)
                if not default.can_interact_with_node(player, pos) then
                    return 0
                end
                return count
            end
            def.allow_metadata_inventory_put = function(pos, listname, index, stack, player)
                if not default.can_interact_with_node(player, pos) then
                    return 0
                end
                return stack:get_count()
            end
            def.allow_metadata_inventory_take = function(pos, listname, index, stack, player)
                if not default.can_interact_with_node(player, pos) then
                    return 0
                end
                return stack:get_count()
            end
            def.on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
                if not default.can_interact_with_node(clicker, pos) then
                    return itemstack
                end

                minetest.sound_play(def.sound_open, {gain = 0.3,
                        pos = pos, max_hear_distance = 10}, true)
                minetest.after(0.2, minetest.show_formspec,
                        clicker:get_player_name(),
                        "assets_warehouse:storage1", default.chest.get_chest_formspec(pos))
                
            end
            def.on_blast = function() end
            def.on_key_use = function(pos, player)
                local secret = minetest.get_meta(pos):get_string("key_lock_secret")
                local itemstack = player:get_wielded_item()
                local key_meta = itemstack:get_meta()

                if itemstack:get_metadata() == "" then
                    return
                end

                if key_meta:get_string("secret") == "" then
                    key_meta:set_string("secret", minetest.parse_json(itemstack:get_metadata()).secret)
                    itemstack:set_metadata("")
                end

                if secret ~= key_meta:get_string("secret") then
                    return
                end

                minetest.show_formspec(
                    player:get_player_name(),
                    "assets_warehouse:chest_locked",
                    assets_warehouse.storage.get_storage_formspec(pos)
                )
            end
            def.on_skeleton_key_use = function(pos, player, newsecret)
                local meta = minetest.get_meta(pos)
                local owner = meta:get_string("owner")
                local pn = player:get_player_name()

                -- verify placer is owner of lockable chest
                if owner ~= pn then
                    minetest.record_protection_violation(pos, pn)
                    minetest.chat_send_player(pn, "You do not own this chest.")
                    return nil
                end

                local secret = meta:get_string("key_lock_secret")
                if secret == "" then
                    secret = newsecret
                    meta:set_string("key_lock_secret", secret)
                end

                return secret, "a locked chest", owner
            end
        else
            def.on_construct = function(pos)
                local meta = minetest.get_meta(pos)
                meta:set_string("infotext", "Chest")
                local inv = meta:get_inventory()
                inv:set_size("main", invx*invy)
            end
            def.can_dig = function(pos,player)
                local meta = minetest.get_meta(pos);
                local inv = meta:get_inventory()
                return inv:is_empty("main")
            end
            def.on_rightclick = function(pos, node, clicker)
                minetest.sound_play(def.sound_open, {gain = 0.3, pos = pos,
                        max_hear_distance = 10}, true)
               
                minetest.after(0.2, minetest.show_formspec,
                        clicker:get_player_name(),
                        "assets_warehouse:chest", default.chest.get_chest_formspec(pos))
                default.chest.open_chests[clicker:get_player_name()] = { pos = pos,
                        sound = def.sound_close, swap = name }
            end
            def.on_blast = function(pos)
                local drops = {}
                default.get_inventory_drops(pos, "main", drops)
                drops[#drops+1] = name
                minetest.remove_node(pos)
                return drops
            end
        end

        def.on_metadata_inventory_move = function(pos, from_list, from_index,
                to_list, to_index, count, player)
            minetest.log("action", player:get_player_name() ..
                " moves stuff in chest at " .. minetest.pos_to_string(pos))
        end
        def.on_metadata_inventory_put = function(pos, listname, index, stack, player)
            minetest.log("action", player:get_player_name() ..
                " moves " .. stack:get_name() ..
                " to chest at " .. minetest.pos_to_string(pos))
        end
        def.on_metadata_inventory_take = function(pos, listname, index, stack, player)
            minetest.log("action", player:get_player_name() ..
                " takes " .. stack:get_name() ..
                " from chest at " .. minetest.pos_to_string(pos))
        end

        local def_opened = table.copy(def)
        local def_closed = table.copy(def)

       
        def_opened.drop = name
        def_opened.groups.not_in_creative_inventory = 1
        def_opened.selection_box = {
            type = "fixed",
            fixed = { -1/2, -1/2, -1/2, 1/2, 3/16, 1/2 },
        }
        def_opened.can_dig = function()
            return false
        end
        def_opened.on_blast = function() end
        
        minetest.register_node(prefixed_name, def_closed)
        minetest.register_node(prefixed_name .. "_open", def_opened)
       
    end
    assets_warehouse.storage.register_storage(name, {
        paramtype = "light",
        sunlight_propagates = "true",
        paramtype2 = "facedir",
        drawtype = 'mesh',
        mesh = mesh,
        description = description,
        tiles = tiles,
        sounds = default.node_sound_wood_defaults(),
        sound_open = "default_chest_open",
        sound_close = "default_chest_close",
        groups = {choppy = 2, oddly_breakable_by_hand = 2},
        selection_box = selection_box,
        collision_box = collision_box,
    })
end
