local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")


model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2
local idioma = settings:get("assets_warehouse_idioma") or "espanol"

local care_bears_heart_descripcion = "A heart"
local care_bears_pole_descripcion = "A pole"
local care_bears_cloud_block_descripcion = "A little cloud in form of block"
local care_bears_star_descripcion = "A star"
local care_bears_heart_flowers_descripcion = 'Bunch of tiny flowers whit the shape of hearts'
local care_bears_heart_flower2_descripcion = "A flower whit a heart"
local care_bears_tree_descripcion = 'A tree whit hearts'
local care_bears_fence_descripcion = "A fence whit hearts"
local care_bears_popcornmachine_descripcion = "A popcorn machine"
local care_bears_basquet_descripcion = "A basquet"
local care_bears_box_descripcion = "A box"
local care_bears_armchair_descripcion = "A armchair"
local care_bears_pie_descripcion = "A pie"
local care_bears_table_descripcion = "A table"
local care_bears_garden_umbrella_descripcion = "A big umbrella"
local care_bears_care_meter_descripcion = "The care meter of Care a Lot"
local care_bears_writtingmachine_descripcion = "A writting machine"
local care_bears_decosignal_descripcion = "A street signal of the clouds?"
local care_bears_caring_compas_descripcion = "The Grumpys caring compas is supposed to indicate the path to Care a Lot"
local care_bears_littlechest_descripcion = "A ship will be a perfect place for hide this chest"
local care_bears_granma_bear_bed_descripcion = "A bed"
local care_bears_oven_descripcion = "A oven perfect to flood the kitchen whit pocorns"
local care_bears_blender_descripcion = "A blender"
local care_bears_showercloud_descripcion = "A little shower cloud"
local care_bears_giant_flower_descripcion = "A flower maybe from a land with dinossaurs"
local care_bears_giant_basquet_descripcion = "A giant basquet"
local care_bears_air_ballon_descripcion = "Beware of the giant storms"
local care_bears_giant_heart_descripcion = "A giant heart"

if idioma == "espanol" then
    care_bears_heart_descripcion = "Un corazon"
    care_bears_pole_descripcion = "Un poste"
    care_bears_cloud_block_descripcion = "Una pequeña nube en forma de bloque"
    care_bears_star_descripcion = "Una estrella"
    care_bears_heart_flowers_descripcion = "Un puñado de pequeñas flores con forma de corazon"
    care_bears_heart_flower2_descripcion = "Una flor con un corazon"
    care_bears_tree_descripcion = "Un arbol con corazones"
    care_bears_fence_descripcion = "Una cerca con corazones"
    care_bears_popcornmachine_descripcion = "Una maquina de palomitas"
    care_bears_basquet_descripcion = "Una canasta"
    care_bears_box_descripcion = "Una caja"
    care_bears_armchair_descripcion = "Un armario"
    care_bears_pie_descripcion = "Un pastel"
    care_bears_table_descripcion = "Una mesa"
    care_bears_garden_umbrella_descripcion = "Una gran sombrilla"
    care_bears_care_meter_descripcion = "El medidor de cariño de Care a Lot"
    care_bears_writtingmachine_descripcion = "Una maquina de escribir"
    care_bears_decosignal_descripcion = "Un semaforo de las nubes?"
    care_bears_caring_compas_descripcion = "El compas del cariño de Grumpy se supone que indica el camino a Care a Lot"
    care_bears_littlechest_descripcion = "Un barco sera un lugar perfecto para esconder este cofre"
    care_bears_granma_bear_bed_descripcion = "Una cama"
    care_bears_oven_descripcion = "Un horno perfecto para inundar la cocina con palomitas"
    care_bears_blender_descripcion = "Una batidora"
    care_bears_showercloud_descripcion = "Una pequena nube ducha"
    care_bears_giant_flower_descripcion = "Una flor tal vez de una tierra con dinosaurios"
    care_bears_giant_basquet_descripcion = "Una canasta gigante"
    care_bears_air_ballon_descripcion = "Cuidado con las tormentas gigantes"
    care_bears_giant_heart_descripcion = "Un corazon gigante"
    
end

minetest.register_node('assets_warehouse:care_bears_heart', {
	drawtype = 'mesh',
	mesh = 'care_bears_heartMD'..model_detail..'.obj',
	tiles ={'care_bears_heart.png'}, 
	description= care_bears_heart_descripcion,
	stack_max = 1,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
	paramtype2 = "facedir",
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=0,
	diggable=true,
	drowning=0,
	floodable=false,
	range=5.0,
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.5,0.4,-0.09,0.5,-0.5,0.09},		
		},	
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.5,0.4,-0.09,0.5,-0.5,0.09},		
		},	
	},
    paramtype="light",
	sunlight_propagates=true,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
})
minetest.register_node('assets_warehouse:care_bears_pole', {
	drawtype = 'mesh',
	mesh = 'care_bears_poleMD'..model_detail..'.obj',
	tiles ={'care_bears_pole.png'}, 
	description= care_bears_pole_descripcion,
	stack_max = 1,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
	paramtype2 = "facedir",
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=0,
	diggable=true,
	drowning=0,
	floodable=false,
	range=5.0,
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.25,0.5,-0.25,0.25,-0.5,0.25},		
		},	
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.25,0.5,-0.25,0.25,-0.5,0.25},	
		},	
	},
	paramtype="light",
	sunlight_propagates=true,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
})


minetest.register_node('assets_warehouse:care_bears_cloud_block', {
	drawtype = 'mesh',
	mesh = 'care_bears_cloud_blockMD'..model_detail..'.obj',
	tiles ={'care_bears_cloud_block.png'}, 
	description= care_bears_cloud_block_descripcion,
	stack_max = 1,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
	paramtype2 = "facedir",
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=0,
	diggable=true,
	drowning=0,
	floodable=false,
	range=5.0,
    paramtype="light",
	sunlight_propagates=true,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
    
})


minetest.register_node('assets_warehouse:care_bears_star', {
	drawtype = 'mesh',
	mesh = 'care_bears_starMD'..model_detail..'.obj',
	tiles ={'care_bears_star.png'}, 
	description= care_bears_star_descripcion,
	stack_max = 1,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
	paramtype2 = "facedir",
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=0,
	diggable=true,
	drowning=0,
	floodable=false,
	range=5.0,
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.5,0.5,-0.09,0.5,-0.5,0.09},		
		},	
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.5,0.5,-0.09,0.5,-0.5,0.09},	
		},	
	},
    paramtype="light",
	sunlight_propagates=true,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
})


minetest.register_node('assets_warehouse:care_bears_heart_flowers', {
	drawtype = 'mesh',
	mesh = 'care_bears_heart_flowersMD'..model_detail..'.obj',
	tiles ={'care_bears_heart_flowers.png'}, 
	description= care_bears_heart_flowers_descripcion,
	stack_max = 15,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
	paramtype2 = "facedir",
	is_ground_content=true,
	climbable=false,
	buildable_to=true,
	damage_per_second=0,
	diggable=true,
	drowning=0,
	floodable=true,
	range=5.0,
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.5,-0.4,-0.5,0.5,-0.5,0.5},
					
		},	
	},
    paramtype="light",
	sunlight_propagates=true,
	use_texture_alpha=false,
	walkable=false,
	pointable=true,
})
minetest.register_node('assets_warehouse:care_bears_heart_flower2', {
	drawtype = 'mesh',
	mesh = 'care_bears_heart_flower2MD'..model_detail..'.obj',
	tiles ={'care_bears_heart_flower2.png'}, 
	description= care_bears_heart_flower2_descripcion,
	stack_max = 6,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
	paramtype2 = "facedir",
	is_ground_content=true,
	climbable=false,
	buildable_to=true,
	damage_per_second=0,
	diggable=true,
	drowning=0,
	floodable=true,
	range=5.0,
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.1,0.1,-0.1,0.1,-0.5,0.1},		
		},	
	},
    paramtype="light",
	sunlight_propagates=true,
	use_texture_alpha=false,
	walkable=false,
	pointable=true,
})

minetest.register_node('assets_warehouse:care_bears_tree', {
	drawtype = 'mesh',
	mesh = 'care_bears_tree.obj',
	tiles ={'care_bears_tree.png'}, 
	description= care_bears_tree_descripcion,
	stack_max = 1,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
	paramtype2 = "facedir",
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=0,
	diggable=true,
	drowning=0,
	floodable=false,
	range=5.0,
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.5,4.5,-0.5,0.5,-0.5,0.5},		
		},	
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.5,1.0,-0.5,0.5,-0.5,0.5},		
		},	
	},
    paramtype="light",
	sunlight_propagates=true,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
})

minetest.register_node('assets_warehouse:care_bears_fence', {
	drawtype = 'mesh',
	mesh = 'care_bears_fence.obj',
	tiles ={'care_bears_fence.png'}, 
	description= care_bears_fence_descripcion,
	stack_max = 1,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
	paramtype2 = "facedir",
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=0,
	diggable=true,
	drowning=0,
	floodable=false,
	range=5.0,
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.5,0.47,-0.1,0.5,-0.5,0.05},		
		},	
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.5,0.47,-0.1,0.5,-0.5,0.05},		
		},	
	},
    paramtype="light",
	sunlight_propagates=true,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
})

minetest.register_node('assets_warehouse:care_bears_fence_corner', {
    drawtype = 'mesh',
    mesh = 'care_bears_fence_corner.obj',
    tiles ={'care_bears_fence.png'}, 
    description= care_bears_fence_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.1,0.47,-0.1,0.5,-0.5,0.05},	
            {-0.1,0.47,0.0,0.1,-0.5,0.5},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.1,0.47,-0.1,0.5,-0.5,0.05},	
            {-0.1,0.47,0.0,0.1,-0.5,0.5},
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})




minetest.register_node('assets_warehouse:care_bears_popcornmachine', {
	drawtype = 'mesh',
	mesh = 'care_bears_popcornmachine.obj',
	tiles ={'care_bears_popcornmachine.png'}, 
	description= care_bears_popcornmachine_descripcion,
	stack_max = 1,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
	paramtype2 = "facedir",
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=0,
	diggable=true,
	drowning=0,
	floodable=false,
	range=5.0,
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.3,0.15,-0.15,0.3,-0.5,0.5},		
		},	
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.3,0.15,-0.15,0.3,-0.5,0.5},	
		},	
	},
    paramtype="light",
	sunlight_propagates=true,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
})

assets_warehouse.set_and_get_storage(5,5,1,1,"assets_warehouse:care_bears_basquet",care_bears_basquet_descripcion,'care_bears_basquetMD'..model_detail..'.obj',{'care_bears_basquet.png'},{type = "fixed",fixed = {{-0.5,0.1,-0.5,0.5,-0.5,0.5},},},{type = "fixed",fixed = {{-0.5,0.1,-0.5,0.5,-0.5,0.5},},})

assets_warehouse.set_and_get_storage(5,5,1,2,"assets_warehouse:care_bears_box",care_bears_box_descripcion,'care_bears_box.obj',{'care_bears_box.png'},{type = "fixed",fixed = {{-0.5,0,-0.25,0.5,-0.5,0.25},},},{type = "fixed",fixed = {{-0.5,0,-0.25,0.5,-0.5,0.25},},})

assets_warehouse.set_and_get_storage(5,5,1,4,"assets_warehouse:care_bears_armchair",care_bears_armchair_descripcion,'care_bears_armchair.obj',{'care_bears_armchair.png'},{type = "fixed",fixed = {{-0.5,0.5,-0.5,1.5,-0.5,0.5},},},{type = "fixed",fixed = {{-0.5,0.5,-0.5,1.5,-0.5,0.5},},})

minetest.register_node('assets_warehouse:care_bears_pie', {
    drawtype = 'mesh',
    mesh = 'care_bears_pie.obj',
    tiles ={'care_bears_pie.png'}, 
    description= care_bears_pie_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    on_use = minetest.item_eat(10),
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,0,-0.5,0.5,-0.5,0.5},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,0,-0.5,0.5,-0.5,0.5},	
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:care_bears_pie2', {
    drawtype = 'mesh',
    mesh = 'care_bears_pie2.obj',
    tiles ={'care_bears_pie2.png'}, 
    description= care_bears_pie_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    on_use = minetest.item_eat(2),
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,0,-0.5,0.5,-0.5,0.5},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,0,-0.5,0.5,-0.5,0.5},	
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:care_bears_table', {
    drawtype = 'mesh',
    mesh = 'care_bears_tableMD'..model_detail..'.obj',
    tiles ={'care_bears_table.png'}, 
    description= care_bears_table_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-1.0,0.5,-1.0,1.0,-0.5,1.0},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-1.0,0.5,-1.0,1.0,-0.5,1.0},	
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:care_bears_garden_umbrella', {
    drawtype = 'mesh',
    mesh = 'care_bears_garden_umbrella.obj',
    tiles ={'care_bears_garden_umbrella.png'}, 
    description= care_bears_garden_umbrella_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-2.5,2.5,-2.5,2.0,2.0,2.5},
            {-0.1,3.0,-0.1,0.1,-0.5,0.1},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-2.5,2.5,-2.5,2.5,2.0,2.5},
            {-0.1,3.0,-0.1,0.1,-0.5,0.1},	
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:care_bears_care_meter', {
    drawtype = 'mesh',
    mesh = 'care_bears_care_meterMD'..model_detail..'.obj',
    tiles ={'care_bears_care_meter.png'}, 
    description= care_bears_care_meter_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-1.25,1.5,-0.5,1.25,-0.5,0.5},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-1.25,1.5,-0.5,1.25,-0.5,0.5},		
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})


minetest.register_node('assets_warehouse:care_bears_writtingmachine', {
    drawtype = 'mesh',
    mesh = 'care_bears_writtingmachineMD'..model_detail..'.obj',
    tiles ={'care_bears_writtingmachine.png'}, 
    description= care_bears_writtingmachine_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.4,0.14,-0.1,0.4,-0.5,0.5},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.4,0.14,-0.1,0.4,-0.5,0.5},
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:care_bears_decosignal', {
    drawtype = 'mesh',
    mesh = 'care_bears_decosignal.obj',
    tiles ={'care_bears_decosignal.png'}, 
    description= care_bears_decosignal_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.25,1.5,-0.25,0.25,-0.5,0.25},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.25,1.5,-0.25,0.25,-0.5,0.25},	
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

assets_warehouse.item("assets_warehouse:care_bears_caring_compas",{
    mesh ='care_bears_caring_compasMD'..model_detail..'.obj',
    texture = {'care_bears_caring_compas.png'},
    wield = "care_bears_caring_compaspreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,0.05,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
    description = care_bears_caring_compas_descripcion,

})

assets_warehouse.item("assets_warehouse:care_bears_littlechest",{
    mesh ='care_bears_littlechestMD'..model_detail..'.obj',
    texture = {'care_bears_littlechest.png'},
    wield = "care_bears_littlechest_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,0.05,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
    description = care_bears_littlechest_descripcion,
})



minetest.register_node('assets_warehouse:care_bears_granma_bear_bed', {
    drawtype = 'mesh',
    mesh = 'care_bears_granma_bear_bedMD'..model_detail..'.obj',
    tiles ={'care_bears_granma_bear_bed.png'}, 
    description= care_bears_granma_bear_bed_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        if minetest.get_modpath("beds") then
            beds.on_rightclick(pos, clicker)
        end
        return itemstack
    end,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.95,0.7,-0.95,0.45,-0.5,-0.85},
            {-0.95,0.15,1.35,0.45,-0.5,-0.85},	
            {-0.95,1.3,1.45,0.45,-0.5,1.35},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.95,0.7,-0.95,0.45,-0.5,-0.85},
            {-0.95,0.15,1.35,0.45,-0.5,-0.85},		
            {-0.95,1.3,1.45,0.45,-0.5,1.35},	
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:care_bears_oven', {
    drawtype = 'mesh',
    mesh = 'care_bears_oven.obj',
    tiles ={'care_bears_oven.png'}, 
    description= care_bears_oven_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,-0.5,0.5,-0.5,0.5},
            	
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,-0.5,0.5,-0.5,0.5},	
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:care_bears_blender', {
    drawtype = 'mesh',
    mesh = 'care_bears_blender.obj',
    tiles ={'care_bears_blender.png'}, 
    description= care_bears_blender_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.1,0,-0.1,0.1,-0.5,0.1},
                
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.1,0,-0.1,0.1,-0.5,0.1},
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:care_bears_showercloud', {
    drawtype = 'mesh',
    mesh = 'care_bears_showercloudMD'..model_detail..'.obj',
    tiles ={'care_bears_showercloud.png'}, 
    description= care_bears_showercloud_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,0,-0.25,0.5,0.5,0.25},
                
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,0,-0.25,0.5,0.5,0.25},
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:care_bears_giant_flower', {
    drawtype = 'mesh',
    walkable = false,    
    mesh = 'care_bears_giant_flowerMD'..model_detail..'.obj',
    tiles ={'care_bears_giant_flower.png'}, 
    description= care_bears_giant_flower_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.05,-0.5,-0.05,0.05,0.7,0.05},
            {-0.5,0.7,-0.5,0.5,0.8,0.5},
                
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.05,-0.5,-0.05,0.05,0.7,0.05},
            {-0.5,0.7,-0.5,0.5,0.8,0.5},
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    pointable=true,
})


assets_warehouse.set_and_get_storage(5,5,10,10,"assets_warehouse:care_bears_giant_basquet",care_bears_giant_basquet_descripcion,'care_bears_giant_basquetMD'..model_detail..'.obj',{'care_bears_giant_basquet.png'},
{type = "fixed",fixed = {{-1.0,-0.5,-0.8,1.0,0.8,0.8},{-1.0,1.0,-0.1,1.0,2.0,0.1},},},{type = "fixed",fixed = {{-1.0,-0.5,-0.8,1.0,0.8,0.8},{-1.0,1.0,-0.1,1.0,2.0,0.1},},})

if minetest.get_modpath("mobs") then
    mobs:register_mob("assets_warehouse:care_bears_air_ballon", {
            type = "animal",
            visual_size = {x = 10, y = 10}, 
            passive = false,
            attack_type = "dogshoot",
            damage = 4,
            reach = 4,
            shoot_interval = 0.2,
            arrow = 'assets_warehouse:testarrow',
            shoot_offset = 0.5,
            knock_back = false,
            hp_min = 50,
            hp_max = 100,
            armor = 80,
            collisionbox = {-1.0,-0.5,-1.0,1.0,8.0,1.0},
            visual = "mesh",
            mesh = 'care_bears_air_gloveMD'..model_detail..'.obj',
            textures = {'care_bears_air_glove.png'}, 
            fly = true,
            view_range = 10,
            walk_velocity = 0,
            run_velocity = 0,
            jump = false,
            jump_height = 0,
            can_leap = true,
            fall_damage = 0,
            stepheight = 2.1,
            --drops = {
            --    {name = "default:mese_crystal", chance = 9, min = 0, max = 2},
            --    {name = "default:mese_crystal_fragment", chance = 1, min = 0, max = 2},
            --},
            water_damage = 0,
            lava_damage = 0,
            light_damage = 0,
            do_custom = function(self, dtime)

                -- set needed values if not already present
                if not self.v2 then
                    self.v2 = 0
                    self.max_speed_forward = 6
                    self.max_speed_reverse = 2
                    self.accel = 2
                    self.terrain_type = 3
                    self.driver_attach_at = {x = 0, y = 0, z = 0}
                    self.driver_eye_offset = {x = 0, y = 7, z = 0.8}
                    self.driver_scale = {x = 0.1, y = 0.1}
                end

                -- if driver present allow control of horse
                if self.driver then

                    mobs.drive(self, "walk", "stand", true, dtime)
                    
                    return false -- skip rest of mob functions
                end

                return true
            end,

            on_die = function(self, pos)

                -- drop saddle when horse is killed while riding
                -- also detach from horse properly
                if self.driver then
                    mobs.detach(self.driver, {x = 1, y = 0, z = 1})
                end

            end,

            on_rightclick = function(self, clicker)
                local itemstack = clicker:get_wielded_item(itemstack)
                
                -- make sure player is clicking
                if not clicker or not clicker:is_player() then
                    return
                end

                
                -- make sure tamed horse is being clicked by owner only
                if self.tamed and self.owner == clicker:get_player_name() then

                    local inv = clicker:get_inventory()

                    -- detatch player already riding horse
                    if self.driver and clicker == self.driver and itemstack.is_empty(itemstack) then

                        mobs.detach(clicker, {x = 1, y = 0, z = 1})

                    -- attach player to horse
                    elseif not self.driver
                    and itemstack.is_empty(itemstack) then

                        self.object:set_properties({stepheight = 1.1})
                        mobs.attach(self, clicker)
                    end
                end

            end
            
        })

    mobs:register_egg("assets_warehouse:care_bears_air_ballon", care_bears_air_ballon_descripcion, "care_bears_air_glove_preview.png", 0, false)
    
end

minetest.register_node('assets_warehouse:care_bears_giant_heart', {
    drawtype = 'mesh',
    mesh = 'care_bears_giant_heartMD'..model_detail..'.obj',
    tiles ={'care_bears_giant_heart.png'}, 
    description= care_bears_giant_heart_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {-2.5,-0.5,-1.5,2.5,4.0,1.5},	
    },
    collision_box = {
        type = "fixed",
        fixed = {2.5,-0.5,1.5,-2.5,4.0,-1.5},	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    pointable=true,
})