local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")

model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2
idioma = settings:get("assets_warehouse_idioma") or "espanol"

local care_bears_heart_blockdescripcion = "A block with a hole in form of heart"
local chairdescripcion = "A chair"
local care_bears_couchdescripcion = "A couch"
local care_bears_chestdescripcion = "A chest"
local care_bears_clockdescripcion = "A clock"
local care_bears_doordescripcion = "A door"

if idioma == "espanol" then
    care_bears_heart_blockdescripcion = "Un bloque con un hollo en forma de corazon"
    chairdescripcion = "Una silla"
    care_bears_couchdescripcion = "Un sofa"
    care_bears_chestdescripcion = "Un cofre"
    care_bears_clockdescripcion = "Un reloj"
    care_bears_doordescripcion = "Una puerta"

end
--
-- Aliases for map generators
--

-- All mapgens

minetest.register_alias("mapgen_stone", "default:stone")
minetest.register_alias("mapgen_water_source", "default:water_source")
minetest.register_alias("mapgen_river_water_source", "default:river_water_source")

-- Additional aliases needed for mapgen v6

minetest.register_alias("mapgen_lava_source", "default:lava_source")
minetest.register_alias("mapgen_dirt", "default:dirt")
minetest.register_alias("mapgen_dirt_with_grass", "default:dirt_with_grass")
minetest.register_alias("mapgen_sand", "default:sand")
minetest.register_alias("mapgen_gravel", "default:gravel")
minetest.register_alias("mapgen_desert_stone", "default:desert_stone")
minetest.register_alias("mapgen_desert_sand", "default:desert_sand")
minetest.register_alias("mapgen_dirt_with_snow", "default:dirt_with_snow")
minetest.register_alias("mapgen_snowblock", "default:snowblock")
minetest.register_alias("mapgen_snow", "default:snow")
minetest.register_alias("mapgen_ice", "default:ice")

minetest.register_alias("mapgen_tree", "default:tree")
minetest.register_alias("mapgen_leaves", "default:leaves")
minetest.register_alias("mapgen_apple", "default:apple")
minetest.register_alias("mapgen_jungletree", "default:jungletree")
minetest.register_alias("mapgen_jungleleaves", "default:jungleleaves")
minetest.register_alias("mapgen_junglegrass", "default:junglegrass")
minetest.register_alias("mapgen_pine_tree", "default:pine_tree")
minetest.register_alias("mapgen_pine_needles", "default:pine_needles")

minetest.register_alias("mapgen_cobble", "default:cobble")
minetest.register_alias("mapgen_stair_cobble", "stairs:stair_cobble")
minetest.register_alias("mapgen_mossycobble", "default:mossycobble")
minetest.register_alias("mapgen_stair_desert_stone", "stairs:stair_desert_stone")

minetest.register_biome({
    name = "AW_forestoffelings",
    node_top = "default:dirt_with_grass",
    depth_top = 1,
    node_filler = "default:dirt",
    depth_filler = 1,
    node_riverbed = "default:sand",
    depth_riverbed = 2,
    node_dungeon = "default:cobble",
    node_dungeon_alt = "default:mossycobble",
    node_dungeon_stair = "stairs:stair_cobble",
    y_max = 31000,
    y_min = -31000,
    heat_point = 50,
    humidity_point = 35,
})


minetest.register_node('assets_warehouse:care_bears_flower3', {
    drawtype = 'mesh',
    mesh = 'care_bears_flowers3MD'..model_detail..'.obj',
    tiles ={'care_bears_flowers3.png'}, 
    description= 'Flowers',
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,-0.5,0.5,-0.5,0.5},	
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,-0.5,0.5,-0.5,0.5},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=false,
    pointable=true,
})


minetest.register_node('assets_warehouse:care_bears_tree2', {
    drawtype = 'mesh',
    mesh = 'care_bears_tree2MD'..model_detail..'.obj',
    tiles ={'care_bears_cloud_block.png^[colorize:brown#7:255]'}, 
    description= 'Tree',
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,1.0,-0.5,0.5,-0.5,0.5},	
            {-0.5,1.5,0,0,1.0,0.5},	
            {0,1.5,-0.5,0.5,1.0,0},	
            {-0.5,2.0,0,0,1.5,0.5},	
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,1.0,-0.5,0.5,-0.5,0.5},	
            {-0.5,1.5,0,0,1.0,0.5},	
            {0,1.5,-0.5,0.5,1.0,0},	
            {-0.5,2.0,0,0,1.5,0.5},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})
minetest.register_node('assets_warehouse:care_bears_tree2_leaves', {
    drawtype = 'mesh',
    mesh = 'care_bears_cloud_deco_leavesMD'..model_detail..'.obj',
    tiles ={'care_bears_cloud_block.png^[colorize:green#7:255]'}, 
    description= 'Cloud2',
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=true,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,-0.5,0.5,-0.5,0.5},	
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,-0.5,0.5,-0.5,0.5},
        },	
    },
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=false,
    pointable=true,
    paramtype = "light",
})

minetest.register_node('assets_warehouse:care_bears_tree3', {
    drawtype = 'mesh',
    mesh = 'care_bears_tree3MD'..model_detail..'.obj',
    tiles ={'care_bears_tree3.png'}, 
    description= 'Tree',
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,1.0,-0.5,0.5,-0.5,0.5},	
            {-0.5,1.5,0,0,1.0,0.5},	
            {0,1.5,-0.5,0.5,1.0,0},	
            {-0.5,2.0,0,0,1.5,0.5},	
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,1.0,-0.5,0.5,-0.5,0.5},	
            {-0.5,1.5,0,0,1.0,0.5},	
            {0,1.5,-0.5,0.5,1.0,0},	
            {-0.5,2.0,0,0,1.5,0.5},
        },	
    },
    sunlight_propagates=true,
    paramtype = "light",
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_decoration({
    name = "assets_warehouse:care_bears_cloud_deco",
    deco_type = "simple",
    place_on = {"default:dirt_with_grass"},
    sidelen = 10,
    biomes = {"AW_forestoffelings"},
    y_max = 31000,
    y_min = 1,
    rotation = "random",
    decoration = "assets_warehouse:care_bears_cloud_deco",
})

minetest.register_decoration({
    name = "assets_warehouse:care_bears_tree3_deco",
    deco_type = "simple",
    place_on = {"default:dirt_with_grass"},
    sidelen = 10,
    biomes = {"AW_forestoffelings"},
    y_max = 31000,
    y_min = 1,
    rotation = "random",
    decoration = "assets_warehouse:care_bears_tree3",
})

minetest.register_decoration({
    name = "assets_warehouse:care_bears_cloud_block",
    deco_type = "simple",
    place_on = {"default:dirt_with_grass"},
    sidelen = 16,
    biomes = {"AW_forestoffelings"},
    y_max = 31000,
    y_min = 1,
    rotation = "random",
    decoration = "assets_warehouse:care_bears_cloud_block",
})

minetest.register_decoration({
    name = "assets_warehouse:care_bears_heart_flower",
    deco_type = "simple",
    place_on = {"default:dirt_with_grass"},
    sidelen = 16,
    biomes = {"AW_forestoffelings"},
    y_max = 31000,
    y_min = 1,
    rotation = "random",
    decoration = "assets_warehouse:care_bears_flower",
})

minetest.register_decoration({
    name = "assets_warehouse:care_bears_heart_flowers",
    deco_type = "simple",
    place_on = {"default:dirt_with_grass"},
    sidelen = 16,
    biomes = {"AW_forestoffelings"},
    y_max = 31000,
    y_min = 1,
    rotation = "random",
    decoration = "assets_warehouse:care_bears_heart_flowers",
})

minetest.register_decoration({
    name = "assets_warehouse:care_bears_flower3",
    deco_type = "simple",
    place_on = {"default:dirt_with_grass"},
    sidelen = 16,
    biomes = {"AW_forestoffelings"},
    y_max = 31000,
    y_min = 1,
    rotation = "random",
    decoration = "assets_warehouse:care_bears_flower3",
})



minetest.register_decoration({
    name = "assets_warehouse:care_bears_tree",
    deco_type = "simple",
    place_on = {"default:dirt_with_grass"},
    sidelen = 16,
    biomes = {"AW_forestoffelings"},
    y_max = 31000,
    y_min = 1,
    rotation = "random",
    decoration = "assets_warehouse:care_bears_tree",
})

minetest.register_decoration({
    name = "assets_warehouse:tree2",
    deco_type = "schematic",
    place_on = {"default:dirt_with_grass"},
    sidelen = 16,
    noise_params = {
        offset = 0.024,
        scale = 0.015,
        spread = {x = 250, y = 250, z = 250},
        seed = 2,
        octaves = 3,
        persist = 0.66
    },
    --place_offset_y = 0,
    biomes = {"AW_forestoffelings"},
    y_max = 31000,
    y_min = 1,
    rotation = "random",
    flags = "place_center_x, place_center_z",
    --decoration = 'default:tree',
    schematic = minetest.get_modpath("assets_warehouse") .. "/schematics/care_bears_tre_shcem.mts",
})

--
--Cloud deco
minetest.register_node('assets_warehouse:care_bears_cloud_deco', {
    color = "white",
    paramtype2 = "color",
    drawtype = 'mesh',
    mesh = 'care_bears_cloud_decoMD'..model_detail..'.obj',
    tiles ={'care_bears_cloud_block.png'}, 
    description= 'Cloud',
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=true,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,-0.5,0.5,-0.5,0.5},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,-0.5,0.5,-0.5,0.5},	
        },	
    },
    sunlight_propagates=true,
    use_texture_alpha=false,
    paramtype = "light",
    walkable=false,
    pointable=false,
})

local function register_cloud_deco(color,scale)
    minetest.register_node('assets_warehouse:care_bears_cloud_deco'..color..tostring(scale), {
        visual_scale = scale,
        drawtype = 'mesh',
        mesh = 'care_bears_cloud_decoMD'..model_detail..'.obj',
        tiles ={'care_bears_cloud_block.png^[colorize:'..color..'#7:255]'}, 
        description= 'Cloud',
        stack_max = 1,
        groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3,not_in_creative_inventory = 1},
        paramtype2 = "facedir",
        is_ground_content=true,
        climbable=false,
        buildable_to=true,
        damage_per_second=0,
        diggable=true,
        drowning=0,
        floodable=false,
        range=5.0,
        selection_box = {
            type = "fixed",
            fixed = {
                {-0.5,0.5,-0.5,0.5,-0.5,0.5},		
            },	
        },
        collision_box = {
            type = "fixed",
            fixed = {
                {-0.5,0.5,-0.5,0.5,-0.5,0.5},	
            },	
        },
        sunlight_propagates=true,
        paramtype = "light",
        use_texture_alpha=false,
        walkable=false,
        pointable=false,
    })
    
    minetest.register_decoration({
        name = "assets_warehouse:care_bears_cloud_deco"..color..tostring(scale),
        deco_type = "simple",
        place_on = {"default:dirt_with_grass"},
        sidelen = 10,
        biomes = {"AW_forestoffelings"},
        y_max = 31000,
        y_min = 1,
        rotation = "random",
        decoration = "assets_warehouse:care_bears_cloud_deco"..color..tostring(scale),
    })

end


register_cloud_deco("red",2)
--register_cloud_deco("yellow",2)
register_cloud_deco("blue",2)
register_cloud_deco("green",2)
--register_cloud_deco("orange",2)

register_cloud_deco("red",4)
--register_cloud_deco("yellow",4)
register_cloud_deco("blue",4)
register_cloud_deco("green",4)
--register_cloud_deco("orange",4)

------------------------------------------------------------
--flowers
minetest.register_node('assets_warehouse:care_bears_flower4', {
    drawtype = 'mesh',
    mesh = 'care_bears_flowers4.obj',
    tiles ={'care_bears_cloud_block.png^[colorize:yellow#9:255]'}, 
    description= 'Flowers',
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,-0.5,0.5,-0.5,0.5},	
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,-0.5,0.5,-0.5,0.5},
        },	
    },
    sunlight_propagates=true,
    paramtype = "light",
    use_texture_alpha=false,
    walkable=false,
    pointable=true,
})




local function register_flower_deco(color)
    minetest.register_node('assets_warehouse:care_bears_flower4'..color, {
        drawtype = 'mesh',
        mesh = 'care_bears_flowers4.obj',
        tiles ={'care_bears_cloud_block.png^[colorize:'..color..'#9:255]'}, 
        description= 'Flowers',
        stack_max = 1,
        groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3,not_in_creative_inventory=1},
        paramtype2 = "facedir",
        is_ground_content=true,
        climbable=false,
        buildable_to=false,
        damage_per_second=0,
        diggable=true,
        drowning=0,
        floodable=false,
        range=5.0,
        selection_box = {
            type = "fixed",
            fixed = {
                {-0.5,0.5,-0.5,0.5,-0.5,0.5},	
            },	
        },
        collision_box = {
            type = "fixed",
            fixed = {
                {-0.5,0.5,-0.5,0.5,-0.5,0.5},
            },	
        },
        sunlight_propagates=true,
        paramtype = "light",
        use_texture_alpha=false,
        walkable=false,
        pointable=true,
    })

    minetest.register_decoration({
        name = "assets_warehouse:care_bears_flower4"..color,
        deco_type = "simple",
        place_on = {"default:dirt_with_grass"},
        sidelen = 16,
        biomes = {"AW_forestoffelings"},
        y_max = 31000,
        y_min = 1,
        rotation = "random",
        decoration = "assets_warehouse:care_bears_flower4"..color,
    })



end

register_flower_deco("red")
register_flower_deco("green")
register_flower_deco("blue")


minetest.register_node('assets_warehouse:care_bears_heart_block', {
    drawtype = 'mesh',
    mesh = 'care_bears_heart_block.obj',
    tiles ={'default_acacia_tree.png'}, 
    description= care_bears_heart_blockdescripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,-0.5,0.5,-0.5,0.5},	
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,-0.5,0.5,-0.5,0.5},
        },	
    },
    sunlight_propagates=true,
    use_texture_alpha=false,
    paramtype = "light",
    pointable=true,
})



minetest.register_node('assets_warehouse:care_bears_chair', {
    drawtype = 'mesh',
    mesh = 'care_bears_chairMD'..model_detail..'.obj',
    tiles ={'care_bears_chair.png'}, 
    description= chairdescripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    selection_box = {
        type = "fixed",
        fixed = {
            {0.25,0,0.5,-0.25,-0.5,-0.05},
            {0.25,0.7,0.5,-0.25,0.0,0.4},
                    
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {0.25,0,0.5,-0.25,-0.5,-0.05},
            {0.25,0.7,0.5,-0.25,0.0,0.4},
                    
        },	
    },
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:care_bears_couch', {
    drawtype = 'mesh',
    mesh = 'care_bears_couch.obj',
    tiles ={'care_bears_couch.png'}, 
    description= care_bears_couchdescripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    selection_box = {
        type = "fixed",
        fixed = {
            {0.5,0,0.5,-0.5,-0.5,-0.5},
            {0.5,1.0,0.5,-0.5,0.0,0.3},
                    
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {0.5,0,0.5,-0.5,-0.5,-0.5},
            {0.5,1.0,0.5,-0.5,0.0,0.3},
                    
        },	
    },
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    sunlight_propagates=true,
    paramtype = "light",
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})


assets_warehouse.set_and_get_storage(5,5,1,10,"assets_warehouse:care_bears_chest",care_bears_chestdescripcion,'peppert_bedrom_chestMD'..model_detail..'.obj',{'care_bears_chest.png'},{type = "fixed",
fixed = {{-0.41,0.5,-0.45,1.41,-0.5,0.45},},},{type = "fixed",fixed = {{-0.41,0.5,-0.45,1.41,-0.5,0.45},},})

minetest.register_node('assets_warehouse:care_bears_clock', {
    drawtype = 'mesh',
    mesh = 'care_bears_clockMD'..model_detail..'.obj',
    tiles ={'care_bears_clock.png'}, 
    description= care_bears_clockdescripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    selection_box = {
        type = "fixed",
        fixed = {
            {0.5,2.5,0.5,-0.5,-0.5,0},
                    
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {0.5,2.5,0.5,-0.5,-0.5,0},
                    
        },	
    },
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
    paramtype = "light",
})

doors.register("care_bears_door", {
        tiles = {{ name = "care_bears_door.png", backface_culling = true }},
        description = care_bears_doordescripcion,
        inventory_image = "doors_item_wood.png",
        groups = {node = 1, choppy = 2, oddly_breakable_by_hand = 2, flammable = 2},
        gain_open = 0.06,
        gain_close = 0.13,
        recipe = {
            {"group:wood", "group:wood"},
            {"group:wood", "group:wood"},
            {"group:wood", "group:wood"},
        }
})