local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")
local idioma = settings:get("assets_warehouse_idioma") or "espanol"


model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2

local flagoffrance = "Flag of France"
local flagofgermany = "Flag of Germany "
local flagofrusia = "Flag of Rusia"
local flagofvenezuela = "Flag of Venezuela"
local flagofmexico = "Flag of Mexico"
local flagoftemplars = "Flag of the Templar Knights,ours protectors agains the assassins"
local flagof26Julio = "Flag of the 26 of July movement"
local flagofCuba = "Flag of Cuba,my country"

if idioma == "espanol" then
    flagoffrance = "Flag of France"
    flagofgermany = "Flag of Germany "
    flagofrusia = "Flag of Rusia"
    flagofvenezuela = "Flag of Venezuela"
    flagofmexico = "Flag of Mexico"
    flagoftemplars = "Flag of the Templar Knights,ours protectors agains the assassins"
    flagof26Julio = "Flag of M26 of July"
    flagofCuba = "Flag of Cuba,my country"

end

minetest.register_node('assets_warehouse:flagM26_7', {
    drawtype = 'mesh',
    mesh = 'flagM26_7.obj',
    tiles ={'flagM26_7.png'}, 
    description= flagof26Julio,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-1.5,0.5,0.35,0.5,-0.5,0.5},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-1.5,0.5,0.45,0.5,-0.5,0.5},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=true,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:flagCuba', {
    drawtype = 'mesh',
    mesh = 'flagCuba.obj',
    tiles ={'flagCuba.png'}, 
    description= flagofCuba,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-1.5,0.5,0.35,0.5,-0.5,0.5},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-1.5,0.5,0.45,0.5,-0.5,0.5},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=true,
    walkable=true,
    pointable=true,
})


minetest.register_node('assets_warehouse:flagMexico', {
    drawtype = 'mesh',
    mesh = 'flagMexico.obj',
    tiles ={'flagMexico.png'}, 
    description= flagofmexico,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-1.25,0.5,0.35,0.5,-0.5,0.5},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-1.25,0.5,0.45,0.5,-0.5,0.5},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=true,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:flagVenezuela', {
    drawtype = 'mesh',
    mesh = 'flagVenezuela.obj',
    tiles ={'flagVenezuela.png'}, 
    description= flagofvenezuela,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-1,0.5,0.35,0.5,-0.5,0.5},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-1,0.5,0.45,0.5,-0.5,0.5},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=true,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:flagKnightsTemplar', {
    drawtype = 'mesh',
    mesh = 'flagKnightsTemplar.obj',
    tiles ={'flagKnightsTemplar.png'}, 
    description= flagoftemplars,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,0.35,0.5,-0.5,0.5},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,0.45,0.5,-0.5,0.5},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=true,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:flaggermany', {
    drawtype = 'mesh',
    mesh = 'flaggermany.obj',
    tiles ={'flaggermany.png'}, 
    description= flagofgermany,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-1.2,0.5,0.35,0.5,-0.5,0.5},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-1.2,0.5,0.45,0.5,-0.5,0.5},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=true,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:flagRussia', {
    drawtype = 'mesh',
    mesh = 'flagRussia.obj',
    tiles ={'flagRussia.png'}, 
    description= flagofrusia,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-1.5,0.5,0.35,0.5,-0.5,0.5},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-1.5,0.5,0.45,0.5,-0.5,0.5},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=true,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:flagFrance', {
    drawtype = 'mesh',
    mesh = 'flagFrance.obj',
    tiles ={'flagFrance.png'}, 
    description= flagoffrance,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-1.0,0.5,0.35,0.5,-0.5,0.5},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-1.0,0.5,0.45,0.5,-0.5,0.5},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=true,
    walkable=true,
    pointable=true,
})