local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")

model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2

local idioma = settings:get("assets_warehouse_idioma") or "espanol"

local flowers_crown_descripcion = "For a little bear"
local uniform_descripcion = "A green island uniform"
local egyptian_hat_descripcion = "A egyptian hat"
local egyptian_tiara_descripcion = "A egyptian tiara"
local ushanka_rusian_hat_descripcion = "A rusian hat"
local hair_ribborns_descripcion = "From a smart girl"

if idioma == "espanol" then
    flowers_crown_descripcion = "Para un pequeno oso"
    uniform_descripcion = "Uniforme de isla verde"
    egyptian_hat_descripcion = "Un sombrero egypcio"
    egyptian_tiara_descripcion = "Una tiara egypcia"
    ushanka_rusian_hat_descripcion = "Un sombrero ruso"
    hair_ribborns_descripcion = "De una chica inteligente"
end

assets_warehouse.cloth("assets_warehouse:flowers_crown",{
    mesh ='flowers_crownMD'..model_detail..'.obj',
    texture = {'flowers_crown.png'},
    wield = "flowers_crownpreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,0.05,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
    description = flowers_crown_descripcion,
    cloth_type = "hat",
})

assets_warehouse.cloth("assets_warehouse:minint_uniform",{
    mesh ='minint_uniform.b3d',
    texture = {'minint_uniform.png'},
    wield = "minint_uniform_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = uniform_descripcion,
    cloth_type = "shirt",
    texture_mask = "minint_uniform_mask.png"--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehouse:egyptian_hat",{
    mesh ='egyptian_hat.obj',
    texture = {'egyptian_hat.png'},
    wield = "egyptian_hat_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,0.05,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
    description = egyptian_hat_descripcion,
    cloth_type = "hat",
})


assets_warehouse.cloth("assets_warehouse:egyptian_tiara",{
    mesh ='egyptian_tiara.obj',
    texture = {'egyptian_hat.png'},
    wield = "egyptian_diadema_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,0.05,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
    description = egyptian_tiara_descripcion,
    cloth_type = "hat",
})

assets_warehouse.cloth("assets_warehouse:ushanka_rusian_hat",{
    mesh ='ushankaMD1.obj',
    texture = {'ushanka.png'},
    wield = "ushanka_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = ushanka_rusian_hat_descripcion,
    cloth_type = "hat",
    texture_mask = "default_mask_hat.png"--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehouse:hair_ribborns",{
    mesh ='hair_ribbornsMD'..model_detail..'.obj',
    texture = {'hair_ribborns.png'},
    wield = "hair_ribborns_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = hair_ribborns_descripcion,
    cloth_type = "hat",
    texture_mask = "default_mask_hat.png"--"minint_uniform_texture_mask.png"
    
})

