
local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")


model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2
local idioma = settings:get("assets_warehouse_idioma") or "espanol"

local peppert_and_carrot_bedrom_chest_descripcion = "A chest"
local peppert_and_carrot_table_descripcion = "A table"
local peppert_and_carrot_wardrobe_descripcion = "Un guardarropas"
local peppert_and_carrot_cristall_ball_descripcion = "A crystall ball"
local peppert_and_carrot_little_chair_descripcion = "A little chair"
local peppert_and_carrot_floordeco_descripcion = "A deco for the floor based in those in peppert bedroom"
local peppert_and_carrot_mirror_descripcion = "A magic mirror who only function with magic"
local peppert_and_carrot_winner_ribborn_descripcion = 'Medal for "win" the potion contest'
local peppert_and_carrot_mushroom_fake_poison_descripcion = "A mushroom who can be eated or nod?"
local peppert_and_carrot_acren_symbol_descripcion = "Symbol of the Acren kindom "
local peppert_and_carrot_dentist_dragon_tool_decripcion = "For the dragons"
local peppert_and_carrot_dragon_teeth_descripcion = "Dragon tooth"
local peppert_and_carrot_water_tree_descripcion = "The mystical water tree"
local peppert_and_carrot_fliying_broom_descripcion = "Just a fliying broom like many"
local peppert_and_carrot_pumkpinstardescripcion ='Pumpking in form of star'
local peppert_and_carrot_zafron_house_furnituredescripcion = 'A furniture from the house of zafron'
local peppert_and_carrot_shichimi_little_cauldrondescripcion = "A little cauldron from Shichimi"


if idioma == "espanol" then
    peppert_and_carrot_bedrom_chest_descripcion = "Un cofre"
    peppert_and_carrot_table_descripcion = "Una mesa"
    peppert_and_carrot_wardrobe_descripcion = "Un guardarropa"
    peppert_and_carrot_cristall_ball_descripcion = "Una bola de cristal"
    peppert_and_carrot_little_chair_descripcion = "Una pequeña silla"
    peppert_and_carrot_floordeco_descripcion = "Una decoracion para el suelo basada en la habitacion de Peppert"
    peppert_and_carrot_mirror_descripcion = "Un espejo magico que solo funciona con magia"
    peppert_and_carrot_winner_ribborn_descripcion = "Medalla por 'ganar' el concurso de pociones"
    peppert_and_carrot_mushroom_fake_poison_descripcion = "Un hongo que puede comerse o no?"
    peppert_and_carrot_acren_symbol_descripcion = "Simbolo del reino de Acren"
    peppert_and_carrot_dentist_dragon_tool_decripcion = "Para los dragones"
    peppert_and_carrot_dragon_teeth_descripcion = "Diente de dragon"
    peppert_and_carrot_water_tree_descripcion = "El mistico arbol de agua"
    peppert_and_carrot_fliying_broom_descripcion = "Solo una escoba voladora como muchas"
    peppert_and_carrot_pumkpinstardescripcion = "Una calabaza en forma de estrella"
    peppert_and_carrot_zafron_house_furnituredescripcion = "Un mueble de la casa de Zafron"
    peppert_and_carrot_shichimi_little_cauldrondescripcion = "Un pequeño caldero de Shichimi "
end

assets_warehouse.set_and_get_storage(5,5,1,10,"assets_warehouse:peppert_and_carrot_bedrom_chest",peppert_and_carrot_bedrom_chest_descripcion,'peppert_bedrom_chestMD'..model_detail..'.obj',{'peppert_bedrom_chestTQ'..texture_detail..'.png'},{type = "fixed",
fixed = {{-0.41,0.5,-0.45,1.41,-0.5,0.45},},},{type = "fixed",fixed = {{-0.41,0.5,-0.45,1.41,-0.5,0.45},},})

assets_warehouse.set_and_get_storage(5,5,1,8,"assets_warehouse:peppert_and_carrot_table",peppert_and_carrot_table_descripcion,'peppert_and_carrot_table.obj',{'peppert_and_carrot_tableTQ'..texture_detail..'.png'},
{type = "fixed",fixed = {{-1.25,0.5,-0.48,1.25,-0.5,0.48},},},{type = "fixed",fixed = {{-1.25,0.5,-0.48,1.25,-0.5,0.48},},})
	

assets_warehouse.set_and_get_storage(5,5,3,5,"assets_warehouse:peppert_and_carrot_wardrobe",peppert_and_carrot_wardrobe_descripcion,'peppert_and_carrot_wardrobe.obj',{'peppert_and_carrot_wardrobeTQ'..texture_detail..'.png'},
{type = "fixed",fixed = {{-1.2,1.5,-0.5,1.2,-0.5,0.5},},},{type = "fixed",fixed = {{-1.2,1.5,-0.5,1.2,-0.5,0.5},},})
 
minetest.register_node('assets_warehouse:peppert_and_carrot_cristall_ball', {
	drawtype = 'mesh',
	mesh = 'peppert_and_carrot_cristall_ballMD'..model_detail..'.obj',
	tiles ={'peppert_and_carrot_cristall_ball.png'}, 
	description= peppert_and_carrot_cristall_ball_descripcion,
	stack_max = 1,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
	paramtype2 = "facedir",
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=0,
	diggable=true,
	drowning=0,
	floodable=false,
	range=5.0,
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.2,0,-0.2,0.2,-0.5,0.2},		
		},	
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.2,0,-0.2,0.2,-0.5,0.2},	
		},	
	},
    paramtype = "light",
	sunlight_propagates=true,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
})

minetest.register_node('assets_warehouse:peppert_and_carrot_little_chair', {
	drawtype = 'mesh',
	mesh = 'peppert_and_carrot_little_chairMD'..model_detail..'.obj',
	tiles ={'peppert_and_carrot_little_chairTQ'..texture_detail..'.png'}, 
	description= peppert_and_carrot_little_chair_descripcion,
	stack_max = 1,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
	paramtype2 = "facedir",
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=0,
	diggable=true,
	drowning=0,
	floodable=false,
	range=5.0,
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.3,-0.05,-0.3,0.3,-0.5,0.3},		
		},	
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.3,-0.05,-0.3,0.3,-0.5,0.3},	
		},	
	},
    paramtype = "light",
	sunlight_propagates=true,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
})

minetest.register_node('assets_warehouse:peppert_and_carrot_floordeco', {
	drawtype = 'mesh',
	mesh = 'peppert_and_and_carrot_floordeco.obj',
	tiles ={'peppert_and_and_carrot_floordecoTQ'..texture_detail..'.png'}, 
	description= peppert_and_carrot_floordeco_descripcion,
	stack_max = 1,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3, bed = 1},
	paramtype2 = "facedir",
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=0,
	diggable=true,
	drowning=0,
	floodable=false,
	range=5.0,
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.5,-0.4,-5.5,5.5,-0.5,1.5},		
		},	
	},
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,-0.4,-5.5,5.5,-0.5,1.5},		
        },	
    },
    paramtype = "light",
	sunlight_propagates=false,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
})

minetest.register_node('assets_warehouse:peppert_and_carrot_mirror', {
	drawtype = 'mesh',
	mesh = 'peppert_and_carrot_mirrorMD'..model_detail..'.obj',
	tiles ={'peppert_and_carrot_mirrorTQ'..texture_detail..'.png'}, 
	description= peppert_and_carrot_mirror_descripcion,
	stack_max = 1,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
	paramtype2 = "facedir",
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=0,
	diggable=true,
	drowning=0,
	floodable=false,
	range=5.0,
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.5,1.5,-0.05,0.5,-0.5,0.05},		
		},	
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.5,1.5,-0.05,0.5,-0.5,0.05},		
		},	
	},
    paramtype = "light",
	sunlight_propagates=true,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
})

minetest.register_node('assets_warehouse:peppert_and_carrot_winner_ribborn', {
    drawtype = 'mesh',
    mesh = 'peppert_and_carrot_winner_ribbornMD'..model_detail..'.obj',
    tiles ={'peppert_and_carrot_winner_ribborn.png'}, 
    description= peppert_and_carrot_winner_ribborn_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.1,0.4,0.5,0.1,-0.5,0.4},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.1,0.4,0.5,0.1,-0.5,0.4},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=true,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:peppert_and_carrot_mushroom', {
    drawtype = 'mesh',
    mesh = 'peppert_and_carrot_mushroomMD'..model_detail..'.obj',
    tiles ={'peppert_and_carrot_mushroom.png'}, 
    description= peppert_and_carrot_mushroom_fake_poison_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    on_use = minetest.item_eat(2),
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.2,-0.3,0.2,0.2,-0.5,-0.2},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.2,-0.3,0.2,0.2,-0.5,-0.2},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=true,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:peppert_and_carrot_mushroom_poison', {
    drawtype = 'mesh',
    mesh = 'peppert_and_carrot_mushroomMD'..model_detail..'.obj',
    tiles ={'peppert_and_carrot_mushroom_poison.png'}, 
    description= peppert_and_carrot_mushroom_fake_poison_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    on_use = minetest.item_eat(-10),
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.2,-0.3,0.2,0.2,-0.5,-0.2},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.2,-0.3,0.2,0.2,-0.5,-0.2},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=true,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:peppert_and_carrot_mushroom_fake_poison', {
    drawtype = 'mesh',
    mesh = 'peppert_and_carrot_mushroomMD'..model_detail..'.obj',
    tiles ={'peppert_and_carrot_mushroom_poison.png'}, 
    description= peppert_and_carrot_mushroom_fake_poison_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    on_use = minetest.item_eat(2),
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.2,-0.3,0.2,0.2,-0.5,-0.2},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.2,-0.3,0.2,0.2,-0.5,-0.2},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=true,
    walkable=true,
    pointable=true,
})





minetest.register_node('assets_warehouse:peppert_and_carrot_acren_symbol', {
    drawtype = 'mesh',
    mesh = 'peppert_and_carrot_acren_symbol.obj',
    tiles ={'peppert_and_carrot_acren_symbol.png'}, 
    description= peppert_and_carrot_acren_symbol_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,0.35,0.5,-0.5,0.4},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,0.45,0.5,-0.5,0.5},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=true,
    walkable=true,
    pointable=true,
})





minetest.register_node('assets_warehouse:peppert_and_carrot_dentist_dragon_tool', {
    drawtype = 'mesh',
    mesh = 'peppert_and_carrot_dentist_dragon_tool.obj',
    tiles ={'peppert_and_carrot_dentist_dragon_tool.png'}, 
    description= peppert_and_carrot_dentist_dragon_tool_decripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.25,0.5,0.15,0.25,-0.5,-0.15},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.25,0.5,0.15,0.25,-0.5,-0.15},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=true,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:peppert_and_carrot_dragon_teeth', {
    drawtype = 'mesh',
    mesh = 'peppert_and_carrot_dragon_teeth.obj',
    tiles ={'peppert_and_carrot_dragon_teeth.png'}, 
    description= peppert_and_carrot_dragon_teeth_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,0.5,2.0,-0.5,-0.5},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,0.5,2.0,-0.5,-0.5},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=true,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:peppert_and_carrot_water_tree', {
    drawtype = 'mesh',
    mesh = 'peppert_and_carrot_watertreeMD'..model_detail..'.obj',
    tiles ={'peppert_and_carrot_watertree.png'}, 
    description= peppert_and_carrot_water_tree_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    --glow = 7,
    light_source = 14,
    floodable=false,
    range=5.0,
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_abm({
        label = "Water Tree Water",
        nodenames = {"assets_warehouse:peppert_and_and_carrot_water_tree"},
        neighbors = {"air"},
        interval = 2,
        chance = 2,
        catch_up = false,
        action = function(pos, node, active_object_count, active_object_count_wider)
            --minetest.get_node(pos)
            local around = {
                {x=pos.x+1,y=pos.y,z=pos.z},
                {x=pos.x-1,y=pos.y,z=pos.z},
                {x=pos.x,y=pos.y,z=pos.z+1},
                {x=pos.x,y=pos.y,z=pos.z-1},
                {x=pos.x+1,y=pos.y,z=pos.z+1},
                {x=pos.x-1,y=pos.y,z=pos.z+1},
                {x=pos.x+1,y=pos.y,z=pos.z-1},
                {x=pos.x-1,y=pos.y,z=pos.z-1},
            }
            for _,item in ipairs(around) do
                local node = minetest.get_node(item)
                if node.name == "air" then
                    local pos2 = ({x=item.x,y=item.y-1,z=item.z})
                    if minetest.get_node(pos2).name == "air" then
                        minetest.set_node(pos2, {name = "default:water_source"})
                    end
                end
            end
        end,
    })

if minetest.get_modpath("mobs") then
    mobs:register_mob("assets_warehouse:peppert_and_carrot_fliying_broom", {
            type = "animal",
            visual_size = {x = 10, y = 10}, 
            passive = false,
            attack_type = "dogshoot",
            damage = 4,
            reach = 4,
            shoot_interval = 0.2,
            arrow = 'assets_warehouse:testarrow',
            shoot_offset = 0.5,
            knock_back = false,
            hp_min = 50,
            hp_max = 100,
            armor = 80,
            collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 1},
            visual = "mesh",
            mesh = 'peppert_and_carrot_fliying_broomMD'..model_detail..'.obj',
            textures = {'peppert_and_carrot_broom.png'}, 
            fky = true,
            view_range = 10,
            walk_velocity = 0,
            run_velocity = 0,
            jump = false,
            jump_height = 0,
            can_leap = true,
            fall_damage = 0,
            stepheight = 2.1,
            --drops = {
            --    {name = "default:mese_crystal", chance = 9, min = 0, max = 2},
            --    {name = "default:mese_crystal_fragment", chance = 1, min = 0, max = 2},
            --},
            water_damage = 0,
            lava_damage = 0,
            light_damage = 0,
            do_custom = function(self, dtime)

                -- set needed values if not already present
                if not self.v2 then
                    self.v2 = 0
                    self.max_speed_forward = 6
                    self.max_speed_reverse = 2
                    self.accel = 2
                    self.terrain_type = 3
                    self.driver_attach_at = {x = 0, y = 0, z = 0}
                    self.driver_eye_offset = {x = 0, y = 0.5, z = 0.2}
                    self.driver_scale = {x = 0.1, y = 0.1}
                end

                -- if driver present allow control of horse
                if self.driver then

                    mobs.drive(self, "walk", "stand", true, dtime)
                    
                    return false -- skip rest of mob functions
                end

                return true
            end,

            on_die = function(self, pos)

                -- drop saddle when horse is killed while riding
                -- also detach from horse properly
                if self.driver then
                    mobs.detach(self.driver, {x = 1, y = 0, z = 1})
                end

            end,

            on_rightclick = function(self, clicker)
                local itemstack = clicker:get_wielded_item(itemstack)
                
                -- make sure player is clicking
                if not clicker or not clicker:is_player() then
                    return
                end

                
                -- make sure tamed horse is being clicked by owner only
                if self.tamed and self.owner == clicker:get_player_name() then

                    local inv = clicker:get_inventory()

                    -- detatch player already riding horse
                    if self.driver and clicker == self.driver and itemstack.is_empty(itemstack) then

                        mobs.detach(clicker, {x = 1, y = 0, z = 1})

                    -- attach player to horse
                    elseif not self.driver
                    and itemstack.is_empty(itemstack) then

                        self.object:set_properties({stepheight = 1.1})
                        mobs.attach(self, clicker)
                    end
                end

            end
            
        })

    mobs:register_egg("assets_warehouse:peppert_and_carrot_fliying_broom", peppert_and_carrot_fliying_broom_descripcion, "peppert_and_carrot_fliying_broom.png", 0, false)
    
end

minetest.register_node('assets_warehouse:peppert_and_carrot_pumpkinstar', {
    drawtype = 'mesh',
    mesh = 'peppert_and_carrot_pumkpinstarMD'..model_detail..'.obj',
    tiles ={'peppert_and_carrot_pumkpinstar.png'}, 
    description= peppert_and_carrot_pumkpinstardescripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.25,-0.5,-0.25,0.25,-0.25,0.25},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.25,0.25,-0.25,0.25,-0.25,0.25},		
        },	
    },
    on_use = minetest.item_eat(4),
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

assets_warehouse.set_and_get_storage(5,5,2,2,"assets_warehouse:peppert_and_carrot_zafron_house_furniture",peppert_and_carrot_zafron_house_furnituredescripcion,'peppert_and_carrot_zafron_house_furniture.obj',{'peppert_and_carrot_zafron_house_furniture.png'},
{type = "fixed",fixed = {{-0.5,-0.5,-0.5,0.5,0.5,0.5},},},{type = "fixed",fixed = {{-0.5,-0.5,-0.5,0.5,0.5,0.5},},})


assets_warehouse.set_and_get_storage(5,5,1,1,"assets_warehouse:peppert_and_carrot_shichimi_little_cauldron",peppert_and_carrot_shichimi_little_cauldrondescripcion,'peppert_and_carrot_shichimi_little_cauldronMD'..model_detail..'.obj',{'peppert_and_carrot_shichimi_little_cauldron.png'},
{type = "fixed",fixed = {{-0.15,-0.5,-0.15,0.15,-0.25,0.15},},},{type = "fixed",fixed = {{-0.15,-0.5,-0.15,0.15,-0.25,0.15},},})
